/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Function;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.MongoCursor;

class MongoMappingCursor<T, U>
implements MongoCursor<U> {
    private final MongoCursor<T> proxied;
    private final Function<T, U> mapper;

    public MongoMappingCursor(MongoCursor<T> proxied, Function<T, U> mapper) {
        this.proxied = (MongoCursor)Assertions.notNull((String)"proxied", proxied);
        this.mapper = (Function)Assertions.notNull((String)"mapper", mapper);
    }

    @Override
    public void close() {
        this.proxied.close();
    }

    @Override
    public boolean hasNext() {
        return this.proxied.hasNext();
    }

    @Override
    public U next() {
        return (U)this.mapper.apply(this.proxied.next());
    }

    @Override
    public U tryNext() {
        T proxiedNext = this.proxied.tryNext();
        if (proxiedNext == null) {
            return null;
        }
        return (U)this.mapper.apply(proxiedNext);
    }

    @Override
    public void remove() {
        this.proxied.remove();
    }

    @Override
    public ServerCursor getServerCursor() {
        return this.proxied.getServerCursor();
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.proxied.getServerAddress();
    }
}

