/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObjectFactory;
import com.mongodb.DBObject;
import com.mongodb.DBObjectFactory;
import com.mongodb.DBRef;
import com.mongodb.assertions.Assertions;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonDbPointer;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.IdGenerator;
import org.bson.codecs.ObjectIdGenerator;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.types.BSONTimestamp;
import org.bson.types.BasicBSONList;
import org.bson.types.Binary;
import org.bson.types.CodeWScope;
import org.bson.types.Symbol;

public class DBObjectCodec
implements CollectibleCodec<DBObject> {
    private static final BsonTypeClassMap DEFAULT_BSON_TYPE_CLASS_MAP = DBObjectCodec.createDefaultBsonTypeClassMap();
    private static final String ID_FIELD_NAME = "_id";
    private final CodecRegistry codecRegistry;
    private final BsonTypeClassMap bsonTypeClassMap;
    private final DBObjectFactory objectFactory;
    private final IdGenerator idGenerator = new ObjectIdGenerator();

    static BsonTypeClassMap createDefaultBsonTypeClassMap() {
        HashMap<BsonType, Class<BSONTimestamp>> replacements = new HashMap<BsonType, Class<BSONTimestamp>>();
        replacements.put(BsonType.REGULAR_EXPRESSION, Pattern.class);
        replacements.put(BsonType.SYMBOL, String.class);
        replacements.put(BsonType.TIMESTAMP, BSONTimestamp.class);
        return new BsonTypeClassMap(replacements);
    }

    static BsonTypeClassMap getDefaultBsonTypeClassMap() {
        return DEFAULT_BSON_TYPE_CLASS_MAP;
    }

    public DBObjectCodec(CodecRegistry codecRegistry) {
        this(codecRegistry, DEFAULT_BSON_TYPE_CLASS_MAP);
    }

    public DBObjectCodec(CodecRegistry codecRegistry, BsonTypeClassMap bsonTypeClassMap) {
        this(codecRegistry, bsonTypeClassMap, new BasicDBObjectFactory());
    }

    public DBObjectCodec(CodecRegistry codecRegistry, BsonTypeClassMap bsonTypeClassMap, DBObjectFactory objectFactory) {
        this.objectFactory = (DBObjectFactory)Assertions.notNull((String)"objectFactory", (Object)objectFactory);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.bsonTypeClassMap = (BsonTypeClassMap)Assertions.notNull((String)"bsonTypeClassMap", (Object)bsonTypeClassMap);
    }

    public void encode(BsonWriter writer, DBObject document, EncoderContext encoderContext) {
        writer.writeStartDocument();
        this.beforeFields(writer, encoderContext, document);
        for (String key : document.keySet()) {
            if (this.skipField(encoderContext, key)) continue;
            writer.writeName(key);
            this.writeValue(writer, encoderContext, document.get(key));
        }
        writer.writeEndDocument();
    }

    public DBObject decode(BsonReader reader, DecoderContext decoderContext) {
        ArrayList<String> path = new ArrayList<String>(10);
        return this.readDocument(reader, decoderContext, path);
    }

    public Class<DBObject> getEncoderClass() {
        return DBObject.class;
    }

    public boolean documentHasId(DBObject document) {
        return document.containsField(ID_FIELD_NAME);
    }

    public BsonValue getDocumentId(DBObject document) {
        if (!this.documentHasId(document)) {
            throw new IllegalStateException("The document does not contain an _id");
        }
        Object id = document.get(ID_FIELD_NAME);
        if (id instanceof BsonValue) {
            return (BsonValue)id;
        }
        BsonDocument idHoldingDocument = new BsonDocument();
        BsonDocumentWriter writer = new BsonDocumentWriter(idHoldingDocument);
        writer.writeStartDocument();
        writer.writeName(ID_FIELD_NAME);
        this.writeValue((BsonWriter)writer, EncoderContext.builder().build(), id);
        writer.writeEndDocument();
        return idHoldingDocument.get((Object)ID_FIELD_NAME);
    }

    public void generateIdIfAbsentFromDocument(DBObject document) {
        if (!this.documentHasId(document)) {
            document.put(ID_FIELD_NAME, this.idGenerator.generate());
        }
    }

    private void beforeFields(BsonWriter bsonWriter, EncoderContext encoderContext, DBObject document) {
        if (encoderContext.isEncodingCollectibleDocument() && document.containsField(ID_FIELD_NAME)) {
            bsonWriter.writeName(ID_FIELD_NAME);
            this.writeValue(bsonWriter, null, document.get(ID_FIELD_NAME));
        }
    }

    private boolean skipField(EncoderContext encoderContext, String key) {
        return encoderContext.isEncodingCollectibleDocument() && key.equals(ID_FIELD_NAME);
    }

    private void writeValue(BsonWriter bsonWriter, EncoderContext encoderContext, Object initialValue) {
        Object value = BSON.applyEncodingHooks(initialValue);
        if (value == null) {
            bsonWriter.writeNull();
        } else if (value instanceof DBRef) {
            this.encodeDBRef(bsonWriter, (DBRef)value);
        } else if (value instanceof BasicBSONList) {
            this.encodeIterable(bsonWriter, (BasicBSONList)value);
        } else if (value instanceof DBObject) {
            this.encodeEmbeddedObject(bsonWriter, ((DBObject)value).toMap());
        } else if (value instanceof Map) {
            this.encodeEmbeddedObject(bsonWriter, (Map)value);
        } else if (value instanceof Iterable) {
            this.encodeIterable(bsonWriter, (Iterable)value);
        } else if (value instanceof CodeWScope) {
            this.encodeCodeWScope(bsonWriter, (CodeWScope)((Object)value));
        } else if (value instanceof byte[]) {
            this.encodeByteArray(bsonWriter, (byte[])value);
        } else if (value.getClass().isArray()) {
            this.encodeArray(bsonWriter, value);
        } else if (value instanceof Symbol) {
            bsonWriter.writeSymbol(((Symbol)value).getSymbol());
        } else {
            Codec codec = this.codecRegistry.get(value.getClass());
            codec.encode(bsonWriter, value, encoderContext);
        }
    }

    private void encodeEmbeddedObject(BsonWriter bsonWriter, Map<String, Object> document) {
        bsonWriter.writeStartDocument();
        for (Map.Entry<String, Object> entry : document.entrySet()) {
            bsonWriter.writeName(entry.getKey());
            this.writeValue(bsonWriter, null, entry.getValue());
        }
        bsonWriter.writeEndDocument();
    }

    private void encodeByteArray(BsonWriter bsonWriter, byte[] value) {
        bsonWriter.writeBinaryData(new BsonBinary(value));
    }

    private void encodeArray(BsonWriter bsonWriter, Object value) {
        bsonWriter.writeStartArray();
        int size = Array.getLength(value);
        for (int i = 0; i < size; ++i) {
            this.writeValue(bsonWriter, null, Array.get(value, i));
        }
        bsonWriter.writeEndArray();
    }

    private void encodeDBRef(BsonWriter bsonWriter, DBRef dbRef) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeString("$ref", dbRef.getCollectionName());
        bsonWriter.writeName("$id");
        this.writeValue(bsonWriter, null, dbRef.getId());
        bsonWriter.writeEndDocument();
    }

    private void encodeCodeWScope(BsonWriter bsonWriter, CodeWScope value) {
        bsonWriter.writeJavaScriptWithScope(value.getCode());
        this.encodeEmbeddedObject(bsonWriter, value.getScope().toMap());
    }

    private void encodeIterable(BsonWriter bsonWriter, Iterable iterable) {
        bsonWriter.writeStartArray();
        for (Object cur : iterable) {
            this.writeValue(bsonWriter, null, cur);
        }
        bsonWriter.writeEndArray();
    }

    private Object readValue(BsonReader reader, DecoderContext decoderContext, String fieldName, List<String> path) {
        Object initialRetVal;
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType.isContainer() && fieldName != null) {
            path.add(fieldName);
        }
        switch (bsonType) {
            case DOCUMENT: {
                initialRetVal = this.verifyForDBRef(this.readDocument(reader, decoderContext, path));
                break;
            }
            case ARRAY: {
                initialRetVal = this.readArray(reader, decoderContext, path);
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                initialRetVal = this.readCodeWScope(reader, decoderContext, path);
                break;
            }
            case DB_POINTER: {
                BsonDbPointer dbPointer = reader.readDBPointer();
                initialRetVal = new DBRef(dbPointer.getNamespace(), dbPointer.getId());
                break;
            }
            case BINARY: {
                initialRetVal = this.readBinary(reader, decoderContext);
                break;
            }
            case NULL: {
                reader.readNull();
                initialRetVal = null;
                break;
            }
            default: {
                initialRetVal = this.codecRegistry.get(this.bsonTypeClassMap.get(bsonType)).decode(reader, decoderContext);
            }
        }
        if (bsonType.isContainer() && fieldName != null) {
            path.remove(fieldName);
        }
        return BSON.applyDecodingHooks(initialRetVal);
    }

    private Object readBinary(BsonReader reader, DecoderContext decoderContext) {
        byte bsonSubType = reader.peekBinarySubType();
        if (bsonSubType == BsonBinarySubType.UUID_STANDARD.getValue() || bsonSubType == BsonBinarySubType.UUID_LEGACY.getValue()) {
            return this.codecRegistry.get(UUID.class).decode(reader, decoderContext);
        }
        if (bsonSubType == BsonBinarySubType.BINARY.getValue() || bsonSubType == BsonBinarySubType.OLD_BINARY.getValue()) {
            return this.codecRegistry.get(byte[].class).decode(reader, decoderContext);
        }
        return this.codecRegistry.get(Binary.class).decode(reader, decoderContext);
    }

    private List readArray(BsonReader reader, DecoderContext decoderContext, List<String> path) {
        reader.readStartArray();
        BasicDBList list = new BasicDBList();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            list.add(this.readValue(reader, decoderContext, null, path));
        }
        reader.readEndArray();
        return list;
    }

    private DBObject readDocument(BsonReader reader, DecoderContext decoderContext, List<String> path) {
        DBObject document = this.objectFactory.getInstance(path);
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            document.put(fieldName, this.readValue(reader, decoderContext, fieldName, path));
        }
        reader.readEndDocument();
        return document;
    }

    private CodeWScope readCodeWScope(BsonReader reader, DecoderContext decoderContext, List<String> path) {
        return new CodeWScope(reader.readJavaScriptWithScope(), this.readDocument(reader, decoderContext, path));
    }

    private Object verifyForDBRef(DBObject document) {
        if (document.containsField("$ref") && document.containsField("$id")) {
            return new DBRef((String)document.get("$ref"), document.get("$id"));
        }
        return document;
    }
}

