/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.binding.ClusterBinding;
import com.mongodb.binding.ReadBinding;
import com.mongodb.binding.ReadWriteBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.client.internal.ClientSessionBinding;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.connection.Cluster;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.session.ClientSessionImpl;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.lang.Nullable;
import com.mongodb.operation.ReadOperation;
import com.mongodb.operation.WriteOperation;
import com.mongodb.selector.ServerSelector;
import com.mongodb.session.ClientSession;
import java.util.ArrayList;
import java.util.List;

public class MongoClientDelegate {
    private final Cluster cluster;
    private final ServerSessionPool serverSessionPool;
    private final List<MongoCredential> credentialList;
    private final Object originator;
    private final OperationExecutor operationExecutor;

    public MongoClientDelegate(Cluster cluster, List<MongoCredential> credentialList, Object originator) {
        this(cluster, credentialList, originator, null);
    }

    public MongoClientDelegate(Cluster cluster, List<MongoCredential> credentialList, Object originator, @Nullable OperationExecutor operationExecutor) {
        this.cluster = cluster;
        this.serverSessionPool = new ServerSessionPool(cluster);
        this.credentialList = credentialList;
        this.originator = originator;
        this.operationExecutor = operationExecutor == null ? new DelegateOperationExecutor() : operationExecutor;
    }

    public OperationExecutor getOperationExecutor() {
        return this.operationExecutor;
    }

    @Nullable
    public ClientSession createClientSession(ClientSessionOptions options) {
        if (this.credentialList.size() > 1) {
            return null;
        }
        if (this.getConnectedClusterDescription().getLogicalSessionTimeoutMinutes() != null) {
            return new ClientSessionImpl(this.serverSessionPool, this.originator, options);
        }
        return null;
    }

    public List<ServerAddress> getServerAddressList() {
        ArrayList<ServerAddress> serverAddresses = new ArrayList<ServerAddress>();
        for (ServerDescription cur : this.cluster.getDescription().getServerDescriptions()) {
            serverAddresses.add(cur.getAddress());
        }
        return serverAddresses;
    }

    public void close() {
        this.serverSessionPool.close();
        this.cluster.close();
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    private ClusterDescription getConnectedClusterDescription() {
        ClusterDescription clusterDescription = this.cluster.getDescription();
        if (this.getServerDescriptionListToConsiderForSessionSupport(clusterDescription).isEmpty()) {
            this.cluster.selectServer(new ServerSelector(){

                public List<ServerDescription> select(ClusterDescription clusterDescription) {
                    return MongoClientDelegate.this.getServerDescriptionListToConsiderForSessionSupport(clusterDescription);
                }
            });
            clusterDescription = this.cluster.getDescription();
        }
        return clusterDescription;
    }

    private List<ServerDescription> getServerDescriptionListToConsiderForSessionSupport(ClusterDescription clusterDescription) {
        if (clusterDescription.getConnectionMode() == ClusterConnectionMode.SINGLE) {
            return clusterDescription.getAny();
        }
        return clusterDescription.getAnyPrimaryOrSecondary();
    }

    private class DelegateOperationExecutor
    implements OperationExecutor {
        private DelegateOperationExecutor() {
        }

        @Override
        public <T> T execute(ReadOperation<T> operation, ReadPreference readPreference) {
            return this.execute(operation, readPreference, null);
        }

        @Override
        public <T> T execute(WriteOperation<T> operation) {
            return this.execute(operation, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T execute(ReadOperation<T> operation, ReadPreference readPreference, @Nullable ClientSession session) {
            ClientSession actualClientSession = this.getClientSession(session);
            ReadBinding binding = this.getReadBinding(readPreference, actualClientSession, session == null && actualClientSession != null);
            try {
                Object object = operation.execute(binding);
                return (T)object;
            }
            finally {
                binding.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T execute(WriteOperation<T> operation, @Nullable ClientSession session) {
            ClientSession actualClientSession = this.getClientSession(session);
            WriteBinding binding = this.getWriteBinding(actualClientSession, session == null && actualClientSession != null);
            try {
                Object object = operation.execute(binding);
                return (T)object;
            }
            finally {
                binding.release();
            }
        }

        WriteBinding getWriteBinding(@Nullable ClientSession session, boolean ownsSession) {
            return this.getReadWriteBinding(ReadPreference.primary(), session, ownsSession);
        }

        ReadBinding getReadBinding(ReadPreference readPreference, @Nullable ClientSession session, boolean ownsSession) {
            return this.getReadWriteBinding(readPreference, session, ownsSession);
        }

        ReadWriteBinding getReadWriteBinding(ReadPreference readPreference, @Nullable ClientSession session, boolean ownsSession) {
            Object readWriteBinding = new ClusterBinding(MongoClientDelegate.this.cluster, readPreference);
            if (session != null) {
                readWriteBinding = new ClientSessionBinding(session, ownsSession, (ReadWriteBinding)readWriteBinding);
            }
            return readWriteBinding;
        }

        @Nullable
        ClientSession getClientSession(@Nullable ClientSession clientSessionFromOperation) {
            ClientSession session;
            if (clientSessionFromOperation != null) {
                Assertions.isTrue((String)"ClientSession from same MongoClient", (clientSessionFromOperation.getOriginator() == MongoClientDelegate.this.originator ? 1 : 0) != 0);
                session = clientSessionFromOperation;
            } else {
                session = MongoClientDelegate.this.createClientSession(ClientSessionOptions.builder().causallyConsistent(false).build());
            }
            return session;
        }
    }
}

