/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.crypt;

import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.reactivestreams.client.internal.crypt.Crypt;
import com.mongodb.reactivestreams.client.internal.crypt.CryptConnection;

public class CryptBinding
implements AsyncClusterAwareReadWriteBinding {
    private final AsyncClusterAwareReadWriteBinding wrapped;
    private final Crypt crypt;

    public CryptBinding(AsyncClusterAwareReadWriteBinding wrapped, Crypt crypt) {
        this.wrapped = wrapped;
        this.crypt = crypt;
    }

    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    public void getWriteConnectionSource(OperationContext operationContext, SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getWriteConnectionSource(operationContext, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult((Object)new CryptConnectionSource((AsyncConnectionSource)result), null);
            }
        });
    }

    public void getReadConnectionSource(OperationContext operationContext, SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getReadConnectionSource(operationContext, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult((Object)new CryptConnectionSource((AsyncConnectionSource)result), null);
            }
        });
    }

    public void getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference, OperationContext operationContext, SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getReadConnectionSource(minWireVersion, fallbackReadPreference, operationContext, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult((Object)new CryptConnectionSource((AsyncConnectionSource)result), null);
            }
        });
    }

    public void getConnectionSource(ServerAddress serverAddress, OperationContext operationContext, SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getConnectionSource(serverAddress, operationContext, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult((Object)new CryptConnectionSource((AsyncConnectionSource)result), null);
            }
        });
    }

    public int getCount() {
        return this.wrapped.getCount();
    }

    public AsyncClusterAwareReadWriteBinding retain() {
        this.wrapped.retain();
        return this;
    }

    public int release() {
        return this.wrapped.release();
    }

    private class CryptConnectionSource
    implements AsyncConnectionSource {
        private final AsyncConnectionSource wrapped;

        CryptConnectionSource(AsyncConnectionSource wrapped) {
            this.wrapped = wrapped;
            CryptBinding.this.retain();
        }

        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        public ReadPreference getReadPreference() {
            return this.wrapped.getReadPreference();
        }

        public void getConnection(OperationContext operationContext, SingleResultCallback<AsyncConnection> callback) {
            this.wrapped.getConnection(operationContext, (result, t) -> {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)new CryptConnection((AsyncConnection)result, CryptBinding.this.crypt), null);
                }
            });
        }

        public int getCount() {
            return this.wrapped.getCount();
        }

        public AsyncConnectionSource retain() {
            this.wrapped.retain();
            return this;
        }

        public int release() {
            return this.wrapped.release();
        }
    }
}

