/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.Block;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ChangeStreamIterable;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.async.client.Observables;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.internal.ObservableToPublisher;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class ChangeStreamPublisherImpl<TResult>
implements ChangeStreamPublisher<TResult> {
    private final ChangeStreamIterable<TResult> wrapped;

    ChangeStreamPublisherImpl(ChangeStreamIterable<TResult> wrapped) {
        this.wrapped = (ChangeStreamIterable)Assertions.notNull((String)"wrapped", wrapped);
    }

    @Override
    public ChangeStreamPublisher<TResult> fullDocument(FullDocument fullDocument) {
        this.wrapped.fullDocument(fullDocument);
        return this;
    }

    @Override
    public ChangeStreamPublisher<TResult> resumeAfter(BsonDocument resumeToken) {
        this.wrapped.resumeAfter(resumeToken);
        return this;
    }

    @Override
    public ChangeStreamPublisher<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        this.wrapped.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public ChangeStreamPublisher<TResult> collation(Collation collation) {
        this.wrapped.collation(collation);
        return this;
    }

    @Override
    public <TDocument> Publisher<TDocument> withDocumentClass(Class<TDocument> clazz) {
        return new ObservableToPublisher(Observables.observe((MongoIterable)this.wrapped.withDocumentClass(clazz)));
    }

    @Override
    public ChangeStreamPublisher<TResult> batchSize(int batchSize) {
        this.wrapped.batchSize(batchSize);
        return this;
    }

    @Override
    public Publisher<ChangeStreamDocument<TResult>> first() {
        return new ObservableToPublisher<ChangeStreamDocument<TResult>>(Observables.observe((Block)new Block<SingleResultCallback<ChangeStreamDocument<TResult>>>(){

            public void apply(SingleResultCallback<ChangeStreamDocument<TResult>> callback) {
                ChangeStreamPublisherImpl.this.wrapped.first(callback);
            }
        }));
    }

    public void subscribe(Subscriber<? super ChangeStreamDocument<TResult>> s) {
        new ObservableToPublisher<ChangeStreamDocument<TResult>>(Observables.observe(this.wrapped)).subscribe(s);
    }
}

