/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.assertions.Assertions;
import com.mongodb.async.client.ChangeStreamIterable;
import com.mongodb.async.client.Observables;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.FullDocument;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.internal.ObservableToPublisher;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;
import org.reactivestreams.Subscriber;

final class ChangeStreamPublisherImpl<TResult>
implements ChangeStreamPublisher<TResult> {
    private final ChangeStreamIterable<TResult> wrapped;

    ChangeStreamPublisherImpl(ChangeStreamIterable<TResult> wrapped) {
        this.wrapped = (ChangeStreamIterable)Assertions.notNull((String)"wrapped", wrapped);
    }

    @Override
    public ChangeStreamPublisher<TResult> fullDocument(FullDocument fullDocument) {
        this.wrapped.fullDocument(fullDocument);
        return this;
    }

    @Override
    public ChangeStreamPublisher<TResult> resumeAfter(Bson resumeToken) {
        this.wrapped.resumeAfter(resumeToken);
        return this;
    }

    @Override
    public ChangeStreamPublisher<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        this.wrapped.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public ChangeStreamPublisher<TResult> collation(Collation collation) {
        this.wrapped.collation(collation);
        return this;
    }

    public void subscribe(Subscriber<? super TResult> s) {
        new ObservableToPublisher<TResult>(Observables.observe(this.wrapped)).subscribe(s);
    }
}

