/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.Block;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.async.client.Observables;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.reactivestreams.client.ListCollectionsPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import com.mongodb.reactivestreams.client.Success;
import com.mongodb.reactivestreams.client.internal.ListCollectionsPublisherImpl;
import com.mongodb.reactivestreams.client.internal.MongoCollectionImpl;
import com.mongodb.reactivestreams.client.internal.ObservableToPublisher;
import com.mongodb.reactivestreams.client.internal.PublisherHelper;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

public final class MongoDatabaseImpl
implements MongoDatabase {
    private final com.mongodb.async.client.MongoDatabase wrapped;

    MongoDatabaseImpl(com.mongodb.async.client.MongoDatabase wrapped) {
        this.wrapped = (com.mongodb.async.client.MongoDatabase)Assertions.notNull((String)"wrapped", (Object)wrapped);
    }

    @Override
    public String getName() {
        return this.wrapped.getName();
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.wrapped.getCodecRegistry();
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.wrapped.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.wrapped.getReadConcern();
    }

    @Override
    public MongoDatabase withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoDatabaseImpl(this.wrapped.withCodecRegistry(codecRegistry));
    }

    @Override
    public MongoDatabase withReadPreference(ReadPreference readPreference) {
        return new MongoDatabaseImpl(this.wrapped.withReadPreference(readPreference));
    }

    @Override
    public MongoDatabase withWriteConcern(WriteConcern writeConcern) {
        return new MongoDatabaseImpl(this.wrapped.withWriteConcern(writeConcern));
    }

    @Override
    public MongoDatabase withReadConcern(ReadConcern readConcern) {
        return new MongoDatabaseImpl(this.wrapped.withReadConcern(readConcern));
    }

    @Override
    public MongoCollection<Document> getCollection(String collectionName) {
        return this.getCollection(collectionName, Document.class);
    }

    @Override
    public <TDocument> MongoCollection<TDocument> getCollection(String collectionName, Class<TDocument> clazz) {
        return new MongoCollectionImpl(this.wrapped.getCollection(collectionName, clazz));
    }

    @Override
    public Publisher<Document> runCommand(Bson command) {
        return this.runCommand(command, Document.class);
    }

    @Override
    public Publisher<Document> runCommand(Bson command, ReadPreference readPreference) {
        return this.runCommand(command, readPreference, Document.class);
    }

    @Override
    public <TResult> Publisher<TResult> runCommand(final Bson command, final Class<TResult> clazz) {
        return new ObservableToPublisher(Observables.observe((Block)new Block<SingleResultCallback<TResult>>(){

            public void apply(SingleResultCallback<TResult> callback) {
                MongoDatabaseImpl.this.wrapped.runCommand(command, clazz, callback);
            }
        }));
    }

    @Override
    public <TResult> Publisher<TResult> runCommand(final Bson command, final ReadPreference readPreference, final Class<TResult> clazz) {
        return new ObservableToPublisher(Observables.observe((Block)new Block<SingleResultCallback<TResult>>(){

            public void apply(SingleResultCallback<TResult> callback) {
                MongoDatabaseImpl.this.wrapped.runCommand(command, readPreference, clazz, callback);
            }
        }));
    }

    @Override
    public Publisher<Success> drop() {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoDatabaseImpl.this.wrapped.drop(PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public Publisher<String> listCollectionNames() {
        return new ObservableToPublisher<String>(Observables.observe((MongoIterable)this.wrapped.listCollectionNames()));
    }

    @Override
    public ListCollectionsPublisher<Document> listCollections() {
        return this.listCollections((Class)Document.class);
    }

    public <C> ListCollectionsPublisher<C> listCollections(Class<C> clazz) {
        return new ListCollectionsPublisherImpl(this.wrapped.listCollections(clazz));
    }

    @Override
    public Publisher<Success> createCollection(String collectionName) {
        return this.createCollection(collectionName, new CreateCollectionOptions());
    }

    @Override
    public Publisher<Success> createCollection(final String collectionName, final CreateCollectionOptions options) {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoDatabaseImpl.this.wrapped.createCollection(collectionName, options, PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public Publisher<Success> createView(final String viewName, final String viewOn, final List<? extends Bson> pipeline) {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoDatabaseImpl.this.wrapped.createView(viewName, viewOn, pipeline, PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public Publisher<Success> createView(final String viewName, final String viewOn, final List<? extends Bson> pipeline, final CreateViewOptions createViewOptions) {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoDatabaseImpl.this.wrapped.createView(viewName, viewOn, pipeline, createViewOptions, PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    public com.mongodb.async.client.MongoDatabase getWrapped() {
        return this.wrapped;
    }
}

