/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.DistinctPublisher;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.ListIndexesPublisher;
import com.mongodb.reactivestreams.client.MapReducePublisher;
import com.mongodb.reactivestreams.client.Success;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

@ThreadSafe
public interface MongoCollection<TDocument> {
    public MongoNamespace getNamespace();

    public Class<TDocument> getDocumentClass();

    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public ReadConcern getReadConcern();

    public <NewTDocument> MongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> var1);

    public MongoCollection<TDocument> withCodecRegistry(CodecRegistry var1);

    public MongoCollection<TDocument> withReadPreference(ReadPreference var1);

    public MongoCollection<TDocument> withWriteConcern(WriteConcern var1);

    public MongoCollection<TDocument> withReadConcern(ReadConcern var1);

    @Deprecated
    public Publisher<Long> count();

    @Deprecated
    public Publisher<Long> count(Bson var1);

    @Deprecated
    public Publisher<Long> count(Bson var1, CountOptions var2);

    @Deprecated
    public Publisher<Long> count(ClientSession var1);

    @Deprecated
    public Publisher<Long> count(ClientSession var1, Bson var2);

    @Deprecated
    public Publisher<Long> count(ClientSession var1, Bson var2, CountOptions var3);

    public Publisher<Long> estimatedDocumentCount();

    public Publisher<Long> estimatedDocumentCount(EstimatedDocumentCountOptions var1);

    public Publisher<Long> countDocuments();

    public Publisher<Long> countDocuments(Bson var1);

    public Publisher<Long> countDocuments(Bson var1, CountOptions var2);

    public Publisher<Long> countDocuments(ClientSession var1);

    public Publisher<Long> countDocuments(ClientSession var1, Bson var2);

    public Publisher<Long> countDocuments(ClientSession var1, Bson var2, CountOptions var3);

    public <TResult> DistinctPublisher<TResult> distinct(String var1, Class<TResult> var2);

    public <TResult> DistinctPublisher<TResult> distinct(String var1, Bson var2, Class<TResult> var3);

    public <TResult> DistinctPublisher<TResult> distinct(ClientSession var1, String var2, Class<TResult> var3);

    public <TResult> DistinctPublisher<TResult> distinct(ClientSession var1, String var2, Bson var3, Class<TResult> var4);

    public FindPublisher<TDocument> find();

    public <TResult> FindPublisher<TResult> find(Class<TResult> var1);

    public FindPublisher<TDocument> find(Bson var1);

    public <TResult> FindPublisher<TResult> find(Bson var1, Class<TResult> var2);

    public FindPublisher<TDocument> find(ClientSession var1);

    public <TResult> FindPublisher<TResult> find(ClientSession var1, Class<TResult> var2);

    public FindPublisher<TDocument> find(ClientSession var1, Bson var2);

    public <TResult> FindPublisher<TResult> find(ClientSession var1, Bson var2, Class<TResult> var3);

    public AggregatePublisher<Document> aggregate(List<? extends Bson> var1);

    public <TResult> AggregatePublisher<TResult> aggregate(List<? extends Bson> var1, Class<TResult> var2);

    public AggregatePublisher<Document> aggregate(ClientSession var1, List<? extends Bson> var2);

    public <TResult> AggregatePublisher<TResult> aggregate(ClientSession var1, List<? extends Bson> var2, Class<TResult> var3);

    public ChangeStreamPublisher<Document> watch();

    public <TResult> ChangeStreamPublisher<TResult> watch(Class<TResult> var1);

    public ChangeStreamPublisher<Document> watch(List<? extends Bson> var1);

    public <TResult> ChangeStreamPublisher<TResult> watch(List<? extends Bson> var1, Class<TResult> var2);

    public ChangeStreamPublisher<Document> watch(ClientSession var1);

    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession var1, Class<TResult> var2);

    public ChangeStreamPublisher<Document> watch(ClientSession var1, List<? extends Bson> var2);

    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession var1, List<? extends Bson> var2, Class<TResult> var3);

    public MapReducePublisher<Document> mapReduce(String var1, String var2);

    public <TResult> MapReducePublisher<TResult> mapReduce(String var1, String var2, Class<TResult> var3);

    public MapReducePublisher<Document> mapReduce(ClientSession var1, String var2, String var3);

    public <TResult> MapReducePublisher<TResult> mapReduce(ClientSession var1, String var2, String var3, Class<TResult> var4);

    public Publisher<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends TDocument>> var1);

    public Publisher<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends TDocument>> var1, BulkWriteOptions var2);

    public Publisher<BulkWriteResult> bulkWrite(ClientSession var1, List<? extends WriteModel<? extends TDocument>> var2);

    public Publisher<BulkWriteResult> bulkWrite(ClientSession var1, List<? extends WriteModel<? extends TDocument>> var2, BulkWriteOptions var3);

    public Publisher<Success> insertOne(TDocument var1);

    public Publisher<Success> insertOne(TDocument var1, InsertOneOptions var2);

    public Publisher<Success> insertOne(ClientSession var1, TDocument var2);

    public Publisher<Success> insertOne(ClientSession var1, TDocument var2, InsertOneOptions var3);

    public Publisher<Success> insertMany(List<? extends TDocument> var1);

    public Publisher<Success> insertMany(List<? extends TDocument> var1, InsertManyOptions var2);

    public Publisher<Success> insertMany(ClientSession var1, List<? extends TDocument> var2);

    public Publisher<Success> insertMany(ClientSession var1, List<? extends TDocument> var2, InsertManyOptions var3);

    public Publisher<DeleteResult> deleteOne(Bson var1);

    public Publisher<DeleteResult> deleteOne(Bson var1, DeleteOptions var2);

    public Publisher<DeleteResult> deleteOne(ClientSession var1, Bson var2);

    public Publisher<DeleteResult> deleteOne(ClientSession var1, Bson var2, DeleteOptions var3);

    public Publisher<DeleteResult> deleteMany(Bson var1);

    public Publisher<DeleteResult> deleteMany(Bson var1, DeleteOptions var2);

    public Publisher<DeleteResult> deleteMany(ClientSession var1, Bson var2);

    public Publisher<DeleteResult> deleteMany(ClientSession var1, Bson var2, DeleteOptions var3);

    public Publisher<UpdateResult> replaceOne(Bson var1, TDocument var2);

    public Publisher<UpdateResult> replaceOne(Bson var1, TDocument var2, ReplaceOptions var3);

    @Deprecated
    public Publisher<UpdateResult> replaceOne(Bson var1, TDocument var2, UpdateOptions var3);

    public Publisher<UpdateResult> replaceOne(ClientSession var1, Bson var2, TDocument var3);

    public Publisher<UpdateResult> replaceOne(ClientSession var1, Bson var2, TDocument var3, ReplaceOptions var4);

    @Deprecated
    public Publisher<UpdateResult> replaceOne(ClientSession var1, Bson var2, TDocument var3, UpdateOptions var4);

    public Publisher<UpdateResult> updateOne(Bson var1, Bson var2);

    public Publisher<UpdateResult> updateOne(Bson var1, Bson var2, UpdateOptions var3);

    public Publisher<UpdateResult> updateOne(ClientSession var1, Bson var2, Bson var3);

    public Publisher<UpdateResult> updateOne(ClientSession var1, Bson var2, Bson var3, UpdateOptions var4);

    public Publisher<UpdateResult> updateMany(Bson var1, Bson var2);

    public Publisher<UpdateResult> updateMany(Bson var1, Bson var2, UpdateOptions var3);

    public Publisher<UpdateResult> updateMany(ClientSession var1, Bson var2, Bson var3);

    public Publisher<UpdateResult> updateMany(ClientSession var1, Bson var2, Bson var3, UpdateOptions var4);

    public Publisher<TDocument> findOneAndDelete(Bson var1);

    public Publisher<TDocument> findOneAndDelete(Bson var1, FindOneAndDeleteOptions var2);

    public Publisher<TDocument> findOneAndDelete(ClientSession var1, Bson var2);

    public Publisher<TDocument> findOneAndDelete(ClientSession var1, Bson var2, FindOneAndDeleteOptions var3);

    public Publisher<TDocument> findOneAndReplace(Bson var1, TDocument var2);

    public Publisher<TDocument> findOneAndReplace(Bson var1, TDocument var2, FindOneAndReplaceOptions var3);

    public Publisher<TDocument> findOneAndReplace(ClientSession var1, Bson var2, TDocument var3);

    public Publisher<TDocument> findOneAndReplace(ClientSession var1, Bson var2, TDocument var3, FindOneAndReplaceOptions var4);

    public Publisher<TDocument> findOneAndUpdate(Bson var1, Bson var2);

    public Publisher<TDocument> findOneAndUpdate(Bson var1, Bson var2, FindOneAndUpdateOptions var3);

    public Publisher<TDocument> findOneAndUpdate(ClientSession var1, Bson var2, Bson var3);

    public Publisher<TDocument> findOneAndUpdate(ClientSession var1, Bson var2, Bson var3, FindOneAndUpdateOptions var4);

    public Publisher<Success> drop();

    public Publisher<Success> drop(ClientSession var1);

    public Publisher<String> createIndex(Bson var1);

    public Publisher<String> createIndex(Bson var1, IndexOptions var2);

    public Publisher<String> createIndex(ClientSession var1, Bson var2);

    public Publisher<String> createIndex(ClientSession var1, Bson var2, IndexOptions var3);

    public Publisher<String> createIndexes(List<IndexModel> var1);

    public Publisher<String> createIndexes(List<IndexModel> var1, CreateIndexOptions var2);

    public Publisher<String> createIndexes(ClientSession var1, List<IndexModel> var2);

    public Publisher<String> createIndexes(ClientSession var1, List<IndexModel> var2, CreateIndexOptions var3);

    public ListIndexesPublisher<Document> listIndexes();

    public <TResult> ListIndexesPublisher<TResult> listIndexes(Class<TResult> var1);

    public ListIndexesPublisher<Document> listIndexes(ClientSession var1);

    public <TResult> ListIndexesPublisher<TResult> listIndexes(ClientSession var1, Class<TResult> var2);

    public Publisher<Success> dropIndex(String var1);

    public Publisher<Success> dropIndex(Bson var1);

    public Publisher<Success> dropIndex(String var1, DropIndexOptions var2);

    public Publisher<Success> dropIndex(Bson var1, DropIndexOptions var2);

    public Publisher<Success> dropIndex(ClientSession var1, String var2);

    public Publisher<Success> dropIndex(ClientSession var1, Bson var2);

    public Publisher<Success> dropIndex(ClientSession var1, String var2, DropIndexOptions var3);

    public Publisher<Success> dropIndex(ClientSession var1, Bson var2, DropIndexOptions var3);

    public Publisher<Success> dropIndexes();

    public Publisher<Success> dropIndexes(DropIndexOptions var1);

    public Publisher<Success> dropIndexes(ClientSession var1);

    public Publisher<Success> dropIndexes(ClientSession var1, DropIndexOptions var2);

    public Publisher<Success> renameCollection(MongoNamespace var1);

    public Publisher<Success> renameCollection(MongoNamespace var1, RenameCollectionOptions var2);

    public Publisher<Success> renameCollection(ClientSession var1, MongoNamespace var2);

    public Publisher<Success> renameCollection(ClientSession var1, MongoNamespace var2, RenameCollectionOptions var3);
}

