/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client;

import com.mongodb.Block;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AggregateIterable;
import com.mongodb.async.client.Observables;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.ObservableToPublisher;
import com.mongodb.reactivestreams.client.PublisherHelper;
import com.mongodb.reactivestreams.client.Success;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

class AggregatePublisherImpl<TResult>
implements AggregatePublisher<TResult> {
    private final AggregateIterable<TResult> wrapped;

    AggregatePublisherImpl(AggregateIterable<TResult> wrapped) {
        this.wrapped = (AggregateIterable)Assertions.notNull((String)"wrapped", wrapped);
    }

    @Override
    public AggregatePublisher<TResult> allowDiskUse(Boolean allowDiskUse) {
        this.wrapped.allowDiskUse(allowDiskUse);
        return this;
    }

    @Override
    public AggregatePublisher<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        this.wrapped.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public AggregatePublisher<TResult> useCursor(Boolean useCursor) {
        this.wrapped.useCursor(useCursor);
        return this;
    }

    @Override
    public Publisher<Success> toCollection() {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                AggregatePublisherImpl.this.wrapped.toCollection(PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    public void subscribe(Subscriber<? super TResult> s) {
        new ObservableToPublisher<TResult>(Observables.observe(this.wrapped)).subscribe(s);
    }
}

