/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.AggregatePublisherImpl;
import com.mongodb.reactivestreams.client.DistinctPublisher;
import com.mongodb.reactivestreams.client.DistinctPublisherImpl;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.FindPublisherImpl;
import com.mongodb.reactivestreams.client.ListIndexesPublisher;
import com.mongodb.reactivestreams.client.ListIndexesPublisherImpl;
import com.mongodb.reactivestreams.client.MapReducePublisher;
import com.mongodb.reactivestreams.client.MapReducePublisherImpl;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.PublisherHelper;
import com.mongodb.reactivestreams.client.SingleResultListPublisher;
import com.mongodb.reactivestreams.client.SingleResultPublisher;
import com.mongodb.reactivestreams.client.Success;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

class MongoCollectionImpl<TDocument>
implements MongoCollection<TDocument> {
    private final com.mongodb.async.client.MongoCollection<TDocument> wrapped;

    MongoCollectionImpl(com.mongodb.async.client.MongoCollection<TDocument> wrapped) {
        this.wrapped = (com.mongodb.async.client.MongoCollection)Assertions.notNull((String)"wrapped", wrapped);
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.wrapped.getNamespace();
    }

    @Override
    public Class<TDocument> getDocumentClass() {
        return this.wrapped.getDocumentClass();
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.wrapped.getCodecRegistry();
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.wrapped.getWriteConcern();
    }

    @Override
    public <NewTDocument> MongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> clazz) {
        return new MongoCollectionImpl<TDocument>(this.wrapped.withDocumentClass(clazz));
    }

    @Override
    public MongoCollection<TDocument> withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoCollectionImpl<TDocument>(this.wrapped.withCodecRegistry(codecRegistry));
    }

    @Override
    public MongoCollection<TDocument> withReadPreference(ReadPreference readPreference) {
        return new MongoCollectionImpl<TDocument>(this.wrapped.withReadPreference(readPreference));
    }

    @Override
    public MongoCollection<TDocument> withWriteConcern(WriteConcern writeConcern) {
        return new MongoCollectionImpl<TDocument>(this.wrapped.withWriteConcern(writeConcern));
    }

    @Override
    public Publisher<Long> count() {
        return this.count((Bson)new BsonDocument(), new CountOptions());
    }

    @Override
    public Publisher<Long> count(Bson filter) {
        return this.count(filter, new CountOptions());
    }

    @Override
    public Publisher<Long> count(final Bson filter, final CountOptions options) {
        return new SingleResultPublisher<Long>(){

            @Override
            void execute(SingleResultCallback<Long> callback) {
                MongoCollectionImpl.this.wrapped.count(filter, options, callback);
            }
        };
    }

    @Override
    public <TResult> DistinctPublisher<TResult> distinct(String fieldName, Class<TResult> resultClass) {
        return this.distinct(fieldName, (Bson)new BsonDocument(), resultClass);
    }

    @Override
    public <TResult> DistinctPublisher<TResult> distinct(String fieldName, Bson filter, Class<TResult> resultClass) {
        return new DistinctPublisherImpl(this.wrapped.distinct(fieldName, resultClass)).filter(filter);
    }

    @Override
    public FindPublisher<TDocument> find() {
        return this.find((Bson)new BsonDocument(), this.getDocumentClass());
    }

    @Override
    public <TResult> FindPublisher<TResult> find(Class<TResult> clazz) {
        return this.find((Bson)new BsonDocument(), clazz);
    }

    @Override
    public FindPublisher<TDocument> find(Bson filter) {
        return this.find(filter, this.getDocumentClass());
    }

    @Override
    public <TResult> FindPublisher<TResult> find(Bson filter, Class<TResult> clazz) {
        return new FindPublisherImpl(this.wrapped.find(filter, clazz));
    }

    @Override
    public AggregatePublisher<Document> aggregate(List<? extends Bson> pipeline) {
        return this.aggregate(pipeline, Document.class);
    }

    @Override
    public <TResult> AggregatePublisher<TResult> aggregate(List<? extends Bson> pipeline, Class<TResult> clazz) {
        return new AggregatePublisherImpl(this.wrapped.aggregate(pipeline, clazz));
    }

    @Override
    public MapReducePublisher<Document> mapReduce(String mapFunction, String reduceFunction) {
        return this.mapReduce(mapFunction, reduceFunction, Document.class);
    }

    @Override
    public <TResult> MapReducePublisher<TResult> mapReduce(String mapFunction, String reduceFunction, Class<TResult> clazz) {
        return new MapReducePublisherImpl(this.wrapped.mapReduce(mapFunction, reduceFunction, clazz));
    }

    @Override
    public Publisher<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends TDocument>> requests) {
        return this.bulkWrite(requests, new BulkWriteOptions());
    }

    @Override
    public Publisher<BulkWriteResult> bulkWrite(final List<? extends WriteModel<? extends TDocument>> requests, final BulkWriteOptions options) {
        return new SingleResultPublisher<BulkWriteResult>(){

            @Override
            void execute(SingleResultCallback<BulkWriteResult> callback) {
                MongoCollectionImpl.this.wrapped.bulkWrite(requests, options, callback);
            }
        };
    }

    @Override
    public Publisher<Success> insertOne(final TDocument document) {
        return new SingleResultPublisher<Success>(){

            @Override
            void execute(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.insertOne(document, PublisherHelper.voidToSuccessCallback(callback));
            }
        };
    }

    @Override
    public Publisher<Success> insertMany(List<? extends TDocument> documents) {
        return this.insertMany(documents, new InsertManyOptions());
    }

    @Override
    public Publisher<Success> insertMany(final List<? extends TDocument> documents, final InsertManyOptions options) {
        return new SingleResultPublisher<Success>(){

            @Override
            void execute(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.insertMany(documents, options, PublisherHelper.voidToSuccessCallback(callback));
            }
        };
    }

    @Override
    public Publisher<DeleteResult> deleteOne(final Bson filter) {
        return new SingleResultPublisher<DeleteResult>(){

            @Override
            void execute(SingleResultCallback<DeleteResult> callback) {
                MongoCollectionImpl.this.wrapped.deleteOne(filter, callback);
            }
        };
    }

    @Override
    public Publisher<DeleteResult> deleteMany(final Bson filter) {
        return new SingleResultPublisher<DeleteResult>(){

            @Override
            void execute(SingleResultCallback<DeleteResult> callback) {
                MongoCollectionImpl.this.wrapped.deleteMany(filter, callback);
            }
        };
    }

    @Override
    public Publisher<UpdateResult> replaceOne(Bson filter, TDocument replacement) {
        return this.replaceOne(filter, replacement, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> replaceOne(final Bson filter, final TDocument replacement, final UpdateOptions options) {
        return new SingleResultPublisher<UpdateResult>(){

            @Override
            void execute(SingleResultCallback<UpdateResult> callback) {
                MongoCollectionImpl.this.wrapped.replaceOne(filter, replacement, options, callback);
            }
        };
    }

    @Override
    public Publisher<UpdateResult> updateOne(Bson filter, Bson update) {
        return this.updateOne(filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateOne(final Bson filter, final Bson update, final UpdateOptions options) {
        return new SingleResultPublisher<UpdateResult>(){

            @Override
            void execute(SingleResultCallback<UpdateResult> callback) {
                MongoCollectionImpl.this.wrapped.updateOne(filter, update, options, callback);
            }
        };
    }

    @Override
    public Publisher<UpdateResult> updateMany(Bson filter, Bson update) {
        return this.updateMany(filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateMany(final Bson filter, final Bson update, final UpdateOptions options) {
        return new SingleResultPublisher<UpdateResult>(){

            @Override
            void execute(SingleResultCallback<UpdateResult> callback) {
                MongoCollectionImpl.this.wrapped.updateMany(filter, update, options, callback);
            }
        };
    }

    @Override
    public Publisher<TDocument> findOneAndDelete(Bson filter) {
        return this.findOneAndDelete(filter, new FindOneAndDeleteOptions());
    }

    @Override
    public Publisher<TDocument> findOneAndDelete(final Bson filter, final FindOneAndDeleteOptions options) {
        return new SingleResultPublisher<TDocument>(){

            @Override
            void execute(SingleResultCallback<TDocument> callback) {
                MongoCollectionImpl.this.wrapped.findOneAndDelete(filter, options, callback);
            }
        };
    }

    @Override
    public Publisher<TDocument> findOneAndReplace(Bson filter, TDocument replacement) {
        return this.findOneAndReplace(filter, replacement, new FindOneAndReplaceOptions());
    }

    @Override
    public Publisher<TDocument> findOneAndReplace(final Bson filter, final TDocument replacement, final FindOneAndReplaceOptions options) {
        return new SingleResultPublisher<TDocument>(){

            @Override
            void execute(SingleResultCallback<TDocument> callback) {
                MongoCollectionImpl.this.wrapped.findOneAndReplace(filter, replacement, options, callback);
            }
        };
    }

    @Override
    public Publisher<TDocument> findOneAndUpdate(Bson filter, Bson update) {
        return this.findOneAndUpdate(filter, update, new FindOneAndUpdateOptions());
    }

    @Override
    public Publisher<TDocument> findOneAndUpdate(final Bson filter, final Bson update, final FindOneAndUpdateOptions options) {
        return new SingleResultPublisher<TDocument>(){

            @Override
            void execute(SingleResultCallback<TDocument> callback) {
                MongoCollectionImpl.this.wrapped.findOneAndUpdate(filter, update, options, callback);
            }
        };
    }

    @Override
    public Publisher<Success> drop() {
        return new SingleResultPublisher<Success>(){

            @Override
            void execute(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.drop(PublisherHelper.voidToSuccessCallback(callback));
            }
        };
    }

    @Override
    public Publisher<String> createIndex(Bson key) {
        return this.createIndex(key, new IndexOptions());
    }

    @Override
    public Publisher<String> createIndex(final Bson key, final IndexOptions options) {
        return new SingleResultPublisher<String>(){

            @Override
            void execute(SingleResultCallback<String> callback) {
                MongoCollectionImpl.this.wrapped.createIndex(key, options, callback);
            }
        };
    }

    @Override
    public Publisher<String> createIndexes(final List<IndexModel> indexes) {
        return new SingleResultListPublisher<String>(){

            @Override
            void execute(SingleResultCallback<List<String>> callback) {
                MongoCollectionImpl.this.wrapped.createIndexes(indexes, callback);
            }
        };
    }

    @Override
    public ListIndexesPublisher<Document> listIndexes() {
        return this.listIndexes(Document.class);
    }

    @Override
    public <TResult> ListIndexesPublisher<TResult> listIndexes(Class<TResult> clazz) {
        return new ListIndexesPublisherImpl(this.wrapped.listIndexes(clazz));
    }

    @Override
    public Publisher<Success> dropIndex(final String indexName) {
        return new SingleResultPublisher<Success>(){

            @Override
            void execute(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.dropIndex(indexName, PublisherHelper.voidToSuccessCallback(callback));
            }
        };
    }

    @Override
    public Publisher<Success> dropIndex(final Bson keys) {
        return new SingleResultPublisher<Success>(){

            @Override
            void execute(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.dropIndex(keys, PublisherHelper.voidToSuccessCallback(callback));
            }
        };
    }

    @Override
    public Publisher<Success> dropIndexes() {
        return this.dropIndex("*");
    }

    @Override
    public Publisher<Success> renameCollection(MongoNamespace newCollectionNamespace) {
        return this.renameCollection(newCollectionNamespace, new RenameCollectionOptions());
    }

    @Override
    public Publisher<Success> renameCollection(final MongoNamespace newCollectionNamespace, final RenameCollectionOptions options) {
        return new SingleResultPublisher<Success>(){

            @Override
            void execute(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.renameCollection(newCollectionNamespace, options, PublisherHelper.voidToSuccessCallback(callback));
            }
        };
    }
}

