/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client;

import com.mongodb.async.SingleResultCallback;
import com.mongodb.reactivestreams.client.SubscriptionSupport;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

abstract class SingleResultPublisher<TResult>
implements Publisher<TResult> {
    public void subscribe(Subscriber<? super TResult> s) {
        new SingleResultSubscription(s).start();
    }

    SingleResultCallback<TResult> getCallback(final SubscriptionSupport<TResult> subscription) {
        return new SingleResultCallback<TResult>(){

            public void onResult(TResult result, Throwable t) {
                subscription.log("result - " + result + " : " + t);
                if (t != null) {
                    subscription.onError(t);
                } else {
                    if (result != null) {
                        subscription.onNext(result);
                    }
                    subscription.onComplete();
                }
            }
        };
    }

    abstract void execute(SingleResultCallback<TResult> var1);

    SingleResultPublisher() {
    }

    private class SingleResultSubscription
    extends SubscriptionSupport<TResult> {
        private final AtomicBoolean operationCompleted;

        public SingleResultSubscription(Subscriber<? super TResult> subscriber) {
            super(subscriber);
            this.operationCompleted = new AtomicBoolean();
        }

        @Override
        protected void doRequest(long n) {
            this.log("doRequest : " + n);
            if (this.operationCompleted.compareAndSet(false, true)) {
                SingleResultPublisher.this.execute(SingleResultPublisher.this.getCallback(this));
            }
        }
    }
}

