/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client;

import com.mongodb.async.SingleResultCallback;
import com.mongodb.reactivestreams.client.SubscriptionSupport;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

abstract class SingleResultListPublisher<TResult>
implements Publisher<TResult> {
    public void subscribe(Subscriber<? super TResult> s) {
        new SingleResultSubscription(s).start();
    }

    SingleResultCallback<List<TResult>> getCallback(final SubscriptionSupport<TResult> subscription) {
        return new SingleResultCallback<List<TResult>>(){

            public void onResult(List<TResult> results, Throwable t) {
                subscription.log("result - " + results + " : " + t);
                if (t != null) {
                    subscription.onError(t);
                } else {
                    if (results != null) {
                        for (Object result : results) {
                            subscription.onNext(result);
                        }
                    }
                    subscription.onComplete();
                }
            }
        };
    }

    abstract void execute(SingleResultCallback<List<TResult>> var1);

    SingleResultListPublisher() {
    }

    private class SingleResultSubscription
    extends SubscriptionSupport<TResult> {
        private final AtomicBoolean operationCompleted;

        public SingleResultSubscription(Subscriber<? super TResult> subscriber) {
            super(subscriber);
            this.operationCompleted = new AtomicBoolean();
        }

        @Override
        protected void doRequest(long n) {
            this.log("doRequest : " + n);
            if (this.operationCompleted.compareAndSet(false, true)) {
                SingleResultListPublisher.this.execute(SingleResultListPublisher.this.getCallback(this));
            }
        }
    }
}

