/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Cursor;
import com.mongodb.CursorType;
import com.mongodb.DBCollection;
import com.mongodb.DBCursorCleaner;
import com.mongodb.DBDecoderAdapter;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.internal.MongoBatchCursorAdapter;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.DBCollectionCountOptions;
import com.mongodb.client.model.DBCollectionFindOptions;
import com.mongodb.internal.connection.BufferProvider;
import com.mongodb.internal.connection.PowerOfTwoBufferPool;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.FindOperation;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.Decoder;

@NotThreadSafe
public class DBCursor
implements Cursor,
Iterable<DBObject> {
    private final DBCollection collection;
    private final DBObject filter;
    private final DBCollectionFindOptions findOptions;
    private final OperationExecutor executor;
    private final boolean retryReads;
    private DBDecoderFactory decoderFactory;
    private Decoder<DBObject> decoder;
    private IteratorOrArray iteratorOrArray;
    private DBObject currentObject;
    private int numSeen;
    private boolean closed;
    private final List<DBObject> all = new ArrayList<DBObject>();
    private MongoCursor<DBObject> cursor;
    private DBCursorCleaner optionalCleaner;

    public DBCursor(DBCollection collection, DBObject query, @Nullable DBObject fields, @Nullable ReadPreference readPreference) {
        this(collection, query, fields, readPreference, true);
    }

    public DBCursor(DBCollection collection, DBObject query, @Nullable DBObject fields, @Nullable ReadPreference readPreference, boolean retryReads) {
        this(collection, query, new DBCollectionFindOptions().projection(fields).readPreference(readPreference), retryReads);
    }

    DBCursor(DBCollection collection, @Nullable DBObject filter, DBCollectionFindOptions findOptions) {
        this(collection, filter, findOptions, true);
    }

    DBCursor(DBCollection collection, @Nullable DBObject filter, DBCollectionFindOptions findOptions, boolean retryReads) {
        this(collection, filter, findOptions, collection.getExecutor(), collection.getDBDecoderFactory(), (Decoder<DBObject>)collection.getObjectCodec(), retryReads);
    }

    private DBCursor(DBCollection collection, @Nullable DBObject filter, DBCollectionFindOptions findOptions, OperationExecutor executor, DBDecoderFactory decoderFactory, Decoder<DBObject> decoder, boolean retryReads) {
        this.collection = (DBCollection)Assertions.notNull((String)"collection", (Object)collection);
        this.filter = filter;
        this.executor = (OperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
        this.findOptions = (DBCollectionFindOptions)Assertions.notNull((String)"findOptions", (Object)findOptions.copy());
        this.decoderFactory = decoderFactory;
        this.decoder = (Decoder)Assertions.notNull((String)"decoder", decoder);
        this.retryReads = retryReads;
    }

    public DBCursor copy() {
        return new DBCursor(this.collection, this.filter, this.findOptions, this.executor, this.decoderFactory, this.decoder, this.retryReads);
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            throw new IllegalStateException("Cursor has been closed");
        }
        if (this.cursor == null) {
            FindOperation<DBObject> operation = this.getQueryOperation(this.decoder);
            if (operation.getCursorType() == CursorType.Tailable) {
                operation.cursorType(CursorType.TailableAwait);
            }
            this.initializeCursor(operation);
        }
        boolean hasNext = this.cursor.hasNext();
        if (this.cursor.getServerCursor() == null) {
            this.clearCursorOnCleaner();
        }
        return hasNext;
    }

    @Override
    public DBObject next() {
        this.checkIteratorOrArray(IteratorOrArray.ITERATOR);
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nextInternal();
    }

    @Override
    public int available() {
        return this.cursor != null ? this.cursor.available() : 0;
    }

    @Nullable
    public DBObject tryNext() {
        if (this.cursor == null) {
            FindOperation<DBObject> operation = this.getQueryOperation(this.decoder);
            if (!operation.getCursorType().isTailable()) {
                throw new IllegalArgumentException("Can only be used with a tailable cursor");
            }
            this.initializeCursor(operation);
        }
        DBObject next = (DBObject)this.cursor.tryNext();
        if (this.cursor.getServerCursor() == null) {
            this.clearCursorOnCleaner();
        }
        return this.currentObject(next);
    }

    public DBObject curr() {
        return this.currentObject;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int getLimit() {
        return this.findOptions.getLimit();
    }

    public int getBatchSize() {
        return this.findOptions.getBatchSize();
    }

    public DBCursor comment(String comment) {
        this.findOptions.comment(comment);
        return this;
    }

    public DBCursor max(DBObject max) {
        this.findOptions.max(max);
        return this;
    }

    public DBCursor min(DBObject min) {
        this.findOptions.min(min);
        return this;
    }

    public DBCursor returnKey() {
        this.findOptions.returnKey(true);
        return this;
    }

    public DBCursor hint(DBObject indexKeys) {
        this.findOptions.hint(indexKeys);
        return this;
    }

    public DBCursor hint(String indexName) {
        this.findOptions.hintString(indexName);
        return this;
    }

    public DBCursor maxTime(long maxTime, TimeUnit timeUnit) {
        this.findOptions.maxTime(maxTime, timeUnit);
        return this;
    }

    public DBObject explain() {
        return (DBObject)this.executor.execute(this.getQueryOperation((Decoder<DBObject>)this.collection.getObjectCodec()).asExplainableOperation(null, (Decoder)MongoClient.getDefaultCodecRegistry().get(DBObject.class)), this.getReadPreference(), this.getReadConcern());
    }

    public DBCursor cursorType(CursorType cursorType) {
        this.findOptions.cursorType(cursorType);
        return this;
    }

    public DBCursor noCursorTimeout(boolean noCursorTimeout) {
        this.findOptions.noCursorTimeout(noCursorTimeout);
        return this;
    }

    public DBCursor partial(boolean partial) {
        this.findOptions.partial(partial);
        return this;
    }

    private FindOperation<DBObject> getQueryOperation(Decoder<DBObject> decoder) {
        return new FindOperation(this.collection.getNamespace(), decoder).filter(this.collection.wrapAllowNull(this.filter)).batchSize(this.findOptions.getBatchSize()).skip(this.findOptions.getSkip()).limit(this.findOptions.getLimit()).maxAwaitTime(this.findOptions.getMaxAwaitTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).maxTime(this.findOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).projection(this.collection.wrapAllowNull(this.findOptions.getProjection())).sort(this.collection.wrapAllowNull(this.findOptions.getSort())).collation(this.findOptions.getCollation()).comment((BsonValue)(this.findOptions.getComment() != null ? new BsonString(this.findOptions.getComment()) : null)).hint((BsonValue)(this.findOptions.getHint() != null ? this.collection.wrapAllowNull(this.findOptions.getHint()) : (this.findOptions.getHintString() != null ? new BsonString(this.findOptions.getHintString()) : null))).min(this.collection.wrapAllowNull(this.findOptions.getMin())).max(this.collection.wrapAllowNull(this.findOptions.getMax())).cursorType(this.findOptions.getCursorType()).noCursorTimeout(this.findOptions.isNoCursorTimeout()).partial(this.findOptions.isPartial()).returnKey(this.findOptions.isReturnKey()).showRecordId(this.findOptions.isShowRecordId()).retryReads(this.retryReads);
    }

    public DBCursor sort(DBObject orderBy) {
        this.findOptions.sort(orderBy);
        return this;
    }

    public DBCursor limit(int limit) {
        this.findOptions.limit(limit);
        return this;
    }

    public DBCursor batchSize(int numberOfElements) {
        this.findOptions.batchSize(numberOfElements);
        return this;
    }

    public DBCursor skip(int numberOfElements) {
        this.findOptions.skip(numberOfElements);
        return this;
    }

    @Override
    public long getCursorId() {
        if (this.cursor != null) {
            ServerCursor serverCursor = this.cursor.getServerCursor();
            if (serverCursor == null) {
                return 0L;
            }
            return serverCursor.getId();
        }
        return 0L;
    }

    public int numSeen() {
        return this.numSeen;
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
            this.clearCursorOnCleaner();
        }
        this.currentObject = null;
    }

    @Override
    public Iterator<DBObject> iterator() {
        return this.copy();
    }

    public List<DBObject> toArray() {
        return this.toArray(Integer.MAX_VALUE);
    }

    public List<DBObject> toArray(int max) {
        this.checkIteratorOrArray(IteratorOrArray.ARRAY);
        this.fillArray(max - 1);
        return this.all;
    }

    public int count() {
        DBCollectionCountOptions countOptions = this.getDbCollectionCountOptions();
        return (int)this.collection.getCount(this.getQuery(), countOptions);
    }

    @Nullable
    public DBObject one() {
        try (DBCursor findOneCursor = this.copy().limit(-1);){
            DBObject dBObject = findOneCursor.hasNext() ? findOneCursor.next() : null;
            return dBObject;
        }
    }

    public int length() {
        this.checkIteratorOrArray(IteratorOrArray.ARRAY);
        this.fillArray(Integer.MAX_VALUE);
        return this.all.size();
    }

    public int itcount() {
        int n = 0;
        while (this.hasNext()) {
            this.next();
            ++n;
        }
        return n;
    }

    public int size() {
        DBCollectionCountOptions countOptions = this.getDbCollectionCountOptions().skip(this.findOptions.getSkip()).limit(this.findOptions.getLimit());
        return (int)this.collection.getCount(this.getQuery(), countOptions);
    }

    @Nullable
    public DBObject getKeysWanted() {
        return this.findOptions.getProjection();
    }

    public DBObject getQuery() {
        return this.filter;
    }

    public DBCollection getCollection() {
        return this.collection;
    }

    @Override
    @Nullable
    public ServerAddress getServerAddress() {
        if (this.cursor != null) {
            return this.cursor.getServerAddress();
        }
        return null;
    }

    public DBCursor setReadPreference(ReadPreference readPreference) {
        this.findOptions.readPreference(readPreference);
        return this;
    }

    public ReadPreference getReadPreference() {
        ReadPreference readPreference = this.findOptions.getReadPreference();
        if (readPreference != null) {
            return readPreference;
        }
        return this.collection.getReadPreference();
    }

    DBCursor setReadConcern(@Nullable ReadConcern readConcern) {
        this.findOptions.readConcern(readConcern);
        return this;
    }

    ReadConcern getReadConcern() {
        ReadConcern readConcern = this.findOptions.getReadConcern();
        if (readConcern != null) {
            return readConcern;
        }
        return this.collection.getReadConcern();
    }

    @Nullable
    public Collation getCollation() {
        return this.findOptions.getCollation();
    }

    public DBCursor setCollation(@Nullable Collation collation) {
        this.findOptions.collation(collation);
        return this;
    }

    public DBCursor setDecoderFactory(DBDecoderFactory factory) {
        this.decoderFactory = factory;
        this.decoder = new DBDecoderAdapter(factory.create(), this.collection, (BufferProvider)PowerOfTwoBufferPool.DEFAULT);
        return this;
    }

    public DBDecoderFactory getDecoderFactory() {
        return this.decoderFactory;
    }

    public String toString() {
        return "DBCursor{collection=" + this.collection + ", find=" + this.findOptions + (this.cursor != null ? ", cursor=" + this.cursor.getServerCursor() : "") + '}';
    }

    private void initializeCursor(FindOperation<DBObject> operation) {
        this.cursor = new MongoBatchCursorAdapter((BatchCursor)this.executor.execute(operation, this.getReadPreference(), this.getReadConcern()));
        ServerCursor serverCursor = this.cursor.getServerCursor();
        if (this.isCursorFinalizerEnabled() && serverCursor != null) {
            this.optionalCleaner = DBCursorCleaner.create(this.collection.getDB().getMongoClient(), this.collection.getNamespace(), serverCursor);
        }
    }

    private void clearCursorOnCleaner() {
        if (this.optionalCleaner != null) {
            this.optionalCleaner.clearCursor();
        }
    }

    private boolean isCursorFinalizerEnabled() {
        return this.collection.getDB().getMongoClient().getMongoClientOptions().isCursorFinalizerEnabled();
    }

    private void checkIteratorOrArray(IteratorOrArray expected) {
        if (this.iteratorOrArray == null) {
            this.iteratorOrArray = expected;
            return;
        }
        if (expected == this.iteratorOrArray) {
            return;
        }
        throw new IllegalArgumentException("Can't switch cursor access methods");
    }

    private void fillArray(int n) {
        this.checkIteratorOrArray(IteratorOrArray.ARRAY);
        while (n >= this.all.size() && this.hasNext()) {
            this.all.add(this.nextInternal());
        }
    }

    private DBObject nextInternal() {
        if (this.iteratorOrArray == null) {
            this.checkIteratorOrArray(IteratorOrArray.ITERATOR);
        }
        DBObject next = (DBObject)this.cursor.next();
        if (this.cursor.getServerCursor() == null) {
            this.clearCursorOnCleaner();
        }
        return this.currentObjectNonNull(next);
    }

    @Nullable
    private DBObject currentObject(@Nullable DBObject newCurrentObject) {
        if (newCurrentObject != null) {
            this.currentObject = newCurrentObject;
            ++this.numSeen;
            DBObject projection = this.findOptions.getProjection();
            if (projection != null && !projection.keySet().isEmpty()) {
                this.currentObject.markAsPartialObject();
            }
        }
        return newCurrentObject;
    }

    private DBObject currentObjectNonNull(DBObject newCurrentObject) {
        this.currentObject = newCurrentObject;
        ++this.numSeen;
        DBObject projection = this.findOptions.getProjection();
        if (projection != null && !projection.keySet().isEmpty()) {
            this.currentObject.markAsPartialObject();
        }
        return newCurrentObject;
    }

    private DBCollectionCountOptions getDbCollectionCountOptions() {
        return new DBCollectionCountOptions().readPreference(this.getReadPreference()).readConcern(this.getReadConcern()).collation(this.getCollation()).maxTime(this.findOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).hint(this.findOptions.getHint()).hintString(this.findOptions.getHintString());
    }

    private static enum IteratorOrArray {
        ITERATOR,
        ARRAY;

    }
}

