/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.LoggerSettings;
import com.mongodb.MongoCommandException;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.event.CommandListener;
import com.mongodb.internal.ExceptionUtils;
import com.mongodb.internal.connection.ByteBufferBsonOutput;
import com.mongodb.internal.connection.CommandEventSender;
import com.mongodb.internal.connection.CommandMessage;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ProtocolHelper;
import com.mongodb.internal.connection.ResponseBuffers;
import com.mongodb.internal.logging.LogMessage;
import com.mongodb.internal.logging.StructuredLogger;
import com.mongodb.lang.Nullable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.codecs.RawBsonDocumentCodec;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;

class LoggingCommandEventSender
implements CommandEventSender {
    private static final double NANOS_PER_MILLI = 1000000.0;
    private final ConnectionDescription description;
    @Nullable
    private final CommandListener commandListener;
    private final OperationContext operationContext;
    private final StructuredLogger logger;
    private final LoggerSettings loggerSettings;
    private final long startTimeNanos;
    private final CommandMessage message;
    private final String commandName;
    private volatile BsonDocument commandDocument;
    private final boolean redactionRequired;

    LoggingCommandEventSender(Set<String> securitySensitiveCommands, Set<String> securitySensitiveHelloCommands, ConnectionDescription description, @Nullable CommandListener commandListener, OperationContext operationContext, CommandMessage message, ByteBufferBsonOutput bsonOutput, StructuredLogger logger, LoggerSettings loggerSettings) {
        this.description = description;
        this.commandListener = commandListener;
        this.operationContext = operationContext;
        this.logger = logger;
        this.loggerSettings = loggerSettings;
        this.startTimeNanos = System.nanoTime();
        this.message = message;
        this.commandDocument = message.getCommandDocument(bsonOutput);
        this.commandName = this.commandDocument.getFirstKey();
        this.redactionRequired = securitySensitiveCommands.contains(this.commandName) || securitySensitiveHelloCommands.contains(this.commandName) && this.commandDocument.containsKey((Object)"speculativeAuthenticate");
    }

    @Override
    public void sendStartedEvent() {
        if (this.loggingRequired()) {
            String messagePrefix = "Command \"{}\" started on database \"{}\"";
            String command = this.redactionRequired ? "{}" : this.getTruncatedJsonCommand(this.commandDocument);
            this.logEventMessage(messagePrefix, "Command started", null, (List<LogMessage.Entry> entries) -> {
                entries.add(new LogMessage.Entry(LogMessage.Entry.Name.COMMAND_NAME, this.commandName));
                entries.add(new LogMessage.Entry(LogMessage.Entry.Name.DATABASE_NAME, this.message.getDatabase()));
            }, (List<LogMessage.Entry> entries) -> entries.add(new LogMessage.Entry(LogMessage.Entry.Name.COMMAND_CONTENT, command)));
        }
        if (this.eventRequired()) {
            BsonDocument commandDocumentForEvent = this.redactionRequired ? new BsonDocument() : this.commandDocument;
            ProtocolHelper.sendCommandStartedEvent(this.message, this.message.getDatabase(), this.commandName, commandDocumentForEvent, this.description, Assertions.assertNotNull(this.commandListener), this.operationContext);
        }
        this.commandDocument = null;
    }

    @Override
    public void sendFailedEvent(Throwable t) {
        Throwable commandEventException = t;
        if (t instanceof MongoCommandException && this.redactionRequired) {
            commandEventException = ExceptionUtils.MongoCommandExceptionUtils.redacted((MongoCommandException)t);
        }
        long elapsedTimeNanos = System.nanoTime() - this.startTimeNanos;
        if (this.loggingRequired()) {
            String messagePrefix = "Command \"{}\" failed on database \"{}\" in {} ms";
            this.logEventMessage(messagePrefix, "Command failed", commandEventException, (List<LogMessage.Entry> entries) -> {
                entries.add(new LogMessage.Entry(LogMessage.Entry.Name.COMMAND_NAME, this.commandName));
                entries.add(new LogMessage.Entry(LogMessage.Entry.Name.DATABASE_NAME, this.message.getDatabase()));
                entries.add(new LogMessage.Entry(LogMessage.Entry.Name.DURATION_MS, (double)elapsedTimeNanos / 1000000.0));
            }, (List<LogMessage.Entry> entries) -> entries.add(new LogMessage.Entry(LogMessage.Entry.Name.COMMAND_CONTENT, null)));
        }
        if (this.eventRequired()) {
            ProtocolHelper.sendCommandFailedEvent(this.message, this.commandName, this.message.getDatabase(), this.description, elapsedTimeNanos, commandEventException, this.commandListener, this.operationContext);
        }
    }

    @Override
    public void sendSucceededEvent(ResponseBuffers responseBuffers) {
        this.sendSucceededEvent((BsonDocument)responseBuffers.getResponseDocument(this.message.getId(), new RawBsonDocumentCodec()));
    }

    @Override
    public void sendSucceededEventForOneWayCommand() {
        this.sendSucceededEvent(new BsonDocument("ok", (BsonValue)new BsonInt32(1)));
    }

    private void sendSucceededEvent(BsonDocument reply) {
        long elapsedTimeNanos = System.nanoTime() - this.startTimeNanos;
        if (this.loggingRequired()) {
            String format = "Command \"{}\" succeeded on database \"{}\" in {} ms using a connection with driver-generated ID {}[ and server-generated ID {}] to {}:{}[ with service ID {}]. The request ID is {} and the operation ID is {}. Command reply: {}";
            BsonDocument responseDocumentForEvent = this.redactionRequired ? new BsonDocument() : reply;
            String replyString = this.redactionRequired ? "{}" : this.getTruncatedJsonCommand(responseDocumentForEvent);
            this.logEventMessage("Command succeeded", null, (List<LogMessage.Entry> entries) -> {
                entries.add(new LogMessage.Entry(LogMessage.Entry.Name.COMMAND_NAME, this.commandName));
                entries.add(new LogMessage.Entry(LogMessage.Entry.Name.DATABASE_NAME, this.message.getDatabase()));
                entries.add(new LogMessage.Entry(LogMessage.Entry.Name.DURATION_MS, (double)elapsedTimeNanos / 1000000.0));
            }, (List<LogMessage.Entry> entries) -> entries.add(new LogMessage.Entry(LogMessage.Entry.Name.REPLY, replyString)), format);
        }
        if (this.eventRequired()) {
            BsonDocument responseDocumentForEvent = this.redactionRequired ? new BsonDocument() : reply;
            ProtocolHelper.sendCommandSucceededEvent(this.message, this.commandName, this.message.getDatabase(), responseDocumentForEvent, this.description, elapsedTimeNanos, this.commandListener, this.operationContext);
        }
    }

    private boolean loggingRequired() {
        return this.logger.isRequired(LogMessage.Level.DEBUG, this.getClusterId());
    }

    private ClusterId getClusterId() {
        return this.description.getConnectionId().getServerId().getClusterId();
    }

    private boolean eventRequired() {
        return this.commandListener != null;
    }

    private void logEventMessage(String messagePrefix, String messageId, @Nullable Throwable exception, Consumer<List<LogMessage.Entry>> prefixEntriesMutator, Consumer<List<LogMessage.Entry>> suffixEntriesMutator) {
        String format = messagePrefix + " using a connection with driver-generated ID {}[ and server-generated ID {}] to {}:{}[ with service ID {}]. The request ID is {} and the operation ID is {}.[ Command: {}]";
        this.logEventMessage(messageId, exception, prefixEntriesMutator, suffixEntriesMutator, format);
    }

    private void logEventMessage(String messageId, @Nullable Throwable exception, Consumer<List<LogMessage.Entry>> prefixEntriesMutator, Consumer<List<LogMessage.Entry>> suffixEntriesMutator, String format) {
        ArrayList<LogMessage.Entry> entries = new ArrayList<LogMessage.Entry>();
        prefixEntriesMutator.accept(entries);
        entries.add(new LogMessage.Entry(LogMessage.Entry.Name.DRIVER_CONNECTION_ID, this.description.getConnectionId().getLocalValue()));
        entries.add(new LogMessage.Entry(LogMessage.Entry.Name.SERVER_CONNECTION_ID, this.description.getConnectionId().getServerValue()));
        entries.add(new LogMessage.Entry(LogMessage.Entry.Name.SERVER_HOST, this.description.getServerAddress().getHost()));
        entries.add(new LogMessage.Entry(LogMessage.Entry.Name.SERVER_PORT, this.description.getServerAddress().getPort()));
        entries.add(new LogMessage.Entry(LogMessage.Entry.Name.SERVICE_ID, this.description.getServiceId()));
        entries.add(new LogMessage.Entry(LogMessage.Entry.Name.REQUEST_ID, this.message.getId()));
        entries.add(new LogMessage.Entry(LogMessage.Entry.Name.OPERATION_ID, this.operationContext.getId()));
        suffixEntriesMutator.accept(entries);
        this.logger.log(new LogMessage(LogMessage.Component.COMMAND, LogMessage.Level.DEBUG, messageId, this.getClusterId(), exception, entries, format));
    }

    private String getTruncatedJsonCommand(BsonDocument commandDocument) {
        StringWriter writer = new StringWriter();
        try (BsonReader bsonReader = commandDocument.asBsonReader();){
            JsonWriter jsonWriter = new JsonWriter((Writer)writer, JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).maxLength(this.loggerSettings.getMaxDocumentLength()).build());
            jsonWriter.pipe(bsonReader);
            if (jsonWriter.isTruncated()) {
                writer.append(" ...");
            }
            String string = writer.toString();
            return string;
        }
    }
}

