/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.LoggerSettings;
import com.mongodb.MongoCompressor;
import com.mongodb.ServerApi;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ServerId;
import com.mongodb.event.CommandListener;
import com.mongodb.internal.connection.Authenticator;
import com.mongodb.internal.connection.AwsAuthenticator;
import com.mongodb.internal.connection.ClientMetadata;
import com.mongodb.internal.connection.ConnectionGenerationSupplier;
import com.mongodb.internal.connection.DefaultAuthenticator;
import com.mongodb.internal.connection.GSSAPIAuthenticator;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.InternalConnectionFactory;
import com.mongodb.internal.connection.InternalStreamConnection;
import com.mongodb.internal.connection.InternalStreamConnectionInitializer;
import com.mongodb.internal.connection.MongoCredentialWithCache;
import com.mongodb.internal.connection.OidcAuthenticator;
import com.mongodb.internal.connection.PlainAuthenticator;
import com.mongodb.internal.connection.ScramShaAuthenticator;
import com.mongodb.internal.connection.StreamFactory;
import com.mongodb.internal.connection.X509Authenticator;
import com.mongodb.lang.Nullable;
import java.util.List;

class InternalStreamConnectionFactory
implements InternalConnectionFactory {
    private final ClusterConnectionMode clusterConnectionMode;
    private final boolean isMonitoringConnection;
    private final StreamFactory streamFactory;
    private final ClientMetadata clientMetadata;
    private final List<MongoCompressor> compressorList;
    private final LoggerSettings loggerSettings;
    private final CommandListener commandListener;
    @Nullable
    private final ServerApi serverApi;
    private final MongoCredentialWithCache credential;

    InternalStreamConnectionFactory(ClusterConnectionMode clusterConnectionMode, StreamFactory streamFactory, @Nullable MongoCredentialWithCache credential, ClientMetadata clientMetadata, List<MongoCompressor> compressorList, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable ServerApi serverApi) {
        this(clusterConnectionMode, false, streamFactory, credential, clientMetadata, compressorList, loggerSettings, commandListener, serverApi);
    }

    InternalStreamConnectionFactory(ClusterConnectionMode clusterConnectionMode, boolean isMonitoringConnection, StreamFactory streamFactory, @Nullable MongoCredentialWithCache credential, ClientMetadata clientMetadata, List<MongoCompressor> compressorList, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable ServerApi serverApi) {
        this.clusterConnectionMode = clusterConnectionMode;
        this.isMonitoringConnection = isMonitoringConnection;
        this.streamFactory = Assertions.notNull("streamFactory", streamFactory);
        this.compressorList = Assertions.notNull("compressorList", compressorList);
        this.loggerSettings = loggerSettings;
        this.commandListener = commandListener;
        this.serverApi = serverApi;
        this.clientMetadata = clientMetadata;
        this.credential = credential;
    }

    @Override
    public InternalConnection create(ServerId serverId, ConnectionGenerationSupplier connectionGenerationSupplier) {
        Authenticator authenticator = this.credential == null ? null : this.createAuthenticator(this.credential);
        InternalStreamConnectionInitializer connectionInitializer = new InternalStreamConnectionInitializer(this.clusterConnectionMode, authenticator, this.clientMetadata.getBsonDocument(), this.compressorList, this.serverApi);
        return new InternalStreamConnection(this.clusterConnectionMode, authenticator, this.isMonitoringConnection, serverId, connectionGenerationSupplier, this.streamFactory, this.compressorList, this.loggerSettings, this.commandListener, connectionInitializer);
    }

    private Authenticator createAuthenticator(MongoCredentialWithCache credential) {
        AuthenticationMechanism authenticationMechanism = credential.getAuthenticationMechanism();
        if (authenticationMechanism == null) {
            return new DefaultAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
        }
        switch (authenticationMechanism) {
            case GSSAPI: {
                return new GSSAPIAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case PLAIN: {
                return new PlainAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case MONGODB_X509: {
                return new X509Authenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case SCRAM_SHA_1: 
            case SCRAM_SHA_256: {
                return new ScramShaAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case MONGODB_AWS: {
                return new AwsAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case MONGODB_OIDC: {
                return new OidcAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
        }
        throw new IllegalArgumentException("Unsupported authentication mechanism " + (Object)((Object)authenticationMechanism));
    }
}

