/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoDriverInformation;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.Locks;
import com.mongodb.internal.connection.FaasEnvironment;
import com.mongodb.lang.Nullable;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.EncoderContext;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;

@ThreadSafe
public class ClientMetadata {
    private static final String SEPARATOR = "|";
    private static final int MAXIMUM_CLIENT_METADATA_ENCODED_SIZE = 512;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final String applicationName;
    private BsonDocument clientMetadataBsonDocument;
    private DriverInformation driverInformation;

    public ClientMetadata(@Nullable String applicationName, MongoDriverInformation mongoDriverInformation) {
        this.applicationName = applicationName;
        Locks.withLock((Lock)this.readWriteLock.writeLock(), () -> {
            this.driverInformation = DriverInformation.from(mongoDriverInformation.getDriverNames(), mongoDriverInformation.getDriverVersions(), mongoDriverInformation.getDriverPlatforms());
            this.clientMetadataBsonDocument = ClientMetadata.createClientMetadataDocument(applicationName, this.driverInformation);
        });
    }

    public BsonDocument getBsonDocument() {
        return Locks.withLock((Lock)this.readWriteLock.readLock(), () -> this.clientMetadataBsonDocument);
    }

    public void append(MongoDriverInformation mongoDriverInformationToAppend) {
        Locks.withLock((Lock)this.readWriteLock.writeLock(), () -> {
            this.driverInformation.append(mongoDriverInformationToAppend.getDriverNames(), mongoDriverInformationToAppend.getDriverVersions(), mongoDriverInformationToAppend.getDriverPlatforms());
            this.clientMetadataBsonDocument = ClientMetadata.createClientMetadataDocument(this.applicationName, this.driverInformation);
        });
    }

    private static BsonDocument createClientMetadataDocument(@Nullable String applicationName, DriverInformation driverInformation) {
        if (applicationName != null) {
            Assertions.isTrueArgument("applicationName UTF-8 encoding length <= 128", applicationName.getBytes(StandardCharsets.UTF_8).length <= 128);
        }
        BsonDocument client = new BsonDocument();
        ClientMetadata.tryWithLimit(client, d -> ClientMetadata.putAtPath(d, "application.name", applicationName));
        ClientMetadata.tryWithLimit(client, d -> {
            ClientMetadata.putAtPath(d, "driver.name", driverInformation.getInitialDriverName());
            ClientMetadata.putAtPath(d, "driver.version", driverInformation.getInitialDriverVersion());
        });
        ClientMetadata.tryWithLimit(client, d -> ClientMetadata.putAtPath(d, "os.type", ClientMetadata.getOperatingSystemType(ClientMetadata.getOperatingSystemName())));
        ClientMetadata.tryWithLimit(client, d -> {
            ClientMetadata.putAtPath(d, "driver.name", ClientMetadata.listToString(driverInformation.getAllDriverNames()));
            ClientMetadata.putAtPath(d, "driver.version", ClientMetadata.listToString(driverInformation.getAllDriverVersions()));
        });
        FaasEnvironment faasEnvironment = FaasEnvironment.getFaasEnvironment();
        ContainerRuntime containerRuntime = ContainerRuntime.determineExecutionContainer();
        Orchestrator orchestrator = Orchestrator.determineExecutionOrchestrator();
        ClientMetadata.tryWithLimit(client, d -> ClientMetadata.putAtPath(d, "platform", driverInformation.getInitialDriverPlatform()));
        ClientMetadata.tryWithLimit(client, d -> ClientMetadata.putAtPath(d, "platform", ClientMetadata.listToString(driverInformation.getAllDriverPlatforms())));
        ClientMetadata.tryWithLimit(client, d -> ClientMetadata.putAtPath(d, "os.name", ClientMetadata.getOperatingSystemName()));
        ClientMetadata.tryWithLimit(client, d -> ClientMetadata.putAtPath(d, "os.architecture", System.getProperty("os.arch", "unknown")));
        ClientMetadata.tryWithLimit(client, d -> ClientMetadata.putAtPath(d, "os.version", System.getProperty("os.version", "unknown")));
        ClientMetadata.tryWithLimit(client, d -> ClientMetadata.putAtPath(d, "env.name", faasEnvironment.getName()));
        ClientMetadata.tryWithLimit(client, d -> ClientMetadata.putAtPath(d, "env.timeout_sec", faasEnvironment.getTimeoutSec()));
        ClientMetadata.tryWithLimit(client, d -> ClientMetadata.putAtPath(d, "env.memory_mb", faasEnvironment.getMemoryMb()));
        ClientMetadata.tryWithLimit(client, d -> ClientMetadata.putAtPath(d, "env.region", faasEnvironment.getRegion()));
        ClientMetadata.tryWithLimit(client, d -> ClientMetadata.putAtPath(d, "env.container.runtime", containerRuntime.getName()));
        ClientMetadata.tryWithLimit(client, d -> ClientMetadata.putAtPath(d, "env.container.orchestrator", orchestrator.getName()));
        return client;
    }

    private static void putAtPath(BsonDocument d, String path, @Nullable String value) {
        if (value == null) {
            return;
        }
        ClientMetadata.putAtPath(d, path, (BsonValue)new BsonString(value));
    }

    private static void putAtPath(BsonDocument d, String path, @Nullable Integer value) {
        if (value == null) {
            return;
        }
        ClientMetadata.putAtPath(d, path, (BsonValue)new BsonInt32(value.intValue()));
    }

    private static void putAtPath(BsonDocument d, String path, @Nullable BsonValue value) {
        if (value == null) {
            return;
        }
        String[] split = path.split("\\.", 2);
        String first = split[0];
        if (split.length == 1) {
            d.append(first, value);
        } else {
            BsonDocument child;
            if (d.containsKey((Object)first)) {
                child = d.getDocument((Object)first);
            } else {
                child = new BsonDocument();
                d.append(first, (BsonValue)child);
            }
            String rest = split[1];
            ClientMetadata.putAtPath(child, rest, value);
        }
    }

    private static void tryWithLimit(BsonDocument document, Consumer<BsonDocument> modifier) {
        try {
            BsonDocument temp = document.clone();
            modifier.accept(temp);
            if (!ClientMetadata.clientMetadataDocumentTooLarge(temp)) {
                modifier.accept(document);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static boolean clientMetadataDocumentTooLarge(BsonDocument document) {
        BasicOutputBuffer buffer = new BasicOutputBuffer(512);
        new BsonDocumentCodec().encode((BsonWriter)new BsonBinaryWriter((BsonOutput)buffer), document, EncoderContext.builder().build());
        return buffer.getPosition() > 512;
    }

    private static String listToString(List<String> listOfStrings) {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        for (String val : listOfStrings) {
            if (i > 0) {
                stringBuilder.append(SEPARATOR);
            }
            stringBuilder.append(val);
            ++i;
        }
        return stringBuilder.toString();
    }

    public static String getOperatingSystemType(String operatingSystemName) {
        if (ClientMetadata.nameStartsWith(operatingSystemName, "linux")) {
            return "Linux";
        }
        if (ClientMetadata.nameStartsWith(operatingSystemName, "mac")) {
            return "Darwin";
        }
        if (ClientMetadata.nameStartsWith(operatingSystemName, "windows")) {
            return "Windows";
        }
        if (ClientMetadata.nameStartsWith(operatingSystemName, "hp-ux", "aix", "irix", "solaris", "sunos")) {
            return "Unix";
        }
        return "unknown";
    }

    private static String getOperatingSystemName() {
        return System.getProperty("os.name", "unknown");
    }

    private static boolean nameStartsWith(String name, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!name.toLowerCase().startsWith(prefix.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static class DriverInformation {
        private final List<String> driverNames = new ArrayList<String>();
        private final List<String> driverVersions;
        private final List<String> driverPlatforms;
        private final String initialPlatform;

        DriverInformation() {
            this.driverNames.add("mongo-java-driver");
            this.driverVersions = new ArrayList<String>();
            this.driverVersions.add("5.6.0");
            this.initialPlatform = String.format("Java/%s/%s", System.getProperty("java.vendor", "unknown-vendor"), System.getProperty("java.runtime.version", "unknown-version"));
            this.driverPlatforms = new ArrayList<String>();
            this.driverPlatforms.add(this.initialPlatform);
        }

        static DriverInformation from(List<String> driverNames, List<String> driverVersions, List<String> driverPlatforms) {
            DriverInformation driverInformation = new DriverInformation();
            return driverInformation.append(driverNames, driverVersions, driverPlatforms);
        }

        DriverInformation append(List<String> driverNames, List<String> driverVersions, List<String> driverPlatforms) {
            this.driverNames.addAll(driverNames);
            this.driverVersions.addAll(driverVersions);
            this.driverPlatforms.addAll(driverPlatforms);
            return this;
        }

        public String getInitialDriverPlatform() {
            return this.initialPlatform;
        }

        public String getInitialDriverName() {
            return "mongo-java-driver";
        }

        public String getInitialDriverVersion() {
            return "5.6.0";
        }

        public List<String> getAllDriverNames() {
            return this.driverNames;
        }

        public List<String> getAllDriverVersions() {
            return this.driverVersions;
        }

        public List<String> getAllDriverPlatforms() {
            return this.driverPlatforms;
        }
    }

    private static enum ContainerRuntime {
        DOCKER("docker"){

            @Override
            boolean isCurrentRuntimeContainer() {
                try {
                    return Files.exists(Paths.get(File.separator + ".dockerenv", new String[0]), new LinkOption[0]);
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        ,
        UNKNOWN(null);

        @Nullable
        private final String name;

        private ContainerRuntime(String name) {
            this.name = name;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        boolean isCurrentRuntimeContainer() {
            return false;
        }

        static ContainerRuntime determineExecutionContainer() {
            for (ContainerRuntime allegedContainer : ContainerRuntime.values()) {
                if (!allegedContainer.isCurrentRuntimeContainer()) continue;
                return allegedContainer;
            }
            return UNKNOWN;
        }
    }

    private static enum Orchestrator {
        K8S("kubernetes"){

            @Override
            boolean isCurrentOrchestrator() {
                return FaasEnvironment.getEnv("KUBERNETES_SERVICE_HOST") != null;
            }
        }
        ,
        UNKNOWN(null);

        @Nullable
        private final String name;

        private Orchestrator(String name) {
            this.name = name;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        boolean isCurrentOrchestrator() {
            return false;
        }

        static Orchestrator determineExecutionOrchestrator() {
            for (Orchestrator alledgedOrchestrator : Orchestrator.values()) {
                if (!alledgedOrchestrator.isCurrentOrchestrator()) continue;
                return alledgedOrchestrator;
            }
            return UNKNOWN;
        }
    }
}

