/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoSocketException;
import com.mongodb.ServerAddress;
import com.mongodb.UnixServerAddress;
import com.mongodb.internal.connection.DefaultInetAddressResolver;
import com.mongodb.spi.dns.InetAddressResolver;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.stream.Collectors;

public final class ServerAddressHelper {
    public static ServerAddress createServerAddress(String host) {
        return ServerAddressHelper.createServerAddress(host, ServerAddress.defaultPort());
    }

    public static ServerAddress createServerAddress(String host, int port) {
        if (host != null && host.endsWith(".sock")) {
            return new UnixServerAddress(host);
        }
        return new ServerAddress(host, port);
    }

    public static InetAddressResolver getInetAddressResolver(MongoClientSettings settings) {
        InetAddressResolver inetAddressResolver = settings.getInetAddressResolver();
        return inetAddressResolver == null ? new DefaultInetAddressResolver() : inetAddressResolver;
    }

    public static List<InetSocketAddress> getSocketAddresses(ServerAddress serverAddress, InetAddressResolver resolver) {
        try {
            return resolver.lookupByName(serverAddress.getHost()).stream().map(inetAddress -> new InetSocketAddress((InetAddress)inetAddress, serverAddress.getPort())).collect(Collectors.toList());
        }
        catch (UnknownHostException e) {
            throw new MongoSocketException(e.getMessage(), serverAddress, (Throwable)e);
        }
    }

    private ServerAddressHelper() {
    }
}

