/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoChangeStreamException;
import com.mongodb.MongoException;
import com.mongodb.internal.async.AsyncAggregateResponseBatchCursor;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.operation.ChangeStreamBatchCursorHelper;
import com.mongodb.internal.operation.ChangeStreamOperation;
import com.mongodb.internal.operation.OperationHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.RawBsonDocument;

final class AsyncChangeStreamBatchCursor<T>
implements AsyncAggregateResponseBatchCursor<T> {
    private final AsyncReadBinding binding;
    private final ChangeStreamOperation<T> changeStreamOperation;
    private final int maxWireVersion;
    private volatile BsonDocument resumeToken;
    private volatile AsyncAggregateResponseBatchCursor<RawBsonDocument> wrapped;
    private final AtomicBoolean isClosed;

    AsyncChangeStreamBatchCursor(ChangeStreamOperation<T> changeStreamOperation, AsyncAggregateResponseBatchCursor<RawBsonDocument> wrapped, AsyncReadBinding binding, BsonDocument resumeToken, int maxWireVersion) {
        this.changeStreamOperation = changeStreamOperation;
        this.wrapped = wrapped;
        this.binding = binding;
        binding.retain();
        this.resumeToken = resumeToken;
        this.maxWireVersion = maxWireVersion;
        this.isClosed = new AtomicBoolean();
    }

    AsyncAggregateResponseBatchCursor<RawBsonDocument> getWrapped() {
        return this.wrapped;
    }

    @Override
    public void next(SingleResultCallback<List<T>> callback) {
        this.resumeableOperation(new AsyncBlock(){

            @Override
            public void apply(AsyncAggregateResponseBatchCursor<RawBsonDocument> cursor, SingleResultCallback<List<RawBsonDocument>> callback) {
                cursor.next(callback);
                AsyncChangeStreamBatchCursor.this.cachePostBatchResumeToken(cursor);
            }
        }, this.convertResultsCallback(callback), false);
    }

    @Override
    public void tryNext(SingleResultCallback<List<T>> callback) {
        this.resumeableOperation(new AsyncBlock(){

            @Override
            public void apply(AsyncAggregateResponseBatchCursor<RawBsonDocument> cursor, SingleResultCallback<List<RawBsonDocument>> callback) {
                cursor.tryNext(callback);
                AsyncChangeStreamBatchCursor.this.cachePostBatchResumeToken(cursor);
            }
        }, this.convertResultsCallback(callback), true);
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                this.wrapped.close();
            }
            finally {
                this.binding.release();
            }
        }
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.wrapped.setBatchSize(batchSize);
    }

    @Override
    public int getBatchSize() {
        return this.wrapped.getBatchSize();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public BsonDocument getPostBatchResumeToken() {
        return this.wrapped.getPostBatchResumeToken();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.changeStreamOperation.getStartAtOperationTime();
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.wrapped.isFirstBatchEmpty();
    }

    @Override
    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    private void cachePostBatchResumeToken(AsyncAggregateResponseBatchCursor<RawBsonDocument> queryBatchCursor) {
        if (queryBatchCursor.getPostBatchResumeToken() != null) {
            this.resumeToken = queryBatchCursor.getPostBatchResumeToken();
        }
    }

    private SingleResultCallback<List<RawBsonDocument>> convertResultsCallback(final SingleResultCallback<List<T>> callback) {
        return ErrorHandlingResultCallback.errorHandlingCallback(new SingleResultCallback<List<RawBsonDocument>>(){

            @Override
            public void onResult(List<RawBsonDocument> rawDocuments, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else if (rawDocuments != null) {
                    ArrayList<Object> results = new ArrayList<Object>();
                    for (RawBsonDocument rawDocument : rawDocuments) {
                        if (!rawDocument.containsKey((Object)"_id")) {
                            callback.onResult(null, new MongoChangeStreamException("Cannot provide resume functionality when the resume token is missing."));
                            return;
                        }
                        try {
                            results.add(rawDocument.decode(AsyncChangeStreamBatchCursor.this.changeStreamOperation.getDecoder()));
                        }
                        catch (Exception e) {
                            callback.onResult(null, e);
                            return;
                        }
                    }
                    AsyncChangeStreamBatchCursor.this.resumeToken = rawDocuments.get(rawDocuments.size() - 1).getDocument((Object)"_id");
                    callback.onResult(results, null);
                } else {
                    callback.onResult(null, null);
                }
            }
        }, OperationHelper.LOGGER);
    }

    private void resumeableOperation(final AsyncBlock asyncBlock, final SingleResultCallback<List<RawBsonDocument>> callback, final boolean tryNext) {
        if (this.isClosed.get()) {
            callback.onResult(null, new MongoException(String.format("%s called after the cursor was closed.", tryNext ? "tryNext()" : "next()")));
            return;
        }
        asyncBlock.apply(this.wrapped, new SingleResultCallback<List<RawBsonDocument>>(){

            @Override
            public void onResult(List<RawBsonDocument> result, Throwable t) {
                if (t == null) {
                    callback.onResult(result, null);
                } else if (ChangeStreamBatchCursorHelper.isRetryableError(t, AsyncChangeStreamBatchCursor.this.maxWireVersion)) {
                    AsyncChangeStreamBatchCursor.this.wrapped.close();
                    AsyncChangeStreamBatchCursor.this.retryOperation(asyncBlock, callback, tryNext);
                } else {
                    callback.onResult(null, t);
                }
            }
        });
    }

    private void retryOperation(final AsyncBlock asyncBlock, final SingleResultCallback<List<RawBsonDocument>> callback, final boolean tryNext) {
        OperationHelper.withAsyncReadConnection(this.binding, new OperationHelper.AsyncCallableWithSource(){

            @Override
            public void call(AsyncConnectionSource source, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    AsyncChangeStreamBatchCursor.this.changeStreamOperation.setChangeStreamOptionsForResume(AsyncChangeStreamBatchCursor.this.resumeToken, source.getServerDescription().getMaxWireVersion());
                    source.release();
                    AsyncChangeStreamBatchCursor.this.changeStreamOperation.executeAsync(AsyncChangeStreamBatchCursor.this.binding, new SingleResultCallback<AsyncBatchCursor<T>>(){

                        @Override
                        public void onResult(AsyncBatchCursor<T> result, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                AsyncChangeStreamBatchCursor.this.wrapped = ((AsyncChangeStreamBatchCursor)result).getWrapped();
                                AsyncChangeStreamBatchCursor.this.binding.release();
                                AsyncChangeStreamBatchCursor.this.resumeableOperation(asyncBlock, callback, tryNext);
                            }
                        }
                    });
                }
            }
        });
    }

    private static interface AsyncBlock {
        public void apply(AsyncAggregateResponseBatchCursor<RawBsonDocument> var1, SingleResultCallback<List<RawBsonDocument>> var2);
    }
}

