/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.LoggerSettings;
import com.mongodb.MongoCommandException;
import com.mongodb.RequestContext;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.event.CommandListener;
import com.mongodb.internal.connection.ByteBufferBsonOutput;
import com.mongodb.internal.connection.CommandEventSender;
import com.mongodb.internal.connection.CommandMessage;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ProtocolHelper;
import com.mongodb.internal.connection.ResponseBuffers;
import com.mongodb.internal.logging.StructuredLogMessage;
import com.mongodb.internal.logging.StructuredLogger;
import com.mongodb.lang.Nullable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.codecs.RawBsonDocumentCodec;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;
import org.bson.types.ObjectId;

class LoggingCommandEventSender
implements CommandEventSender {
    private static final double NANOS_PER_MILLI = 1000000.0;
    private final ConnectionDescription description;
    @Nullable
    private final CommandListener commandListener;
    private final RequestContext requestContext;
    private final OperationContext operationContext;
    private final StructuredLogger logger;
    private final LoggerSettings loggerSettings;
    private final long startTimeNanos;
    private final CommandMessage message;
    private final String commandName;
    private volatile BsonDocument commandDocument;
    private final boolean redactionRequired;

    LoggingCommandEventSender(Set<String> securitySensitiveCommands, Set<String> securitySensitiveHelloCommands, ConnectionDescription description, @Nullable CommandListener commandListener, RequestContext requestContext, OperationContext operationContext, CommandMessage message, ByteBufferBsonOutput bsonOutput, StructuredLogger logger, LoggerSettings loggerSettings) {
        this.description = description;
        this.commandListener = commandListener;
        this.requestContext = requestContext;
        this.operationContext = operationContext;
        this.logger = logger;
        this.loggerSettings = loggerSettings;
        this.startTimeNanos = System.nanoTime();
        this.message = message;
        this.commandDocument = message.getCommandDocument(bsonOutput);
        this.commandName = this.commandDocument.getFirstKey();
        this.redactionRequired = securitySensitiveCommands.contains(this.commandName) || securitySensitiveHelloCommands.contains(this.commandName) && this.commandDocument.containsKey((Object)"speculativeAuthenticate");
    }

    @Override
    public void sendStartedEvent() {
        if (this.loggingRequired()) {
            ArrayList<StructuredLogMessage.Entry> entries = new ArrayList<StructuredLogMessage.Entry>();
            StringBuilder builder = new StringBuilder("Command \"%s\" started on database %s");
            entries.add(new StructuredLogMessage.Entry("commandName", this.commandName));
            entries.add(new StructuredLogMessage.Entry("databaseName", this.message.getNamespace().getDatabaseName()));
            this.appendCommonLogFragment(entries, builder);
            builder.append(" Command: %s");
            entries.add(new StructuredLogMessage.Entry("command", this.redactionRequired ? "{}" : this.getTruncatedJsonCommand(this.commandDocument)));
            this.logger.log(new StructuredLogMessage(StructuredLogMessage.Component.COMMAND, StructuredLogMessage.Level.DEBUG, "Command started", this.getClusterId(), entries), builder.toString());
        }
        if (this.eventRequired()) {
            BsonDocument commandDocumentForEvent = this.redactionRequired ? new BsonDocument() : this.commandDocument;
            ProtocolHelper.sendCommandStartedEvent(this.message, this.message.getNamespace().getDatabaseName(), this.commandName, commandDocumentForEvent, this.description, Assertions.assertNotNull(this.commandListener), this.requestContext, this.operationContext);
        }
        this.commandDocument = null;
    }

    @Override
    public void sendFailedEvent(Throwable t) {
        Throwable commandEventException = t;
        if (t instanceof MongoCommandException && this.redactionRequired) {
            MongoCommandException originalCommandException = (MongoCommandException)t;
            commandEventException = new MongoCommandException(new BsonDocument(), originalCommandException.getServerAddress());
            commandEventException.setStackTrace(t.getStackTrace());
        }
        long elapsedTimeNanos = System.nanoTime() - this.startTimeNanos;
        if (this.loggingRequired()) {
            ArrayList<StructuredLogMessage.Entry> entries = new ArrayList<StructuredLogMessage.Entry>();
            StringBuilder builder = new StringBuilder("Command \"%s\" failed in %.2f ms");
            entries.add(new StructuredLogMessage.Entry("commandName", this.commandName));
            entries.add(new StructuredLogMessage.Entry("durationMS", (double)elapsedTimeNanos / 1000000.0));
            this.appendCommonLogFragment(entries, builder);
            this.logger.log(new StructuredLogMessage(StructuredLogMessage.Component.COMMAND, StructuredLogMessage.Level.DEBUG, "Command failed", this.getClusterId(), commandEventException, entries), builder.toString());
        }
        if (this.eventRequired()) {
            ProtocolHelper.sendCommandFailedEvent(this.message, this.commandName, this.description, elapsedTimeNanos, commandEventException, this.commandListener, this.requestContext, this.operationContext);
        }
    }

    @Override
    public void sendSucceededEvent(ResponseBuffers responseBuffers) {
        this.sendSucceededEvent((BsonDocument)responseBuffers.getResponseDocument(this.message.getId(), new RawBsonDocumentCodec()));
    }

    @Override
    public void sendSucceededEventForOneWayCommand() {
        this.sendSucceededEvent(new BsonDocument("ok", (BsonValue)new BsonInt32(1)));
    }

    private void sendSucceededEvent(BsonDocument reply) {
        long elapsedTimeNanos = System.nanoTime() - this.startTimeNanos;
        if (this.loggingRequired()) {
            ArrayList<StructuredLogMessage.Entry> entries = new ArrayList<StructuredLogMessage.Entry>();
            StringBuilder builder = new StringBuilder("Command \"%s\" succeeded in %.2f ms");
            entries.add(new StructuredLogMessage.Entry("commandName", this.commandName));
            entries.add(new StructuredLogMessage.Entry("durationMS", (double)elapsedTimeNanos / 1000000.0));
            this.appendCommonLogFragment(entries, builder);
            builder.append(" Command reply: %s");
            BsonDocument responseDocumentForEvent = this.redactionRequired ? new BsonDocument() : reply;
            String replyString = this.redactionRequired ? "{}" : this.getTruncatedJsonCommand(responseDocumentForEvent);
            entries.add(new StructuredLogMessage.Entry("reply", replyString));
            this.logger.log(new StructuredLogMessage(StructuredLogMessage.Component.COMMAND, StructuredLogMessage.Level.DEBUG, "Command succeeded", this.getClusterId(), entries), builder.toString());
        }
        if (this.eventRequired()) {
            BsonDocument responseDocumentForEvent = this.redactionRequired ? new BsonDocument() : reply;
            ProtocolHelper.sendCommandSucceededEvent(this.message, this.commandName, responseDocumentForEvent, this.description, elapsedTimeNanos, this.commandListener, this.requestContext, this.operationContext);
        }
    }

    private boolean loggingRequired() {
        return this.logger.isRequired(StructuredLogMessage.Level.DEBUG, this.getClusterId());
    }

    private ClusterId getClusterId() {
        return this.description.getConnectionId().getServerId().getClusterId();
    }

    private boolean eventRequired() {
        return this.commandListener != null;
    }

    private void appendCommonLogFragment(List<StructuredLogMessage.Entry> entries, StringBuilder builder) {
        builder.append(" using a connection with driver-generated ID %d");
        entries.add(new StructuredLogMessage.Entry("driverConnectionId", this.description.getConnectionId().getLocalValue()));
        Integer connectionServerValue = this.description.getConnectionId().getServerValue();
        if (connectionServerValue != null) {
            builder.append(" and server-generated ID %d");
            entries.add(new StructuredLogMessage.Entry("serverConnectionId", connectionServerValue));
        }
        builder.append(" to %s:%s");
        entries.add(new StructuredLogMessage.Entry("serverHost", this.description.getServerAddress().getHost()));
        entries.add(new StructuredLogMessage.Entry("serverPort", this.description.getServerAddress().getPort()));
        ObjectId descriptionServiceId = this.description.getServiceId();
        if (descriptionServiceId != null) {
            builder.append(" with service ID %s");
            entries.add(new StructuredLogMessage.Entry("serviceId", descriptionServiceId));
        }
        builder.append(". The request ID is %s and the operation ID is %s.");
        entries.add(new StructuredLogMessage.Entry("requestId", this.message.getId()));
        entries.add(new StructuredLogMessage.Entry("operationId", this.operationContext.getId()));
    }

    private String getTruncatedJsonCommand(BsonDocument commandDocument) {
        StringWriter writer = new StringWriter();
        try (BsonReader bsonReader = commandDocument.asBsonReader();){
            JsonWriter jsonWriter = new JsonWriter((Writer)writer, JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).maxLength(this.loggerSettings.getMaxDocumentLength()).build());
            jsonWriter.pipe(bsonReader);
            if (jsonWriter.isTruncated()) {
                writer.append(" ...");
            }
            String string = writer.toString();
            return string;
        }
    }
}

