/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.ClientEncryptionSettings;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.crypt.capi.MongoCryptOptions;
import com.mongodb.crypt.capi.MongoCrypts;
import com.mongodb.internal.async.client.AsyncMongoClient;
import com.mongodb.internal.async.client.AsyncMongoClients;
import com.mongodb.internal.async.client.CollectionInfoRetriever;
import com.mongodb.internal.async.client.CommandMarker;
import com.mongodb.internal.async.client.Crypt;
import com.mongodb.internal.async.client.KeyManagementService;
import com.mongodb.internal.async.client.KeyRetriever;
import com.mongodb.internal.capi.MongoCryptOptionsHelper;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;

public final class Crypts {
    public static Crypt createCrypt(AsyncMongoClient client, AutoEncryptionSettings options) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)MongoCryptOptionsHelper.createMongoCryptOptions(options.getKmsProviders(), options.getSchemaMap())), new CollectionInfoRetriever(client), new CommandMarker(options.isBypassAutoEncryption(), options.getExtraOptions()), Crypts.createKeyRetriever(client, options.getKeyVaultMongoClientSettings(), options.getKeyVaultNamespace()), Crypts.createKeyManagementService(), options.isBypassAutoEncryption());
    }

    public static Crypt create(AsyncMongoClient keyVaultClient, ClientEncryptionSettings options) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)MongoCryptOptionsHelper.createMongoCryptOptions(options.getKmsProviders(), null)), Crypts.createKeyRetriever(keyVaultClient, false, options.getKeyVaultNamespace()), Crypts.createKeyManagementService());
    }

    private static KeyRetriever createKeyRetriever(AsyncMongoClient defaultKeyVaultClient, MongoClientSettings keyVaultMongoClientSettings, String keyVaultNamespaceString) {
        boolean keyRetrieverOwnsClient;
        AsyncMongoClient keyVaultClient;
        if (keyVaultMongoClientSettings != null) {
            keyVaultClient = AsyncMongoClients.create(keyVaultMongoClientSettings);
            keyRetrieverOwnsClient = true;
        } else {
            keyVaultClient = defaultKeyVaultClient;
            keyRetrieverOwnsClient = false;
        }
        return Crypts.createKeyRetriever(keyVaultClient, keyRetrieverOwnsClient, keyVaultNamespaceString);
    }

    private static KeyRetriever createKeyRetriever(AsyncMongoClient keyVaultClient, boolean keyRetrieverOwnsClient, String keyVaultNamespaceString) {
        return new KeyRetriever(keyVaultClient, keyRetrieverOwnsClient, new MongoNamespace(keyVaultNamespaceString));
    }

    private static KeyManagementService createKeyManagementService() {
        return new KeyManagementService(Crypts.getSslContext(), 443, 10000);
    }

    private static SSLContext getSslContext() {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoClientException("Unable to create default SSLContext", e);
        }
        return sslContext;
    }

    private Crypts() {
    }
}

