/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.Block;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoTimeoutException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncMongoClient;
import com.mongodb.internal.async.client.AsyncMongoClients;
import com.mongodb.internal.capi.MongoCryptOptionsHelper;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.RawBsonDocument;
import org.bson.conversions.Bson;

class CommandMarker
implements Closeable {
    private AsyncMongoClient client;
    private final ProcessBuilder processBuilder;

    CommandMarker(boolean isBypassAutoEncryption, Map<String, Object> options) {
        if (isBypassAutoEncryption) {
            this.processBuilder = null;
            this.client = null;
        } else {
            if (!options.containsKey("mongocryptdBypassSpawn") || !((Boolean)options.get("mongocryptdBypassSpawn")).booleanValue()) {
                this.processBuilder = new ProcessBuilder(MongoCryptOptionsHelper.createMongocryptdSpawnArgs(options));
                this.startProcess();
            } else {
                this.processBuilder = null;
            }
            String connectionString = options.containsKey("mongocryptdURI") ? (String)options.get("mongocryptdURI") : "mongodb://localhost:27020";
            this.client = AsyncMongoClients.create(MongoClientSettings.builder().applyConnectionString(new ConnectionString(connectionString)).applyToClusterSettings(new Block<ClusterSettings.Builder>(){

                @Override
                public void apply(ClusterSettings.Builder builder) {
                    builder.serverSelectionTimeout(1L, TimeUnit.SECONDS);
                }
            }).build());
        }
    }

    void mark(final String databaseName, final RawBsonDocument command, final SingleResultCallback<RawBsonDocument> callback) {
        if (this.client != null) {
            final SingleResultCallback<RawBsonDocument> wrappedCallback = new SingleResultCallback<RawBsonDocument>(){

                @Override
                public void onResult(RawBsonDocument result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, new MongoClientException("Exception in encryption library: " + t.getMessage(), t));
                    } else {
                        callback.onResult(result, null);
                    }
                }
            };
            this.runCommand(databaseName, command, new SingleResultCallback<RawBsonDocument>(){

                @Override
                public void onResult(RawBsonDocument result, Throwable t) {
                    if (t == null) {
                        wrappedCallback.onResult(result, null);
                    } else if (t instanceof MongoTimeoutException && CommandMarker.this.processBuilder != null) {
                        CommandMarker.this.startProcessAndContinue(new SingleResultCallback<Void>(){

                            @Override
                            public void onResult(Void result, Throwable t) {
                                if (t != null) {
                                    callback.onResult(null, t);
                                } else {
                                    CommandMarker.this.runCommand(databaseName, command, wrappedCallback);
                                }
                            }
                        });
                    } else {
                        wrappedCallback.onResult(null, t);
                    }
                }
            });
        } else {
            callback.onResult(command, null);
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private void runCommand(String databaseName, RawBsonDocument command, SingleResultCallback<RawBsonDocument> callback) {
        this.client.getDatabase(databaseName).withReadConcern(ReadConcern.DEFAULT).withReadPreference(ReadPreference.primary()).runCommand((Bson)command, RawBsonDocument.class, callback);
    }

    private void startProcessAndContinue(SingleResultCallback<Void> callback) {
        try {
            this.startProcess();
            callback.onResult(null, null);
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    private void startProcess() {
        try {
            this.processBuilder.start();
        }
        catch (Throwable t) {
            throw new MongoClientException("Exception starting mongocryptd process. Is `mongocryptd` on the system path?", t);
        }
    }
}

