/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.CursorType;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncClientSession;
import com.mongodb.internal.async.client.AsyncFindIterable;
import com.mongodb.internal.async.client.AsyncMongoIterableImpl;
import com.mongodb.internal.async.client.OperationExecutor;
import com.mongodb.internal.client.model.FindOptions;
import com.mongodb.internal.operation.AsyncOperations;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class AsyncFindIterableImpl<TDocument, TResult>
extends AsyncMongoIterableImpl<TResult>
implements AsyncFindIterable<TResult> {
    private final AsyncOperations<TDocument> operations;
    private final Class<TResult> resultClass;
    private final FindOptions findOptions;
    private Bson filter;

    AsyncFindIterableImpl(@Nullable AsyncClientSession clientSession, MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, OperationExecutor executor, Bson filter, boolean retryReads) {
        super(clientSession, executor, readConcern, readPreference, retryReads);
        this.operations = new AsyncOperations<TDocument>(namespace, documentClass, readPreference, codecRegistry, retryReads);
        this.resultClass = Assertions.notNull("resultClass", resultClass);
        this.filter = Assertions.notNull("filter", filter);
        this.findOptions = new FindOptions();
    }

    @Override
    public AsyncFindIterable<TResult> filter(@Nullable Bson filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public AsyncFindIterable<TResult> limit(int limit) {
        this.findOptions.limit(limit);
        return this;
    }

    @Override
    public AsyncFindIterable<TResult> skip(int skip) {
        this.findOptions.skip(skip);
        return this;
    }

    @Override
    public AsyncFindIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.findOptions.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public AsyncFindIterable<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.findOptions.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public AsyncFindIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        this.findOptions.batchSize(batchSize);
        return this;
    }

    @Override
    public AsyncFindIterable<TResult> collation(@Nullable Collation collation) {
        this.findOptions.collation(collation);
        return this;
    }

    @Override
    public AsyncFindIterable<TResult> projection(@Nullable Bson projection) {
        this.findOptions.projection(projection);
        return this;
    }

    @Override
    public AsyncFindIterable<TResult> sort(@Nullable Bson sort) {
        this.findOptions.sort(sort);
        return this;
    }

    @Override
    public AsyncFindIterable<TResult> noCursorTimeout(boolean noCursorTimeout) {
        this.findOptions.noCursorTimeout(noCursorTimeout);
        return this;
    }

    @Override
    public AsyncFindIterable<TResult> oplogReplay(boolean oplogReplay) {
        this.findOptions.oplogReplay(oplogReplay);
        return this;
    }

    @Override
    public AsyncFindIterable<TResult> partial(boolean partial) {
        this.findOptions.partial(partial);
        return this;
    }

    @Override
    public AsyncFindIterable<TResult> cursorType(CursorType cursorType) {
        this.findOptions.cursorType(cursorType);
        return this;
    }

    @Override
    public AsyncFindIterable<TResult> comment(@Nullable String comment) {
        this.findOptions.comment(comment);
        return this;
    }

    @Override
    public AsyncFindIterable<TResult> hint(@Nullable Bson hint) {
        this.findOptions.hint(hint);
        return this;
    }

    @Override
    public AsyncFindIterable<TResult> hintString(@Nullable String hint) {
        this.findOptions.hintString(hint);
        return this;
    }

    @Override
    public AsyncFindIterable<TResult> max(@Nullable Bson max) {
        this.findOptions.max(max);
        return this;
    }

    @Override
    public AsyncFindIterable<TResult> min(@Nullable Bson min) {
        this.findOptions.min(min);
        return this;
    }

    @Override
    public AsyncFindIterable<TResult> returnKey(boolean returnKey) {
        this.findOptions.returnKey(returnKey);
        return this;
    }

    @Override
    public AsyncFindIterable<TResult> showRecordId(boolean showRecordId) {
        this.findOptions.showRecordId(showRecordId);
        return this;
    }

    @Override
    public void first(final SingleResultCallback<TResult> callback) {
        Assertions.notNull("callback", callback);
        this.getExecutor().execute(this.operations.findFirst(this.filter, this.resultClass, this.findOptions), this.getReadPreference(), this.getReadConcern(), this.getClientSession(), new SingleResultCallback<AsyncBatchCursor<TResult>>(){

            @Override
            public void onResult(final AsyncBatchCursor<TResult> batchCursor, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    batchCursor.next(new SingleResultCallback<List<TResult>>(){

                        @Override
                        public void onResult(List<TResult> result, Throwable t) {
                            batchCursor.close();
                            if (t != null) {
                                callback.onResult(null, t);
                            } else if (result == null || result.isEmpty()) {
                                callback.onResult(null, null);
                            } else {
                                callback.onResult(result.get(0), null);
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    AsyncReadOperation<AsyncBatchCursor<TResult>> asAsyncReadOperation() {
        return this.createFindOperation();
    }

    private AsyncReadOperation<AsyncBatchCursor<TResult>> createFindOperation() {
        return this.operations.find(this.filter, this.resultClass, this.findOptions);
    }
}

