/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoWriteConcernException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcernResult;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.operation.BsonDocumentWrapperHelper;
import com.mongodb.operation.CommandOperationHelper;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonNumber;

final class FindAndModifyHelper {
    static <T> CommandOperationHelper.CommandTransformer<BsonDocument, T> transformer() {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, T>(){

            @Override
            public T apply(BsonDocument result, ServerAddress serverAddress) {
                if (result.containsKey((Object)"writeConcernError")) {
                    throw new MongoWriteConcernException(FindAndModifyHelper.createWriteConcernError(result.getDocument((Object)"writeConcernError")), FindAndModifyHelper.createWriteConcernResult(result.getDocument((Object)"lastErrorObject", new BsonDocument())), serverAddress);
                }
                if (!result.isDocument((Object)"value")) {
                    return null;
                }
                return BsonDocumentWrapperHelper.toDocument(result.getDocument((Object)"value", null));
            }
        };
    }

    private static WriteConcernError createWriteConcernError(BsonDocument writeConcernErrorDocument) {
        return new WriteConcernError(writeConcernErrorDocument.getNumber((Object)"code").intValue(), writeConcernErrorDocument.getString((Object)"errmsg").getValue(), writeConcernErrorDocument.getDocument((Object)"errInfo", new BsonDocument()));
    }

    private static WriteConcernResult createWriteConcernResult(BsonDocument result) {
        BsonBoolean updatedExisting = result.getBoolean((Object)"updatedExisting", BsonBoolean.FALSE);
        return WriteConcernResult.acknowledged(result.getNumber((Object)"n", (BsonNumber)new BsonInt32(0)).intValue(), updatedExisting.getValue(), result.get((Object)"upserted"));
    }

    private FindAndModifyHelper() {
    }
}

