/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncConnectionSource;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.ConnectionSource;
import com.mongodb.binding.ReadBinding;
import com.mongodb.client.model.Collation;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Connection;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.QueryResult;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.operation.AggregateExplainOperation;
import com.mongodb.operation.AsyncQueryBatchCursor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.BsonDocumentWrapperHelper;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.CommandResultDocumentCodec;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.QueryBatchCursor;
import com.mongodb.operation.ReadOperation;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.Decoder;

public class AggregateOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final String RESULT = "result";
    private static final String CURSOR = "cursor";
    private static final String FIRST_BATCH = "firstBatch";
    private static final List<String> FIELD_NAMES_WITH_RESULT = Arrays.asList("result", "firstBatch");
    private final MongoNamespace namespace;
    private final List<BsonDocument> pipeline;
    private final Decoder<T> decoder;
    private Boolean allowDiskUse;
    private Integer batchSize;
    private Collation collation;
    private long maxAwaitTimeMS;
    private long maxTimeMS;
    private Boolean useCursor;
    private ReadConcern readConcern = ReadConcern.DEFAULT;

    public AggregateOperation(MongoNamespace namespace, List<BsonDocument> pipeline, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.pipeline = Assertions.notNull("pipeline", pipeline);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public List<BsonDocument> getPipeline() {
        return this.pipeline;
    }

    public Boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    public AggregateOperation<T> allowDiskUse(Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public AggregateOperation<T> batchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public long getMaxAwaitTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS);
    }

    public AggregateOperation<T> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxAwaitTime >= 0", maxAwaitTime >= 0L);
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public AggregateOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxTime >= 0", maxTime >= 0L);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Deprecated
    public Boolean getUseCursor() {
        return this.useCursor;
    }

    @Deprecated
    public AggregateOperation<T> useCursor(Boolean useCursor) {
        this.useCursor = useCursor;
        return this;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public AggregateOperation<T> readConcern(ReadConcern readConcern) {
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public AggregateOperation<T> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public BatchCursor<T> execute(final ReadBinding binding) {
        return (BatchCursor)OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnectionAndSource<BatchCursor<T>>(){

            @Override
            public BatchCursor<T> call(ConnectionSource source, Connection connection) {
                OperationHelper.validateReadConcernAndCollation(connection, AggregateOperation.this.readConcern, AggregateOperation.this.collation);
                return (BatchCursor)CommandOperationHelper.executeWrappedCommandProtocol(binding, AggregateOperation.this.namespace.getDatabaseName(), AggregateOperation.this.getCommand(connection.getDescription()), CommandResultDocumentCodec.create(AggregateOperation.this.decoder, FIELD_NAMES_WITH_RESULT), connection, AggregateOperation.this.transformer(source, connection));
            }
        });
    }

    @Override
    public void executeAsync(final AsyncReadBinding binding, final SingleResultCallback<AsyncBatchCursor<T>> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnectionAndSource(){

            @Override
            public void call(AsyncConnectionSource source, AsyncConnection connection, Throwable t) {
                SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(errHandlingCallback, source, connection);
                    OperationHelper.validateReadConcernAndCollation(source, connection, AggregateOperation.this.readConcern, AggregateOperation.this.collation, new OperationHelper.AsyncCallableWithConnectionAndSource(){

                        @Override
                        public void call(AsyncConnectionSource source, AsyncConnection connection, Throwable t) {
                            if (t != null) {
                                wrappedCallback.onResult(null, t);
                            } else {
                                CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, AggregateOperation.this.namespace.getDatabaseName(), AggregateOperation.this.getCommand(connection.getDescription()), CommandResultDocumentCodec.create(AggregateOperation.this.decoder, FIELD_NAMES_WITH_RESULT), connection, AggregateOperation.this.asyncTransformer(source, connection), wrappedCallback);
                            }
                        }
                    });
                }
            }
        });
    }

    public ReadOperation<BsonDocument> asExplainableOperation(ExplainVerbosity explainVerbosity) {
        return new AggregateExplainOperation(this.namespace, this.pipeline).allowDiskUse(this.allowDiskUse).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public AsyncReadOperation<BsonDocument> asExplainableOperationAsync(ExplainVerbosity explainVerbosity) {
        return new AggregateExplainOperation(this.namespace, this.pipeline).allowDiskUse(this.allowDiskUse).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    private boolean isInline(ConnectionDescription description) {
        return !OperationHelper.serverIsAtLeastVersionThreeDotSix(description) && this.useCursor != null && this.useCursor == false;
    }

    private BsonDocument getCommand(ConnectionDescription description) {
        BsonDocument commandDocument = new BsonDocument("aggregate", (BsonValue)new BsonString(this.namespace.getCollectionName()));
        commandDocument.put("pipeline", (BsonValue)new BsonArray(this.pipeline));
        if (this.maxTimeMS > 0L) {
            commandDocument.put("maxTimeMS", (BsonValue)new BsonInt64(this.maxTimeMS));
        }
        if (!this.isInline(description)) {
            BsonDocument cursor = new BsonDocument();
            if (this.batchSize != null) {
                cursor.put("batchSize", (BsonValue)new BsonInt32(this.batchSize.intValue()));
            }
            commandDocument.put(CURSOR, (BsonValue)cursor);
        }
        if (this.allowDiskUse != null) {
            commandDocument.put("allowDiskUse", (BsonValue)BsonBoolean.valueOf((boolean)this.allowDiskUse));
        }
        if (!this.readConcern.isServerDefault()) {
            commandDocument.put("readConcern", (BsonValue)this.readConcern.asDocument());
        }
        if (this.collation != null) {
            commandDocument.put("collation", (BsonValue)this.collation.asDocument());
        }
        return commandDocument;
    }

    private QueryResult<T> createQueryResult(BsonDocument result, ConnectionDescription description) {
        if (!this.isInline(description) || result.containsKey((Object)CURSOR)) {
            return OperationHelper.cursorDocumentToQueryResult(result.getDocument((Object)CURSOR), description.getServerAddress());
        }
        return new QueryResult(this.namespace, BsonDocumentWrapperHelper.toList(result, RESULT), 0L, description.getServerAddress());
    }

    private CommandOperationHelper.CommandTransformer<BsonDocument, BatchCursor<T>> transformer(final ConnectionSource source, final Connection connection) {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, BatchCursor<T>>(){

            @Override
            public BatchCursor<T> apply(BsonDocument result, ServerAddress serverAddress) {
                QueryResult queryResult = AggregateOperation.this.createQueryResult(result, connection.getDescription());
                return new QueryBatchCursor(queryResult, 0, AggregateOperation.this.batchSize != null ? AggregateOperation.this.batchSize : 0, AggregateOperation.this.maxAwaitTimeMS, AggregateOperation.this.decoder, source, connection);
            }
        };
    }

    private CommandOperationHelper.CommandTransformer<BsonDocument, AsyncBatchCursor<T>> asyncTransformer(final AsyncConnectionSource source, final AsyncConnection connection) {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, AsyncBatchCursor<T>>(){

            @Override
            public AsyncBatchCursor<T> apply(BsonDocument result, ServerAddress serverAddress) {
                QueryResult queryResult = AggregateOperation.this.createQueryResult(result, connection.getDescription());
                return new AsyncQueryBatchCursor(queryResult, 0, AggregateOperation.this.batchSize != null ? AggregateOperation.this.batchSize : 0, AggregateOperation.this.maxAwaitTimeMS, AggregateOperation.this.decoder, source, connection);
            }
        };
    }

    public String toString() {
        return "AggregateOperation{namespace=" + this.namespace + ", pipeline=" + this.pipeline + ", decoder=" + this.decoder + ", allowDiskUse=" + this.allowDiskUse + ", batchSize=" + this.batchSize + ", collation=" + this.collation + ", maxAwaitTimeMS=" + this.maxAwaitTimeMS + ", maxTimeMS=" + this.maxTimeMS + ", useCursor=" + this.useCursor + ", readConcern=" + this.readConcern + "}";
    }
}

