/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.connection.CommandMessage;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.RequestMessage;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import java.util.ArrayList;
import org.bson.BsonDocument;
import org.bson.BsonElement;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.FieldNameValidator;
import org.bson.io.BsonOutput;

class SimpleCommandMessage
extends CommandMessage {
    private final ReadPreference readPreference;
    private final BsonDocument command;
    private final FieldNameValidator validator;

    SimpleCommandMessage(String collectionName, BsonDocument command, ReadPreference readPreference, MessageSettings settings) {
        this(collectionName, command, readPreference, new NoOpFieldNameValidator(), settings);
    }

    SimpleCommandMessage(String collectionName, BsonDocument command, ReadPreference readPreference, FieldNameValidator validator, MessageSettings settings) {
        super(collectionName, SimpleCommandMessage.getOpCode(settings), settings);
        this.readPreference = readPreference;
        this.command = command;
        this.validator = validator;
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput bsonOutput, int messageStartPosition) {
        BsonDocument commandToEncode;
        ArrayList<BsonElement> extraElements = null;
        if (this.useOpMsg()) {
            bsonOutput.writeInt32(0);
            bsonOutput.writeByte(0);
            extraElements = new ArrayList<BsonElement>();
            extraElements.add(new BsonElement("$db", (BsonValue)new BsonString(new MongoNamespace(this.getCollectionName()).getDatabaseName())));
            if (!this.isDefaultReadPreference()) {
                extraElements.add(new BsonElement("$readPreference", (BsonValue)this.readPreference.toDocument()));
            }
            commandToEncode = this.command;
        } else {
            bsonOutput.writeInt32(this.readPreference.isSlaveOk() ? 4 : 0);
            bsonOutput.writeCString(this.getCollectionName());
            bsonOutput.writeInt32(0);
            bsonOutput.writeInt32(-1);
            commandToEncode = !this.isDefaultReadPreference() ? new BsonDocument("$query", (BsonValue)this.command).append("$readPreference", (BsonValue)this.readPreference.toDocument()) : this.command;
        }
        int firstDocumentPosition = bsonOutput.getPosition();
        this.addDocument(commandToEncode, bsonOutput, this.validator, extraElements);
        return new RequestMessage.EncodingMetadata(null, firstDocumentPosition);
    }

    private boolean isDefaultReadPreference() {
        return this.readPreference.equals(ReadPreference.primary());
    }
}

