/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.ServerAddress;
import com.mongodb.Tag;
import com.mongodb.TagSet;
import com.mongodb.connection.CommandHelper;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ConnectionId;
import com.mongodb.connection.ServerConnectionState;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.connection.ServerVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.types.ObjectId;

final class DescriptionHelper {
    static ConnectionDescription createConnectionDescription(ConnectionId connectionId, BsonDocument isMasterResult, BsonDocument buildInfoResult) {
        return new ConnectionDescription(connectionId, DescriptionHelper.getVersion(buildInfoResult), DescriptionHelper.getServerType(isMasterResult), DescriptionHelper.getMaxWriteBatchSize(isMasterResult), DescriptionHelper.getMaxBsonObjectSize(isMasterResult), DescriptionHelper.getMaxMessageSizeBytes(isMasterResult), DescriptionHelper.getCompressors(isMasterResult));
    }

    static ServerDescription createServerDescription(ServerAddress serverAddress, BsonDocument isMasterResult, ServerVersion serverVersion, long roundTripTime) {
        return ServerDescription.builder().state(ServerConnectionState.CONNECTED).version(serverVersion).address(serverAddress).type(DescriptionHelper.getServerType(isMasterResult)).canonicalAddress(isMasterResult.containsKey((Object)"me") ? isMasterResult.getString((Object)"me").getValue() : null).hosts(DescriptionHelper.listToSet(isMasterResult.getArray((Object)"hosts", new BsonArray()))).passives(DescriptionHelper.listToSet(isMasterResult.getArray((Object)"passives", new BsonArray()))).arbiters(DescriptionHelper.listToSet(isMasterResult.getArray((Object)"arbiters", new BsonArray()))).primary(DescriptionHelper.getString(isMasterResult, "primary")).maxDocumentSize(DescriptionHelper.getMaxBsonObjectSize(isMasterResult)).tagSet(DescriptionHelper.getTagSetFromDocument(isMasterResult.getDocument((Object)"tags", new BsonDocument()))).setName(DescriptionHelper.getString(isMasterResult, "setName")).minWireVersion(isMasterResult.getInt32((Object)"minWireVersion", new BsonInt32(ServerDescription.getDefaultMinWireVersion())).getValue()).maxWireVersion(isMasterResult.getInt32((Object)"maxWireVersion", new BsonInt32(ServerDescription.getDefaultMaxWireVersion())).getValue()).electionId(DescriptionHelper.getElectionId(isMasterResult)).setVersion(DescriptionHelper.getSetVersion(isMasterResult)).lastWriteDate(DescriptionHelper.getLastWriteDate(isMasterResult)).roundTripTime(roundTripTime, TimeUnit.NANOSECONDS).ok(CommandHelper.isCommandOk(isMasterResult)).build();
    }

    private static Date getLastWriteDate(BsonDocument isMasterResult) {
        if (!isMasterResult.containsKey((Object)"lastWrite")) {
            return null;
        }
        return new Date(isMasterResult.getDocument((Object)"lastWrite").getDateTime((Object)"lastWriteDate").getValue());
    }

    private static ObjectId getElectionId(BsonDocument isMasterResult) {
        return isMasterResult.containsKey((Object)"electionId") ? isMasterResult.getObjectId((Object)"electionId").getValue() : null;
    }

    private static Integer getSetVersion(BsonDocument isMasterResult) {
        return isMasterResult.containsKey((Object)"setVersion") ? Integer.valueOf(isMasterResult.getNumber((Object)"setVersion").intValue()) : null;
    }

    private static int getMaxMessageSizeBytes(BsonDocument isMasterResult) {
        return isMasterResult.getInt32((Object)"maxMessageSizeBytes", new BsonInt32(ConnectionDescription.getDefaultMaxMessageSize())).getValue();
    }

    private static int getMaxBsonObjectSize(BsonDocument isMasterResult) {
        return isMasterResult.getInt32((Object)"maxBsonObjectSize", new BsonInt32(ServerDescription.getDefaultMaxDocumentSize())).getValue();
    }

    private static int getMaxWriteBatchSize(BsonDocument isMasterResult) {
        return isMasterResult.getInt32((Object)"maxWriteBatchSize", new BsonInt32(ConnectionDescription.getDefaultMaxWriteBatchSize())).getValue();
    }

    private static String getString(BsonDocument response, String key) {
        if (response.containsKey((Object)key)) {
            return response.getString((Object)key).getValue();
        }
        return null;
    }

    static ServerVersion getVersion(BsonDocument buildInfoResult) {
        List versionArray = buildInfoResult.getArray((Object)"versionArray").subList(0, 3);
        return new ServerVersion(Arrays.asList(((BsonValue)versionArray.get(0)).asInt32().getValue(), ((BsonValue)versionArray.get(1)).asInt32().getValue(), ((BsonValue)versionArray.get(2)).asInt32().getValue()));
    }

    private static Set<String> listToSet(BsonArray array) {
        if (array == null || array.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (BsonValue value : array) {
            set.add(value.asString().getValue());
        }
        return set;
    }

    private static ServerType getServerType(BsonDocument isMasterResult) {
        if (!CommandHelper.isCommandOk(isMasterResult)) {
            return ServerType.UNKNOWN;
        }
        if (DescriptionHelper.isReplicaSetMember(isMasterResult)) {
            if (isMasterResult.getBoolean((Object)"hidden", BsonBoolean.FALSE).getValue()) {
                return ServerType.REPLICA_SET_OTHER;
            }
            if (isMasterResult.getBoolean((Object)"ismaster", BsonBoolean.FALSE).getValue()) {
                return ServerType.REPLICA_SET_PRIMARY;
            }
            if (isMasterResult.getBoolean((Object)"secondary", BsonBoolean.FALSE).getValue()) {
                return ServerType.REPLICA_SET_SECONDARY;
            }
            if (isMasterResult.getBoolean((Object)"arbiterOnly", BsonBoolean.FALSE).getValue()) {
                return ServerType.REPLICA_SET_ARBITER;
            }
            if (isMasterResult.containsKey((Object)"setName") && isMasterResult.containsKey((Object)"hosts")) {
                return ServerType.REPLICA_SET_OTHER;
            }
            return ServerType.REPLICA_SET_GHOST;
        }
        if (isMasterResult.containsKey((Object)"msg") && isMasterResult.get((Object)"msg").equals(new BsonString("isdbgrid"))) {
            return ServerType.SHARD_ROUTER;
        }
        return ServerType.STANDALONE;
    }

    private static boolean isReplicaSetMember(BsonDocument isMasterResult) {
        return isMasterResult.containsKey((Object)"setName") || isMasterResult.getBoolean((Object)"isreplicaset", BsonBoolean.FALSE).getValue();
    }

    private static TagSet getTagSetFromDocument(BsonDocument tagsDocuments) {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        for (Map.Entry curEntry : tagsDocuments.entrySet()) {
            tagList.add(new Tag((String)curEntry.getKey(), ((BsonValue)curEntry.getValue()).asString().getValue()));
        }
        return new TagSet(tagList);
    }

    private static List<String> getCompressors(BsonDocument isMasterResult) {
        ArrayList<String> compressorList = new ArrayList<String>();
        for (BsonValue compressor : isMasterResult.getArray((Object)"compression", new BsonArray())) {
            compressorList.add(compressor.asString().getValue());
        }
        return compressorList;
    }

    private DescriptionHelper() {
    }
}

