/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Connection;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.WriteOperation;
import java.util.Arrays;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;

public class DropUserOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final String databaseName;
    private final String userName;

    public DropUserOperation(String databaseName, String userName) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.userName = Assertions.notNull("userName", userName);
    }

    @Override
    public Void execute(WriteBinding binding) {
        return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<Void>(){

            @Override
            public Void call(Connection connection) {
                if (OperationHelper.serverIsAtLeastVersionTwoDotSix(connection.getDescription())) {
                    CommandOperationHelper.executeWrappedCommandProtocol(DropUserOperation.this.databaseName, DropUserOperation.this.getCommand(), connection);
                } else {
                    connection.delete(DropUserOperation.this.getNamespace(), true, WriteConcern.ACKNOWLEDGED, Arrays.asList(DropUserOperation.this.getDeleteRequest()));
                }
                return null;
            }
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, final SingleResultCallback<Void> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                if (t != null) {
                    ErrorHandlingResultCallback.errorHandlingCallback(callback).onResult(null, t);
                } else {
                    final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(ErrorHandlingResultCallback.errorHandlingCallback(callback), connection);
                    if (OperationHelper.serverIsAtLeastVersionTwoDotSix(connection.getDescription())) {
                        CommandOperationHelper.executeWrappedCommandProtocolAsync(DropUserOperation.this.databaseName, DropUserOperation.this.getCommand(), connection, new OperationHelper.VoidTransformer<BsonDocument>(), wrappedCallback);
                    } else {
                        connection.deleteAsync(DropUserOperation.this.getNamespace(), true, WriteConcern.ACKNOWLEDGED, Arrays.asList(DropUserOperation.this.getDeleteRequest()), new SingleResultCallback<WriteConcernResult>(){

                            @Override
                            public void onResult(WriteConcernResult result, Throwable t) {
                                wrappedCallback.onResult(null, t);
                            }
                        });
                    }
                }
            }
        });
    }

    private MongoNamespace getNamespace() {
        return new MongoNamespace(this.databaseName, "system.users");
    }

    private DeleteRequest getDeleteRequest() {
        return new DeleteRequest(new BsonDocument("user", (BsonValue)new BsonString(this.userName)));
    }

    private BsonDocument getCommand() {
        return new BsonDocument("dropUser", (BsonValue)new BsonString(this.userName));
    }
}

