/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.ByteBufferBsonOutput;
import com.mongodb.connection.CommandMessage;
import com.mongodb.connection.CommandResultCallback;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.Protocol;
import com.mongodb.connection.ProtocolHelper;
import com.mongodb.connection.ReplyMessage;
import com.mongodb.connection.ResponseBuffers;
import com.mongodb.connection.SendMessageCallback;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonReader;
import org.bson.FieldNameValidator;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.io.BsonOutput;

class CommandProtocol<T>
implements Protocol<T> {
    public static final Logger LOGGER = Loggers.getLogger("protocol.command");
    private final MongoNamespace namespace;
    private final BsonDocument command;
    private final Decoder<T> commandResultDecoder;
    private final FieldNameValidator fieldNameValidator;
    private boolean slaveOk;

    public CommandProtocol(String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<T> commandResultDecoder) {
        Assertions.notNull("database", database);
        this.namespace = new MongoNamespace(database, "$cmd");
        this.command = Assertions.notNull("command", command);
        this.commandResultDecoder = Assertions.notNull("commandResultDecoder", commandResultDecoder);
        this.fieldNameValidator = Assertions.notNull("fieldNameValidator", fieldNameValidator);
    }

    public boolean isSlaveOk() {
        return this.slaveOk;
    }

    public CommandProtocol<T> slaveOk(boolean slaveOk) {
        this.slaveOk = slaveOk;
        return this;
    }

    @Override
    public T execute(InternalConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Sending command {%s : %s} to database %s on connection [%s] to server %s", this.command.keySet().iterator().next(), this.command.values().iterator().next(), this.namespace.getDatabaseName(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
        }
        T retval = this.receiveMessage(connection, this.sendMessage(connection).getId());
        LOGGER.debug("Command execution completed");
        return retval;
    }

    @Override
    public void executeAsync(InternalConnection connection, SingleResultCallback<T> callback) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Asynchronously sending command {%s : %s} to database %s on connection [%s] to server %s", this.command.keySet().iterator().next(), this.command.values().iterator().next(), this.namespace.getDatabaseName(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
            }
            ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(connection);
            CommandMessage message = new CommandMessage(this.namespace.getFullName(), this.command, this.slaveOk, this.fieldNameValidator, ProtocolHelper.getMessageSettings(connection.getDescription()));
            ProtocolHelper.encodeMessage(message, (BsonOutput)bsonOutput);
            CommandResultCallback<T> receiveCallback = new CommandResultCallback<T>(callback, this.commandResultDecoder, message.getId(), connection.getDescription().getServerAddress());
            connection.sendMessageAsync(bsonOutput.getByteBuffers(), message.getId(), new SendMessageCallback<T>(connection, bsonOutput, message.getId(), callback, receiveCallback));
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandMessage sendMessage(InternalConnection connection) {
        ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(connection);
        try {
            CommandMessage message = new CommandMessage(this.namespace.getFullName(), this.command, this.slaveOk, this.fieldNameValidator, ProtocolHelper.getMessageSettings(connection.getDescription()));
            message.encode((BsonOutput)bsonOutput);
            connection.sendMessage(bsonOutput.getByteBuffers(), message.getId());
            CommandMessage commandMessage = message;
            return commandMessage;
        }
        finally {
            bsonOutput.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T receiveMessage(InternalConnection connection, int messageId) {
        ResponseBuffers responseBuffers = connection.receiveMessage(messageId);
        try {
            ReplyMessage<BsonDocument> replyMessage = new ReplyMessage<BsonDocument>(responseBuffers, (Decoder<BsonDocument>)new BsonDocumentCodec(), messageId);
            T t = this.createCommandResult(replyMessage, connection.getDescription().getServerAddress());
            return t;
        }
        finally {
            responseBuffers.close();
        }
    }

    private T createCommandResult(ReplyMessage<BsonDocument> replyMessage, ServerAddress serverAddress) {
        BsonDocument response = replyMessage.getDocuments().get(0);
        if (!ProtocolHelper.isCommandOk(response)) {
            throw ProtocolHelper.getCommandFailureException(response, serverAddress);
        }
        return (T)this.commandResultDecoder.decode((BsonReader)new BsonDocumentReader(response), DecoderContext.builder().build());
    }
}

