/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.ExplainVerbosity;
import com.mongodb.Function;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncConnectionSource;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.ConnectionSource;
import com.mongodb.binding.ReadBinding;
import com.mongodb.connection.Connection;
import com.mongodb.connection.QueryResult;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.operation.AggregateExplainOperation;
import com.mongodb.operation.AsyncQueryBatchCursor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.BsonDocumentWrapperHelper;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.CommandResultDocumentCodec;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.QueryBatchCursor;
import com.mongodb.operation.ReadOperation;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.Decoder;

public class AggregateOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final String RESULT = "result";
    private static final String FIRST_BATCH = "firstBatch";
    private final MongoNamespace namespace;
    private final List<BsonDocument> pipeline;
    private final Decoder<T> decoder;
    private Boolean allowDiskUse;
    private Integer batchSize;
    private long maxTimeMS;
    private Boolean useCursor;

    public AggregateOperation(MongoNamespace namespace, List<BsonDocument> pipeline, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.pipeline = Assertions.notNull("pipeline", pipeline);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public List<BsonDocument> getPipeline() {
        return this.pipeline;
    }

    public Boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    public AggregateOperation<T> allowDiskUse(Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public AggregateOperation<T> batchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public AggregateOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public Boolean getUseCursor() {
        return this.useCursor;
    }

    public AggregateOperation<T> useCursor(Boolean useCursor) {
        this.useCursor = useCursor;
        return this;
    }

    @Override
    public BatchCursor<T> execute(final ReadBinding binding) {
        return (BatchCursor)OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnectionAndSource<BatchCursor<T>>(){

            @Override
            public BatchCursor<T> call(ConnectionSource source, Connection connection) {
                return (BatchCursor)CommandOperationHelper.executeWrappedCommandProtocol(AggregateOperation.this.namespace.getDatabaseName(), AggregateOperation.this.asCommandDocument(connection), CommandResultDocumentCodec.create(AggregateOperation.this.decoder, AggregateOperation.this.getFieldNameWithResults(connection)), connection, binding.getReadPreference(), AggregateOperation.this.transformer(source, connection));
            }
        });
    }

    @Override
    public void executeAsync(final AsyncReadBinding binding, final SingleResultCallback<AsyncBatchCursor<T>> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnectionAndSource(){

            @Override
            public void call(AsyncConnectionSource source, Connection connection, Throwable t) {
                if (t != null) {
                    ErrorHandlingResultCallback.errorHandlingCallback(callback).onResult(null, t);
                } else {
                    CommandOperationHelper.executeWrappedCommandProtocolAsync(AggregateOperation.this.namespace.getDatabaseName(), AggregateOperation.this.asCommandDocument(connection), CommandResultDocumentCodec.create(AggregateOperation.this.decoder, AggregateOperation.this.getFieldNameWithResults(connection)), connection, binding.getReadPreference(), AggregateOperation.this.asyncTransformer(source, connection), OperationHelper.releasingCallback(ErrorHandlingResultCallback.errorHandlingCallback(callback), source, connection));
                }
            }
        });
    }

    public ReadOperation<BsonDocument> asExplainableOperation(ExplainVerbosity explainVerbosity) {
        return new AggregateExplainOperation(this.namespace, this.pipeline).allowDiskUse(this.allowDiskUse).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public AsyncReadOperation<BsonDocument> asExplainableOperationAsync(ExplainVerbosity explainVerbosity) {
        return new AggregateExplainOperation(this.namespace, this.pipeline).allowDiskUse(this.allowDiskUse).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    private boolean isInline(Connection connection) {
        return this.useCursor != null && this.useCursor == false || !OperationHelper.serverIsAtLeastVersionTwoDotSix(connection);
    }

    private BsonDocument asCommandDocument(Connection connection) {
        BsonDocument commandDocument = new BsonDocument("aggregate", (BsonValue)new BsonString(this.namespace.getCollectionName()));
        commandDocument.put("pipeline", (BsonValue)new BsonArray(this.pipeline));
        if (this.maxTimeMS > 0L) {
            commandDocument.put("maxTimeMS", (BsonValue)new BsonInt64(this.maxTimeMS));
        }
        if ((this.useCursor == null || this.useCursor.booleanValue()) && OperationHelper.serverIsAtLeastVersionTwoDotSix(connection)) {
            BsonDocument cursor = new BsonDocument();
            if (this.batchSize != null) {
                cursor.put("batchSize", (BsonValue)new BsonInt32(this.batchSize.intValue()));
            }
            commandDocument.put("cursor", (BsonValue)cursor);
        }
        if (this.allowDiskUse != null) {
            commandDocument.put("allowDiskUse", (BsonValue)BsonBoolean.valueOf((boolean)this.allowDiskUse));
        }
        return commandDocument;
    }

    String getFieldNameWithResults(Connection connection) {
        return (this.useCursor == null || this.useCursor != false) && OperationHelper.serverIsAtLeastVersionTwoDotSix(connection) ? FIRST_BATCH : RESULT;
    }

    private QueryResult<T> createQueryResult(BsonDocument result, Connection connection) {
        if (this.isInline(connection)) {
            return new QueryResult(this.namespace, BsonDocumentWrapperHelper.toList(result, RESULT), 0L, connection.getDescription().getServerAddress());
        }
        return OperationHelper.cursorDocumentToQueryResult(result.getDocument((Object)"cursor"), connection.getDescription().getServerAddress());
    }

    private Function<BsonDocument, BatchCursor<T>> transformer(final ConnectionSource source, final Connection connection) {
        return new Function<BsonDocument, BatchCursor<T>>(){

            @Override
            public BatchCursor<T> apply(BsonDocument result) {
                QueryResult queryResult = AggregateOperation.this.createQueryResult(result, connection);
                return new QueryBatchCursor(queryResult, 0, AggregateOperation.this.batchSize != null ? AggregateOperation.this.batchSize : 0, AggregateOperation.this.decoder, source);
            }
        };
    }

    private Function<BsonDocument, AsyncBatchCursor<T>> asyncTransformer(final AsyncConnectionSource source, final Connection connection) {
        return new Function<BsonDocument, AsyncBatchCursor<T>>(){

            @Override
            public AsyncBatchCursor<T> apply(BsonDocument result) {
                QueryResult queryResult = AggregateOperation.this.createQueryResult(result, connection);
                return new AsyncQueryBatchCursor(queryResult, 0, AggregateOperation.this.batchSize != null ? AggregateOperation.this.batchSize : 0, AggregateOperation.this.decoder, source);
            }
        };
    }
}

