/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.ServerAddress;
import com.mongodb.connection.SocketSettings;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.TimeUnit;

final class SocketStreamHelper {
    static void initialize(Socket socket, ServerAddress address, SocketSettings settings) throws IOException {
        socket.setTcpNoDelay(true);
        socket.setSoTimeout(settings.getReadTimeout(TimeUnit.MILLISECONDS));
        socket.setKeepAlive(settings.isKeepAlive());
        if (settings.getReceiveBufferSize() > 0) {
            socket.setReceiveBufferSize(settings.getReceiveBufferSize());
        }
        if (settings.getSendBufferSize() > 0) {
            socket.setSendBufferSize(settings.getSendBufferSize());
        }
        socket.connect(address.getSocketAddress(), settings.getConnectTimeout(TimeUnit.MILLISECONDS));
    }

    private SocketStreamHelper() {
    }
}

