/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.MongoServerException;
import com.mongodb.ServerAddress;
import java.io.StringWriter;
import java.io.Writer;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonWriter;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.EncoderContext;
import org.bson.json.JsonWriter;

public class MongoCommandException
extends MongoServerException {
    private static final long serialVersionUID = 8160676451944215078L;
    private final BsonDocument response;

    public MongoCommandException(BsonDocument response, ServerAddress address) {
        super(MongoCommandException.extractErrorCode(response), String.format("Command failed with error %s: '%s' on server %s. The full response is %s", MongoCommandException.extractErrorCode(response), MongoCommandException.extractErrorMessage(response), address, MongoCommandException.getResponseAsJson(response)), address);
        this.response = response;
    }

    public int getErrorCode() {
        return this.getCode();
    }

    public String getErrorMessage() {
        return MongoCommandException.extractErrorMessage(this.response);
    }

    public BsonDocument getResponse() {
        return this.response;
    }

    private static String getResponseAsJson(BsonDocument commandResponse) {
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)writer);
        new BsonDocumentCodec().encode((BsonWriter)jsonWriter, commandResponse, EncoderContext.builder().build());
        return writer.toString();
    }

    private static int extractErrorCode(BsonDocument response) {
        if (response.containsKey((Object)"code")) {
            return ((BsonInt32)response.get((Object)"code")).getValue();
        }
        return -1;
    }

    private static String extractErrorMessage(BsonDocument response) {
        if (response.containsKey((Object)"errmsg")) {
            return ((BsonString)response.get((Object)"errmsg")).getValue();
        }
        return null;
    }
}

