/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.DuplicateKeyException;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.connection.Connection;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.WriteOperation;
import java.util.Arrays;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;

public class CreateIndexOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final MongoNamespace namespace;
    private final BsonDocument key;
    private final MongoNamespace systemIndexes;
    private boolean background;
    private boolean unique;
    private String name;
    private boolean sparse;
    private Integer expireAfterSeconds;
    private Integer version;
    private BsonDocument weights;
    private String defaultLanguage;
    private String languageOverride;
    private Integer textIndexVersion;
    private Integer sphereIndexVersion;
    private Integer bits;
    private Double min;
    private Double max;
    private Double bucketSize;
    private boolean dropDups;
    private BsonDocument storageEngineOptions;

    public CreateIndexOperation(MongoNamespace namespace, BsonDocument key) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.systemIndexes = new MongoNamespace(namespace.getDatabaseName(), "system.indexes");
        this.key = Assertions.notNull("key", key);
    }

    public BsonDocument getKey() {
        return this.key;
    }

    public boolean isBackground() {
        return this.background;
    }

    public CreateIndexOperation background(boolean background) {
        this.background = background;
        return this;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public CreateIndexOperation unique(boolean unique) {
        this.unique = unique;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public CreateIndexOperation name(String name) {
        this.name = name;
        return this;
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public CreateIndexOperation sparse(boolean sparse) {
        this.sparse = sparse;
        return this;
    }

    public Integer getExpireAfterSeconds() {
        return this.expireAfterSeconds;
    }

    public CreateIndexOperation expireAfterSeconds(Integer expireAfterSeconds) {
        this.expireAfterSeconds = expireAfterSeconds;
        return this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public CreateIndexOperation version(Integer version) {
        this.version = version;
        return this;
    }

    public BsonDocument getWeights() {
        return this.weights;
    }

    public CreateIndexOperation weights(BsonDocument weights) {
        this.weights = weights;
        return this;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public CreateIndexOperation defaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        return this;
    }

    public String getLanguageOverride() {
        return this.languageOverride;
    }

    public CreateIndexOperation languageOverride(String languageOverride) {
        this.languageOverride = languageOverride;
        return this;
    }

    public Integer getTextIndexVersion() {
        return this.textIndexVersion;
    }

    public CreateIndexOperation textIndexVersion(Integer textIndexVersion) {
        this.textIndexVersion = textIndexVersion;
        return this;
    }

    public Integer getTwoDSphereIndexVersion() {
        return this.sphereIndexVersion;
    }

    public CreateIndexOperation twoDSphereIndexVersion(Integer sphereIndexVersion) {
        this.sphereIndexVersion = sphereIndexVersion;
        return this;
    }

    public Integer getBits() {
        return this.bits;
    }

    public CreateIndexOperation bits(Integer bits) {
        this.bits = bits;
        return this;
    }

    public Double getMin() {
        return this.min;
    }

    public CreateIndexOperation min(Double min) {
        this.min = min;
        return this;
    }

    public Double getMax() {
        return this.max;
    }

    public CreateIndexOperation max(Double max) {
        this.max = max;
        return this;
    }

    public Double getBucketSize() {
        return this.bucketSize;
    }

    public CreateIndexOperation bucketSize(Double bucketSize) {
        this.bucketSize = bucketSize;
        return this;
    }

    public boolean getDropDups() {
        return this.dropDups;
    }

    public CreateIndexOperation dropDups(boolean dropDups) {
        this.dropDups = dropDups;
        return this;
    }

    public BsonDocument getStorageEngineOptions() {
        return this.storageEngineOptions;
    }

    public CreateIndexOperation storageEngineOptions(BsonDocument storageEngineOptions) {
        this.storageEngineOptions = storageEngineOptions;
        return this;
    }

    @Override
    public Void execute(WriteBinding binding) {
        return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<Void>(){

            @Override
            public Void call(Connection connection) {
                if (OperationHelper.serverIsAtLeastVersionTwoDotSix(connection)) {
                    try {
                        CommandOperationHelper.executeWrappedCommandProtocol(CreateIndexOperation.this.namespace.getDatabaseName(), CreateIndexOperation.this.getCommand(), connection);
                    }
                    catch (MongoCommandException e) {
                        throw CreateIndexOperation.this.checkForDuplicateKeyError(e);
                    }
                } else {
                    connection.insert(CreateIndexOperation.this.systemIndexes, true, WriteConcern.ACKNOWLEDGED, Arrays.asList(new InsertRequest(CreateIndexOperation.this.getIndex())));
                }
                return null;
            }
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, final SingleResultCallback<Void> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(Connection connection, Throwable t) {
                if (t != null) {
                    ErrorHandlingResultCallback.errorHandlingCallback(callback).onResult(null, t);
                } else {
                    final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(ErrorHandlingResultCallback.errorHandlingCallback(callback), connection);
                    if (OperationHelper.serverIsAtLeastVersionTwoDotSix(connection)) {
                        CommandOperationHelper.executeWrappedCommandProtocolAsync(CreateIndexOperation.this.namespace.getDatabaseName(), CreateIndexOperation.this.getCommand(), connection, new SingleResultCallback<BsonDocument>(){

                            @Override
                            public void onResult(BsonDocument result, Throwable t) {
                                wrappedCallback.onResult(null, CreateIndexOperation.this.translateException(t));
                            }
                        });
                    } else {
                        connection.insertAsync(CreateIndexOperation.this.systemIndexes, true, WriteConcern.ACKNOWLEDGED, Arrays.asList(new InsertRequest(CreateIndexOperation.this.getIndex())), new SingleResultCallback<WriteConcernResult>(){

                            @Override
                            public void onResult(WriteConcernResult result, Throwable t) {
                                wrappedCallback.onResult(null, CreateIndexOperation.this.translateException(t));
                            }
                        });
                    }
                }
            }
        });
    }

    private BsonDocument getIndex() {
        BsonDocument index = new BsonDocument();
        index.append("key", (BsonValue)this.key);
        index.append("name", (BsonValue)new BsonString(this.getName() != null ? this.getName() : this.generateIndexName(this.key)));
        index.append("ns", (BsonValue)new BsonString(this.namespace.getFullName()));
        if (this.background) {
            index.append("background", (BsonValue)BsonBoolean.TRUE);
        }
        if (this.unique) {
            index.append("unique", (BsonValue)BsonBoolean.TRUE);
        }
        if (this.sparse) {
            index.append("sparse", (BsonValue)BsonBoolean.TRUE);
        }
        if (this.expireAfterSeconds != null) {
            index.append("expireAfterSeconds", (BsonValue)new BsonInt32(this.expireAfterSeconds.intValue()));
        }
        if (this.version != null) {
            index.append("v", (BsonValue)new BsonInt32(this.version.intValue()));
        }
        if (this.weights != null) {
            index.append("weights", (BsonValue)this.weights);
        }
        if (this.defaultLanguage != null) {
            index.append("default_language", (BsonValue)new BsonString(this.defaultLanguage));
        }
        if (this.languageOverride != null) {
            index.append("language_override", (BsonValue)new BsonString(this.languageOverride));
        }
        if (this.textIndexVersion != null) {
            index.append("textIndexVersion", (BsonValue)new BsonInt32(this.textIndexVersion.intValue()));
        }
        if (this.sphereIndexVersion != null) {
            index.append("2dsphereIndexVersion", (BsonValue)new BsonInt32(this.sphereIndexVersion.intValue()));
        }
        if (this.bits != null) {
            index.append("bits", (BsonValue)new BsonInt32(this.bits.intValue()));
        }
        if (this.min != null) {
            index.append("min", (BsonValue)new BsonDouble(this.min.doubleValue()));
        }
        if (this.max != null) {
            index.append("max", (BsonValue)new BsonDouble(this.max.doubleValue()));
        }
        if (this.bucketSize != null) {
            index.append("bucketSize", (BsonValue)new BsonDouble(this.bucketSize.doubleValue()));
        }
        if (this.dropDups) {
            index.append("dropDups", (BsonValue)BsonBoolean.TRUE);
        }
        if (this.storageEngineOptions != null) {
            index.append("storageEngine", (BsonValue)this.storageEngineOptions);
        }
        return index;
    }

    private BsonDocument getCommand() {
        BsonDocument command = new BsonDocument("createIndexes", (BsonValue)new BsonString(this.namespace.getCollectionName()));
        BsonArray array = new BsonArray(Arrays.asList(this.getIndex()));
        command.put("indexes", (BsonValue)array);
        return command;
    }

    private MongoException translateException(Throwable t) {
        return t instanceof MongoCommandException ? this.checkForDuplicateKeyError((MongoCommandException)t) : MongoException.fromThrowable(t);
    }

    private MongoException checkForDuplicateKeyError(MongoCommandException e) {
        if (ErrorCategory.fromErrorCode(e.getCode()) == ErrorCategory.DUPLICATE_KEY) {
            return new DuplicateKeyException(e.getResponse(), e.getServerAddress(), WriteConcernResult.acknowledged(0, false, null));
        }
        return e;
    }

    private String generateIndexName(BsonDocument index) {
        StringBuilder indexName = new StringBuilder();
        for (String keyNames : index.keySet()) {
            if (indexName.length() != 0) {
                indexName.append('_');
            }
            indexName.append(keyNames).append('_');
            BsonValue ascOrDescValue = index.get((Object)keyNames);
            if (ascOrDescValue instanceof BsonInt32) {
                indexName.append(((BsonInt32)ascOrDescValue).getValue());
                continue;
            }
            if (!(ascOrDescValue instanceof BsonString)) continue;
            indexName.append(((BsonString)ascOrDescValue).getValue().replace(' ', '_'));
        }
        return indexName.toString();
    }
}

