/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoCredential;
import com.mongodb.internal.authentication.NativeAuthenticationHelper;
import java.util.Arrays;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;

final class UserOperationHelper {
    static BsonDocument asCommandDocument(MongoCredential credential, boolean readOnly, String commandName) {
        BsonDocument document = new BsonDocument();
        document.put(commandName, (BsonValue)new BsonString(credential.getUserName()));
        document.put("pwd", (BsonValue)new BsonString(NativeAuthenticationHelper.createAuthenticationHash(credential.getUserName(), credential.getPassword())));
        document.put("digestPassword", (BsonValue)BsonBoolean.FALSE);
        document.put("roles", (BsonValue)new BsonArray(Arrays.asList(new BsonString(UserOperationHelper.getRoleName(credential, readOnly)))));
        return document;
    }

    private static String getRoleName(MongoCredential credential, boolean readOnly) {
        return credential.getSource().equals("admin") ? (readOnly ? "readAnyDatabase" : "root") : (readOnly ? "read" : "dbOwner");
    }

    static BsonDocument asCollectionQueryDocument(MongoCredential credential) {
        return new BsonDocument("user", (BsonValue)new BsonString(credential.getUserName()));
    }

    static BsonDocument asCollectionDocument(MongoCredential credential, boolean readOnly) {
        BsonDocument document = UserOperationHelper.asCollectionQueryDocument(credential);
        document.put("pwd", (BsonValue)new BsonString(NativeAuthenticationHelper.createAuthenticationHash(credential.getUserName(), credential.getPassword())));
        document.put("readOnly", (BsonValue)BsonBoolean.valueOf((boolean)readOnly));
        return document;
    }

    private UserOperationHelper() {
    }
}

