/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoCredential;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.ErrorHandlingResultCallback;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.connection.Connection;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.UserOperationHelper;
import com.mongodb.operation.WriteOperation;
import java.util.Arrays;
import org.bson.BsonDocument;

public class UpdateUserOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final MongoCredential credential;
    private final boolean readOnly;

    public UpdateUserOperation(MongoCredential credential, boolean readOnly) {
        this.credential = Assertions.notNull("credential", credential);
        this.readOnly = readOnly;
    }

    public MongoCredential getCredential() {
        return this.credential;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public Void execute(WriteBinding binding) {
        return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<Void>(){

            @Override
            public Void call(Connection connection) {
                if (OperationHelper.serverIsAtLeastVersionTwoDotSix(connection)) {
                    CommandOperationHelper.executeWrappedCommandProtocol(UpdateUserOperation.this.credential.getSource(), UpdateUserOperation.this.getCommand(), connection);
                } else {
                    connection.update(UpdateUserOperation.this.getNamespace(), true, WriteConcern.ACKNOWLEDGED, Arrays.asList(UpdateUserOperation.this.getUpdateRequest()));
                }
                return null;
            }
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, final SingleResultCallback<Void> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(Connection connection, Throwable t) {
                if (t != null) {
                    ErrorHandlingResultCallback.errorHandlingCallback(callback).onResult(null, t);
                } else {
                    final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(ErrorHandlingResultCallback.errorHandlingCallback(callback), connection);
                    if (OperationHelper.serverIsAtLeastVersionTwoDotSix(connection)) {
                        CommandOperationHelper.executeWrappedCommandProtocolAsync(UpdateUserOperation.this.credential.getSource(), UpdateUserOperation.this.getCommand(), connection, new OperationHelper.VoidTransformer<BsonDocument>(), wrappedCallback);
                    } else {
                        connection.updateAsync(UpdateUserOperation.this.getNamespace(), true, WriteConcern.ACKNOWLEDGED, Arrays.asList(UpdateUserOperation.this.getUpdateRequest()), new SingleResultCallback<WriteConcernResult>(){

                            @Override
                            public void onResult(WriteConcernResult result, Throwable t) {
                                wrappedCallback.onResult(null, t);
                            }
                        });
                    }
                }
            }
        });
    }

    private UpdateRequest getUpdateRequest() {
        return new UpdateRequest(UserOperationHelper.asCollectionQueryDocument(this.credential), UserOperationHelper.asCollectionDocument(this.credential, this.readOnly), WriteRequest.Type.REPLACE);
    }

    private MongoNamespace getNamespace() {
        return new MongoNamespace(this.credential.getSource(), "system.users");
    }

    private BsonDocument getCommand() {
        return UserOperationHelper.asCommandDocument(this.credential, this.readOnly, "updateUser");
    }
}

