/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernException;
import com.mongodb.WriteConcernResult;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.ErrorHandlingResultCallback;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.connection.BulkWriteBatchCombiner;
import com.mongodb.connection.Connection;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerVersion;
import com.mongodb.internal.connection.IndexMap;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.WriteOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;

public class MixedBulkWriteOperation
implements AsyncWriteOperation<BulkWriteResult>,
WriteOperation<BulkWriteResult> {
    private final MongoNamespace namespace;
    private final List<? extends WriteRequest> writeRequests;
    private final boolean ordered;
    private final WriteConcern writeConcern;
    private static final List<String> IGNORED_KEYS = Arrays.asList("ok", "err", "code");

    public MixedBulkWriteOperation(MongoNamespace namespace, List<? extends WriteRequest> writeRequests, boolean ordered, WriteConcern writeConcern) {
        this.ordered = ordered;
        this.namespace = Assertions.notNull("namespace", namespace);
        this.writeRequests = Assertions.notNull("writes", writeRequests);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        Assertions.isTrueArgument("writes is not an empty list", !writeRequests.isEmpty());
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public List<? extends WriteRequest> getWriteRequests() {
        return this.writeRequests;
    }

    @Override
    public BulkWriteResult execute(WriteBinding binding) {
        return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<BulkWriteResult>(){

            @Override
            public BulkWriteResult call(Connection connection) {
                BulkWriteBatchCombiner bulkWriteBatchCombiner = new BulkWriteBatchCombiner(connection.getDescription().getServerAddress(), MixedBulkWriteOperation.this.ordered, MixedBulkWriteOperation.this.writeConcern);
                for (Run run : MixedBulkWriteOperation.this.getRunGenerator(connection.getDescription())) {
                    try {
                        BulkWriteResult result = run.execute(connection);
                        if (!result.wasAcknowledged()) continue;
                        bulkWriteBatchCombiner.addResult(result, run.indexMap);
                    }
                    catch (MongoBulkWriteException e) {
                        bulkWriteBatchCombiner.addErrorResult(e, run.indexMap);
                        if (!bulkWriteBatchCombiner.shouldStopSendingMoreBatches()) continue;
                        break;
                    }
                }
                return bulkWriteBatchCombiner.getResult();
            }
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<BulkWriteResult> callback) {
        final SingleResultCallback<BulkWriteResult> wrappedCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback);
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(Connection connection, Throwable t) {
                if (t != null) {
                    wrappedCallback.onResult(null, t);
                } else {
                    Iterator runs = MixedBulkWriteOperation.this.getRunGenerator(connection.getDescription()).iterator();
                    MixedBulkWriteOperation.this.executeRunsAsync(runs, connection, new BulkWriteBatchCombiner(connection.getDescription().getServerAddress(), MixedBulkWriteOperation.this.ordered, MixedBulkWriteOperation.this.writeConcern), wrappedCallback);
                }
            }
        });
    }

    private void executeRunsAsync(final Iterator<Run> runs, final Connection connection, final BulkWriteBatchCombiner bulkWriteBatchCombiner, final SingleResultCallback<BulkWriteResult> callback) {
        final Run run = runs.next();
        final SingleResultCallback<BulkWriteResult> wrappedCallback = OperationHelper.releasingCallback(callback, connection);
        run.executeAsync(connection, new SingleResultCallback<BulkWriteResult>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onResult(BulkWriteResult result, Throwable t) {
                if (t != null) {
                    if (!(t instanceof MongoBulkWriteException)) {
                        wrappedCallback.onResult(null, t);
                        return;
                    }
                    bulkWriteBatchCombiner.addErrorResult((MongoBulkWriteException)t, run.indexMap);
                } else if (result.wasAcknowledged()) {
                    bulkWriteBatchCombiner.addResult(result, run.indexMap);
                }
                if (runs.hasNext() && !bulkWriteBatchCombiner.shouldStopSendingMoreBatches()) {
                    MixedBulkWriteOperation.this.executeRunsAsync(runs, connection, bulkWriteBatchCombiner, callback);
                    return;
                }
                if (bulkWriteBatchCombiner.hasErrors()) {
                    wrappedCallback.onResult(null, bulkWriteBatchCombiner.getError());
                    return;
                }
                wrappedCallback.onResult(bulkWriteBatchCombiner.getResult(), null);
            }
        });
    }

    private boolean shouldUseWriteCommands(Connection connection) {
        return this.writeConcern.isAcknowledged() && this.serverSupportsWriteCommands(connection.getDescription());
    }

    private boolean serverSupportsWriteCommands(ConnectionDescription connectionDescription) {
        return connectionDescription.getServerVersion().compareTo(new ServerVersion(2, 6)) >= 0;
    }

    private Iterable<Run> getRunGenerator(ConnectionDescription connectionDescription) {
        if (this.ordered) {
            return new OrderedRunGenerator(connectionDescription);
        }
        return new UnorderedRunGenerator(connectionDescription);
    }

    private class Run {
        private final List runWrites = new ArrayList();
        private final WriteRequest.Type type;
        private final boolean ordered;
        private IndexMap indexMap = IndexMap.create();

        Run(WriteRequest.Type type, boolean ordered) {
            this.type = type;
            this.ordered = ordered;
        }

        void add(WriteRequest writeRequest, int originalIndex) {
            this.indexMap = this.indexMap.add(this.runWrites.size(), originalIndex);
            this.runWrites.add(writeRequest);
        }

        public int size() {
            return this.runWrites.size();
        }

        BulkWriteResult execute(Connection connection) {
            BulkWriteResult nextWriteResult;
            if (this.type == WriteRequest.Type.UPDATE || this.type == WriteRequest.Type.REPLACE) {
                nextWriteResult = this.getUpdatesRunExecutor(this.runWrites, connection).execute();
            } else if (this.type == WriteRequest.Type.INSERT) {
                nextWriteResult = this.getInsertsRunExecutor(this.runWrites, connection).execute();
            } else if (this.type == WriteRequest.Type.DELETE) {
                nextWriteResult = this.getDeletesRunExecutor(this.runWrites, connection).execute();
            } else {
                throw new UnsupportedOperationException(String.format("Unsupported write of type %s", new Object[]{this.type}));
            }
            return nextWriteResult;
        }

        void executeAsync(Connection connection, SingleResultCallback<BulkWriteResult> callback) {
            if (this.type == WriteRequest.Type.UPDATE || this.type == WriteRequest.Type.REPLACE) {
                this.getUpdatesRunExecutor(this.runWrites, connection).executeAsync(callback);
            } else if (this.type == WriteRequest.Type.INSERT) {
                this.getInsertsRunExecutor(this.runWrites, connection).executeAsync(callback);
            } else if (this.type == WriteRequest.Type.DELETE) {
                this.getDeletesRunExecutor(this.runWrites, connection).executeAsync(callback);
            } else {
                callback.onResult(null, new UnsupportedOperationException(String.format("Unsupported write of type %s", new Object[]{this.type})));
            }
        }

        RunExecutor getDeletesRunExecutor(final List<DeleteRequest> deleteRequests, final Connection connection) {
            return new RunExecutor(connection){

                @Override
                WriteConcernResult executeWriteProtocol(int index) {
                    return connection.delete(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, Arrays.asList((DeleteRequest)deleteRequests.get(index)));
                }

                @Override
                void executeWriteProtocolAsync(int index, SingleResultCallback<WriteConcernResult> callback) {
                    connection.deleteAsync(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, Arrays.asList((DeleteRequest)deleteRequests.get(index)), callback);
                }

                @Override
                BulkWriteResult executeWriteCommandProtocol() {
                    return connection.deleteCommand(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, deleteRequests);
                }

                @Override
                void executeWriteCommandProtocolAsync(SingleResultCallback<BulkWriteResult> callback) {
                    connection.deleteCommandAsync(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, deleteRequests, callback);
                }

                @Override
                WriteRequest.Type getType() {
                    return WriteRequest.Type.DELETE;
                }
            };
        }

        RunExecutor getInsertsRunExecutor(final List<InsertRequest> insertRequests, final Connection connection) {
            return new RunExecutor(connection){

                @Override
                WriteConcernResult executeWriteProtocol(int index) {
                    return connection.insert(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, Arrays.asList((InsertRequest)insertRequests.get(index)));
                }

                @Override
                void executeWriteProtocolAsync(int index, SingleResultCallback<WriteConcernResult> callback) {
                    connection.insertAsync(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, Arrays.asList((InsertRequest)insertRequests.get(index)), callback);
                }

                @Override
                BulkWriteResult executeWriteCommandProtocol() {
                    return connection.insertCommand(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, insertRequests);
                }

                @Override
                void executeWriteCommandProtocolAsync(SingleResultCallback<BulkWriteResult> callback) {
                    connection.insertCommandAsync(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, insertRequests, callback);
                }

                @Override
                WriteRequest.Type getType() {
                    return WriteRequest.Type.INSERT;
                }

                @Override
                int getCount(WriteConcernResult writeConcernResult) {
                    return 1;
                }
            };
        }

        RunExecutor getUpdatesRunExecutor(final List<UpdateRequest> updates, final Connection connection) {
            return new RunExecutor(connection){

                @Override
                WriteConcernResult executeWriteProtocol(int index) {
                    return connection.update(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, Arrays.asList((UpdateRequest)updates.get(index)));
                }

                @Override
                void executeWriteProtocolAsync(int index, SingleResultCallback<WriteConcernResult> callback) {
                    connection.updateAsync(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, Arrays.asList((UpdateRequest)updates.get(index)), callback);
                }

                @Override
                BulkWriteResult executeWriteCommandProtocol() {
                    return connection.updateCommand(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, updates);
                }

                @Override
                void executeWriteCommandProtocolAsync(SingleResultCallback<BulkWriteResult> callback) {
                    connection.updateCommandAsync(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, updates, callback);
                }

                @Override
                WriteRequest.Type getType() {
                    return WriteRequest.Type.UPDATE;
                }
            };
        }

        private abstract class RunExecutor {
            private final Connection connection;

            RunExecutor(Connection connection) {
                this.connection = connection;
            }

            abstract WriteConcernResult executeWriteProtocol(int var1);

            abstract void executeWriteProtocolAsync(int var1, SingleResultCallback<WriteConcernResult> var2);

            abstract BulkWriteResult executeWriteCommandProtocol();

            abstract void executeWriteCommandProtocolAsync(SingleResultCallback<BulkWriteResult> var1);

            abstract WriteRequest.Type getType();

            int getCount(WriteConcernResult writeConcernResult) {
                return this.getType() == WriteRequest.Type.INSERT ? 1 : writeConcernResult.getCount();
            }

            BulkWriteResult execute() {
                if (MixedBulkWriteOperation.this.shouldUseWriteCommands(this.connection)) {
                    return this.executeWriteCommandProtocol();
                }
                BulkWriteBatchCombiner bulkWriteBatchCombiner = new BulkWriteBatchCombiner(this.connection.getDescription().getServerAddress(), Run.this.ordered, MixedBulkWriteOperation.this.writeConcern);
                for (int i = 0; i < Run.this.runWrites.size(); ++i) {
                    IndexMap indexMap = IndexMap.create(i, 1);
                    indexMap = indexMap.add(0, i);
                    try {
                        WriteConcernResult result = this.executeWriteProtocol(i);
                        if (!result.wasAcknowledged()) continue;
                        BulkWriteResult bulkWriteResult = this.getType() == WriteRequest.Type.UPDATE || this.getType() == WriteRequest.Type.REPLACE ? this.getResult(result, (UpdateRequest)Run.this.runWrites.get(i)) : this.getResult(result);
                        bulkWriteBatchCombiner.addResult(bulkWriteResult, indexMap);
                        continue;
                    }
                    catch (WriteConcernException writeException) {
                        if (writeException.getResponse().get((Object)"wtimeout") != null) {
                            bulkWriteBatchCombiner.addWriteConcernErrorResult(this.getWriteConcernError(writeException));
                        } else {
                            bulkWriteBatchCombiner.addWriteErrorResult(this.getBulkWriteError(writeException), indexMap);
                        }
                        if (bulkWriteBatchCombiner.shouldStopSendingMoreBatches()) break;
                    }
                }
                return bulkWriteBatchCombiner.getResult();
            }

            void executeAsync(SingleResultCallback<BulkWriteResult> callback) {
                if (MixedBulkWriteOperation.this.shouldUseWriteCommands(this.connection)) {
                    this.executeWriteCommandProtocolAsync(callback);
                } else {
                    BulkWriteBatchCombiner bulkWriteBatchCombiner = new BulkWriteBatchCombiner(this.connection.getDescription().getServerAddress(), Run.this.ordered, MixedBulkWriteOperation.this.writeConcern);
                    this.executeRunWritesAsync(Run.this.runWrites.size(), 0, bulkWriteBatchCombiner, callback);
                }
            }

            private void executeRunWritesAsync(final int numberOfRuns, final int currentPosition, final BulkWriteBatchCombiner bulkWriteBatchCombiner, final SingleResultCallback<BulkWriteResult> callback) {
                final IndexMap indexMap = IndexMap.create(currentPosition, 1).add(0, currentPosition);
                this.executeWriteProtocolAsync(currentPosition, new SingleResultCallback<WriteConcernResult>(){

                    /*
                     * Enabled aggressive block sorting
                     */
                    @Override
                    public void onResult(WriteConcernResult result, Throwable t) {
                        int nextRunPosition = currentPosition + 1;
                        if (t != null) {
                            if (!(t instanceof WriteConcernException)) {
                                callback.onResult(null, t);
                                return;
                            }
                            WriteConcernException writeException = (WriteConcernException)t;
                            if (writeException.getResponse().get((Object)"wtimeout") != null) {
                                bulkWriteBatchCombiner.addWriteConcernErrorResult(RunExecutor.this.getWriteConcernError(writeException));
                            } else {
                                bulkWriteBatchCombiner.addWriteErrorResult(RunExecutor.this.getBulkWriteError(writeException), indexMap);
                            }
                        } else if (result.wasAcknowledged()) {
                            BulkWriteResult bulkWriteResult = RunExecutor.this.getType() == WriteRequest.Type.UPDATE || RunExecutor.this.getType() == WriteRequest.Type.REPLACE ? RunExecutor.this.getResult(result, (UpdateRequest)Run.this.runWrites.get(currentPosition)) : RunExecutor.this.getResult(result);
                            bulkWriteBatchCombiner.addResult(bulkWriteResult, indexMap);
                        }
                        if (numberOfRuns != nextRunPosition && !bulkWriteBatchCombiner.shouldStopSendingMoreBatches()) {
                            RunExecutor.this.executeRunWritesAsync(numberOfRuns, nextRunPosition, bulkWriteBatchCombiner, callback);
                            return;
                        }
                        if (bulkWriteBatchCombiner.hasErrors()) {
                            callback.onResult(null, bulkWriteBatchCombiner.getError());
                            return;
                        }
                        callback.onResult(bulkWriteBatchCombiner.getResult(), null);
                    }
                });
            }

            BulkWriteResult getResult(WriteConcernResult writeConcernResult) {
                return this.getResult(writeConcernResult, this.getUpsertedItems(writeConcernResult));
            }

            BulkWriteResult getResult(WriteConcernResult writeConcernResult, UpdateRequest updateRequest) {
                return this.getResult(writeConcernResult, this.getUpsertedItems(writeConcernResult, updateRequest));
            }

            BulkWriteResult getResult(WriteConcernResult writeConcernResult, List<BulkWriteUpsert> upsertedItems) {
                int count = this.getCount(writeConcernResult);
                Integer modifiedCount = this.getType() == WriteRequest.Type.UPDATE || this.getType() == WriteRequest.Type.REPLACE ? null : Integer.valueOf(0);
                return BulkWriteResult.acknowledged(this.getType(), count - upsertedItems.size(), modifiedCount, upsertedItems);
            }

            List<BulkWriteUpsert> getUpsertedItems(WriteConcernResult writeConcernResult) {
                return writeConcernResult.getUpsertedId() == null ? Collections.emptyList() : Arrays.asList(new BulkWriteUpsert(0, writeConcernResult.getUpsertedId()));
            }

            List<BulkWriteUpsert> getUpsertedItems(WriteConcernResult writeConcernResult, UpdateRequest updateRequest) {
                if (writeConcernResult.getUpsertedId() == null) {
                    if (writeConcernResult.isUpdateOfExisting() || !updateRequest.isUpsert()) {
                        return Collections.emptyList();
                    }
                    BsonDocument update = updateRequest.getUpdate();
                    BsonDocument filter = updateRequest.getFilter();
                    if (update.containsKey((Object)"_id")) {
                        return Arrays.asList(new BulkWriteUpsert(0, update.get((Object)"_id")));
                    }
                    if (filter.containsKey((Object)"_id")) {
                        return Arrays.asList(new BulkWriteUpsert(0, filter.get((Object)"_id")));
                    }
                    return Collections.emptyList();
                }
                return Arrays.asList(new BulkWriteUpsert(0, writeConcernResult.getUpsertedId()));
            }

            private BulkWriteError getBulkWriteError(WriteConcernException writeException) {
                return new BulkWriteError(writeException.getErrorCode(), writeException.getErrorMessage(), this.translateGetLastErrorResponseToErrInfo(writeException.getResponse()), 0);
            }

            private WriteConcernError getWriteConcernError(WriteConcernException writeException) {
                return new WriteConcernError(writeException.getErrorCode(), ((BsonString)writeException.getResponse().get((Object)"err")).getValue(), this.translateGetLastErrorResponseToErrInfo(writeException.getResponse()));
            }

            private BsonDocument translateGetLastErrorResponseToErrInfo(BsonDocument response) {
                BsonDocument errInfo = new BsonDocument();
                for (Map.Entry entry : response.entrySet()) {
                    if (IGNORED_KEYS.contains(entry.getKey())) continue;
                    errInfo.put((String)entry.getKey(), (BsonValue)entry.getValue());
                }
                return errInfo;
            }
        }
    }

    private class UnorderedRunGenerator
    implements Iterable<Run> {
        private final int maxBatchCount;

        public UnorderedRunGenerator(ConnectionDescription connectionDescription) {
            this.maxBatchCount = connectionDescription.getMaxBatchCount();
        }

        @Override
        public Iterator<Run> iterator() {
            return new Iterator<Run>(){
                private final List<Run> runs = new ArrayList<Run>();
                private int curIndex;

                @Override
                public boolean hasNext() {
                    return this.curIndex < MixedBulkWriteOperation.this.writeRequests.size() || !this.runs.isEmpty();
                }

                @Override
                public Run next() {
                    while (this.curIndex < MixedBulkWriteOperation.this.writeRequests.size()) {
                        WriteRequest writeRequest = (WriteRequest)MixedBulkWriteOperation.this.writeRequests.get(this.curIndex);
                        Run run = this.findRunOfType(writeRequest.getType());
                        if (run == null) {
                            run = new Run(writeRequest.getType(), false);
                            this.runs.add(run);
                        }
                        run.add(writeRequest, this.curIndex);
                        ++this.curIndex;
                        if (run.size() != UnorderedRunGenerator.this.maxBatchCount) continue;
                        this.runs.remove(run);
                        return run;
                    }
                    return this.runs.remove(0);
                }

                private Run findRunOfType(WriteRequest.Type type) {
                    for (Run cur : this.runs) {
                        if (cur.type != type) continue;
                        return cur;
                    }
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not implemented");
                }
            };
        }
    }

    private class OrderedRunGenerator
    implements Iterable<Run> {
        private final int maxBatchCount;

        public OrderedRunGenerator(ConnectionDescription connectionDescription) {
            this.maxBatchCount = connectionDescription.getMaxBatchCount();
        }

        @Override
        public Iterator<Run> iterator() {
            return new Iterator<Run>(){
                private int curIndex;

                @Override
                public boolean hasNext() {
                    return this.curIndex < MixedBulkWriteOperation.this.writeRequests.size();
                }

                @Override
                public Run next() {
                    Run run = new Run(((WriteRequest)MixedBulkWriteOperation.this.writeRequests.get(this.curIndex)).getType(), true);
                    int nextIndex = this.getNextIndex();
                    for (int i = this.curIndex; i < nextIndex; ++i) {
                        run.add((WriteRequest)MixedBulkWriteOperation.this.writeRequests.get(i), i);
                    }
                    this.curIndex = nextIndex;
                    return run;
                }

                private int getNextIndex() {
                    WriteRequest.Type type = ((WriteRequest)MixedBulkWriteOperation.this.writeRequests.get(this.curIndex)).getType();
                    for (int i = this.curIndex; i < MixedBulkWriteOperation.this.writeRequests.size(); ++i) {
                        if (i != this.curIndex + OrderedRunGenerator.this.maxBatchCount && ((WriteRequest)MixedBulkWriteOperation.this.writeRequests.get(i)).getType() == type) continue;
                        return i;
                    }
                    return MixedBulkWriteOperation.this.writeRequests.size();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not implemented");
                }
            };
        }
    }
}

