/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.ByteBufferBsonOutput;
import com.mongodb.connection.CommandMessage;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.Protocol;
import com.mongodb.connection.ProtocolHelper;
import com.mongodb.connection.ReplyMessage;
import com.mongodb.connection.RequestMessage;
import com.mongodb.connection.ResponseBuffers;
import com.mongodb.connection.SendMessageCallback;
import com.mongodb.connection.UnacknowledgedWriteResultCallback;
import com.mongodb.connection.WriteResultCallback;
import com.mongodb.diagnostics.logging.Logger;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;
import org.bson.io.BsonOutput;

abstract class WriteProtocol
implements Protocol<WriteConcernResult> {
    private final MongoNamespace namespace;
    private final boolean ordered;
    private final WriteConcern writeConcern;

    public WriteProtocol(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern) {
        this.namespace = namespace;
        this.ordered = ordered;
        this.writeConcern = writeConcern;
    }

    @Override
    public WriteConcernResult execute(InternalConnection connection) {
        return this.receiveMessage(connection, this.sendMessage(connection));
    }

    @Override
    public void executeAsync(InternalConnection connection, SingleResultCallback<WriteConcernResult> callback) {
        try {
            ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(connection);
            RequestMessage requestMessage = this.createRequestMessage(ProtocolHelper.getMessageSettings(connection.getDescription()));
            RequestMessage nextMessage = ProtocolHelper.encodeMessage(requestMessage, (BsonOutput)bsonOutput);
            if (this.writeConcern.isAcknowledged()) {
                CommandMessage getLastErrorMessage = new CommandMessage(new MongoNamespace(this.getNamespace().getDatabaseName(), "$cmd").getFullName(), this.createGetLastErrorCommandDocument(), false, ProtocolHelper.getMessageSettings(connection.getDescription()));
                ProtocolHelper.encodeMessage(getLastErrorMessage, (BsonOutput)bsonOutput);
                WriteResultCallback recieveCallback = new WriteResultCallback(callback, (Decoder<BsonDocument>)new BsonDocumentCodec(), this.getNamespace(), nextMessage, this.ordered, this.writeConcern, getLastErrorMessage.getId(), connection);
                connection.sendMessageAsync(bsonOutput.getByteBuffers(), getLastErrorMessage.getId(), new SendMessageCallback<WriteConcernResult>(connection, bsonOutput, getLastErrorMessage.getId(), callback, recieveCallback));
            } else {
                connection.sendMessageAsync(bsonOutput.getByteBuffers(), requestMessage.getId(), new UnacknowledgedWriteResultCallback(callback, this.getNamespace(), nextMessage, this.ordered, bsonOutput, connection));
            }
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandMessage sendMessage(InternalConnection connection) {
        ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(connection);
        try {
            RequestMessage lastMessage = this.createRequestMessage(ProtocolHelper.getMessageSettings(connection.getDescription()));
            RequestMessage nextMessage = lastMessage.encode((BsonOutput)bsonOutput);
            int batchNum = 1;
            if (nextMessage != null && this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(String.format("Sending batch %d", batchNum));
            }
            while (nextMessage != null) {
                ++batchNum;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(String.format("Sending batch %d", batchNum));
                }
                lastMessage = nextMessage;
                nextMessage = nextMessage.encode((BsonOutput)bsonOutput);
            }
            CommandMessage getLastErrorMessage = null;
            if (this.writeConcern.isAcknowledged()) {
                getLastErrorMessage = new CommandMessage(new MongoNamespace(this.getNamespace().getDatabaseName(), "$cmd").getFullName(), this.createGetLastErrorCommandDocument(), false, ProtocolHelper.getMessageSettings(connection.getDescription()));
                getLastErrorMessage.encode((BsonOutput)bsonOutput);
                lastMessage = getLastErrorMessage;
            }
            connection.sendMessage(bsonOutput.getByteBuffers(), lastMessage.getId());
            CommandMessage commandMessage = getLastErrorMessage;
            return commandMessage;
        }
        finally {
            bsonOutput.close();
        }
    }

    private BsonDocument createGetLastErrorCommandDocument() {
        BsonDocument command = new BsonDocument("getlasterror", (BsonValue)new BsonInt32(1));
        command.putAll((Map)this.writeConcern.asDocument());
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WriteConcernResult receiveMessage(InternalConnection connection, RequestMessage requestMessage) {
        if (requestMessage == null) {
            return WriteConcernResult.unacknowledged();
        }
        ResponseBuffers responseBuffers = connection.receiveMessage(requestMessage.getId());
        try {
            ReplyMessage replyMessage = new ReplyMessage(responseBuffers, new BsonDocumentCodec(), requestMessage.getId());
            WriteConcernResult writeConcernResult = ProtocolHelper.getWriteResult((BsonDocument)replyMessage.getDocuments().get(0), connection.getDescription().getServerAddress());
            return writeConcernResult;
        }
        finally {
            responseBuffers.close();
        }
    }

    protected abstract RequestMessage createRequestMessage(MessageSettings var1);

    protected MongoNamespace getNamespace() {
        return this.namespace;
    }

    protected boolean isOrdered() {
        return this.ordered;
    }

    protected WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    protected abstract Logger getLogger();
}

