/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;

@NotThreadSafe
class ExponentiallyWeightedMovingAverage {
    private final double alpha;
    private long average;

    ExponentiallyWeightedMovingAverage(double alpha) {
        Assertions.isTrueArgument("alpha >= 0.0 and <= 1.0", alpha >= 0.0 && alpha <= 1.0);
        this.alpha = alpha;
    }

    void reset() {
        this.average = 0L;
    }

    long addSample(long sample) {
        this.average = this.average == 0L ? sample : (long)(this.alpha * (double)sample + (1.0 - this.alpha) * (double)this.average);
        return this.average;
    }

    long getAverage() {
        return this.average;
    }
}

