/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoInternalException;
import com.mongodb.ReadConcern;
import com.mongodb.TransactionOptions;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ClientSession;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.OperationExecutor;
import com.mongodb.internal.session.BaseClientSessionImpl;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.operation.AbortTransactionOperation;
import com.mongodb.operation.CommitTransactionOperation;

class ClientSessionImpl
extends BaseClientSessionImpl
implements ClientSession {
    private final OperationExecutor executor;
    private TransactionState transactionState = TransactionState.NONE;
    private boolean messageSent;
    private boolean commitInProgress;
    private TransactionOptions transactionOptions;

    ClientSessionImpl(ServerSessionPool serverSessionPool, MongoClient mongoClient, ClientSessionOptions options, OperationExecutor executor) {
        super(serverSessionPool, (Object)mongoClient, options);
        this.executor = executor;
    }

    @Override
    public boolean hasActiveTransaction() {
        return this.transactionState == TransactionState.IN || this.transactionState == TransactionState.DONE && this.commitInProgress;
    }

    @Override
    public boolean notifyMessageSent() {
        boolean firstMessage = !this.messageSent;
        this.messageSent = true;
        return firstMessage;
    }

    @Override
    public TransactionOptions getTransactionOptions() {
        Assertions.isTrue((String)"in transaction", (this.transactionState == TransactionState.IN || this.transactionState == TransactionState.DONE ? 1 : 0) != 0);
        return this.transactionOptions;
    }

    @Override
    public void startTransaction() {
        this.startTransaction(TransactionOptions.builder().build());
    }

    @Override
    public void startTransaction(TransactionOptions transactionOptions) {
        Assertions.notNull((String)"transactionOptions", (Object)transactionOptions);
        if (this.transactionState == TransactionState.IN) {
            throw new IllegalStateException("Transaction already in progress");
        }
        if (this.transactionState == TransactionState.DONE) {
            this.cleanupTransaction(TransactionState.IN);
        } else {
            this.transactionState = TransactionState.IN;
        }
        this.getServerSession().advanceTransactionNumber();
        this.transactionOptions = TransactionOptions.merge((TransactionOptions)transactionOptions, (TransactionOptions)this.getOptions().getDefaultTransactionOptions());
    }

    @Override
    public void commitTransaction(final SingleResultCallback<Void> callback) {
        if (this.transactionState == TransactionState.ABORTED) {
            throw new IllegalStateException("Cannot call commitTransaction after calling abortTransaction");
        }
        if (this.transactionState == TransactionState.NONE) {
            throw new IllegalStateException("There is no transaction started");
        }
        if (!this.messageSent) {
            this.cleanupTransaction(TransactionState.DONE);
            callback.onResult(null, null);
        } else {
            ReadConcern readConcern = this.transactionOptions.getReadConcern();
            if (readConcern == null) {
                throw new MongoInternalException("Invariant violated.  Transaction options read concern can not be null");
            }
            this.commitInProgress = true;
            this.executor.execute(new CommitTransactionOperation(this.transactionOptions.getWriteConcern()), readConcern, this, new SingleResultCallback<Void>(){

                public void onResult(Void result, Throwable t) {
                    ClientSessionImpl.this.commitInProgress = false;
                    ClientSessionImpl.this.transactionState = TransactionState.DONE;
                    callback.onResult((Object)result, t);
                }
            });
        }
    }

    @Override
    public void abortTransaction(final SingleResultCallback<Void> callback) {
        if (this.transactionState == TransactionState.ABORTED) {
            throw new IllegalStateException("Cannot call abortTransaction twice");
        }
        if (this.transactionState == TransactionState.DONE) {
            throw new IllegalStateException("Cannot call abortTransaction after calling commitTransaction");
        }
        if (this.transactionState == TransactionState.NONE) {
            throw new IllegalStateException("There is no transaction started");
        }
        if (!this.messageSent) {
            this.cleanupTransaction(TransactionState.ABORTED);
            callback.onResult(null, null);
        } else {
            ReadConcern readConcern = this.transactionOptions.getReadConcern();
            if (readConcern == null) {
                throw new MongoInternalException("Invariant violated.  Transaction options read concern can not be null");
            }
            this.executor.execute(new AbortTransactionOperation(this.transactionOptions.getWriteConcern()), readConcern, this, new SingleResultCallback<Void>(){

                public void onResult(Void result, Throwable t) {
                    ClientSessionImpl.this.cleanupTransaction(TransactionState.ABORTED);
                    callback.onResult(null, null);
                }
            });
        }
    }

    public void close() {
        if (this.transactionState == TransactionState.IN) {
            this.abortTransaction(new SingleResultCallback<Void>(){

                public void onResult(Void result, Throwable t) {
                    ClientSessionImpl.super.close();
                }
            });
        } else {
            super.close();
        }
    }

    private void cleanupTransaction(TransactionState nextState) {
        this.messageSent = false;
        this.transactionOptions = null;
        this.transactionState = nextState;
    }

    private static enum TransactionState {
        NONE,
        IN,
        DONE,
        ABORTED;

    }
}

