/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Function;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ListCollectionsIterable;
import com.mongodb.async.client.ListCollectionsIterableImpl;
import com.mongodb.async.client.MongoClients;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.MongoCollectionImpl;
import com.mongodb.async.client.MongoDatabase;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.client.model.IndexOptionDefaults;
import com.mongodb.client.model.ValidationOptions;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.CommandReadOperation;
import com.mongodb.operation.CreateCollectionOperation;
import com.mongodb.operation.CreateViewOperation;
import com.mongodb.operation.DropDatabaseOperation;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class MongoDatabaseImpl
implements MongoDatabase {
    private final String name;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final ReadConcern readConcern;
    private final AsyncOperationExecutor executor;

    MongoDatabaseImpl(String name, CodecRegistry codecRegistry, ReadPreference readPreference, WriteConcern writeConcern, boolean retryWrites, ReadConcern readConcern, AsyncOperationExecutor executor) {
        MongoNamespace.checkDatabaseNameValidity((String)name);
        this.name = (String)Assertions.notNull((String)"name", (Object)name);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.writeConcern = (WriteConcern)Assertions.notNull((String)"writeConcern", (Object)writeConcern);
        this.retryWrites = retryWrites;
        this.readConcern = (ReadConcern)Assertions.notNull((String)"readConcern", (Object)readConcern);
        this.executor = (AsyncOperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Override
    public MongoDatabase withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoDatabaseImpl(this.name, codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.readConcern, this.executor);
    }

    @Override
    public MongoDatabase withReadPreference(ReadPreference readPreference) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, readPreference, this.writeConcern, this.retryWrites, this.readConcern, this.executor);
    }

    @Override
    public MongoDatabase withWriteConcern(WriteConcern writeConcern) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, this.readPreference, writeConcern, this.retryWrites, this.readConcern, this.executor);
    }

    @Override
    public MongoDatabase withReadConcern(ReadConcern readConcern) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, readConcern, this.executor);
    }

    @Override
    public MongoIterable<String> listCollectionNames() {
        return new ListCollectionsIterableImpl<BsonDocument>(this.name, BsonDocument.class, MongoClients.getDefaultCodecRegistry(), ReadPreference.primary(), this.executor).map(new Function<BsonDocument, String>(){

            public String apply(BsonDocument result) {
                return result.getString((Object)"name").getValue();
            }
        });
    }

    @Override
    public ListCollectionsIterable<Document> listCollections() {
        return this.listCollections(Document.class);
    }

    @Override
    public <TResult> ListCollectionsIterable<TResult> listCollections(Class<TResult> resultClass) {
        return new ListCollectionsIterableImpl<TResult>(this.name, resultClass, this.codecRegistry, ReadPreference.primary(), this.executor);
    }

    @Override
    public MongoCollection<Document> getCollection(String collectionName) {
        return this.getCollection(collectionName, Document.class);
    }

    @Override
    public <TDocument> MongoCollection<TDocument> getCollection(String collectionName, Class<TDocument> documentClass) {
        return new MongoCollectionImpl<TDocument>(new MongoNamespace(this.name, collectionName), documentClass, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.readConcern, this.executor);
    }

    @Override
    public void runCommand(Bson command, SingleResultCallback<Document> callback) {
        this.runCommand(command, Document.class, callback);
    }

    @Override
    public void runCommand(Bson command, ReadPreference readPreference, SingleResultCallback<Document> callback) {
        this.runCommand(command, readPreference, Document.class, callback);
    }

    @Override
    public <TResult> void runCommand(Bson command, Class<TResult> resultClass, SingleResultCallback<TResult> callback) {
        Assertions.notNull((String)"command", (Object)command);
        this.runCommand(command, ReadPreference.primary(), resultClass, callback);
    }

    @Override
    public <TResult> void runCommand(Bson command, ReadPreference readPreference, Class<TResult> resultClass, SingleResultCallback<TResult> callback) {
        Assertions.notNull((String)"command", (Object)command);
        Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.executor.execute((AsyncReadOperation)new CommandReadOperation(this.getName(), this.toBsonDocument(command), (Decoder)this.codecRegistry.get(resultClass)), readPreference, callback);
    }

    @Override
    public void drop(SingleResultCallback<Void> callback) {
        this.executor.execute((AsyncWriteOperation)new DropDatabaseOperation(this.name, this.writeConcern), callback);
    }

    @Override
    public void createCollection(String collectionName, SingleResultCallback<Void> callback) {
        this.createCollection(collectionName, new CreateCollectionOptions(), callback);
    }

    @Override
    public void createCollection(String collectionName, CreateCollectionOptions createCollectionOptions, SingleResultCallback<Void> callback) {
        ValidationOptions validationOptions;
        CreateCollectionOperation operation = new CreateCollectionOperation(this.name, collectionName, this.writeConcern).capped(createCollectionOptions.isCapped()).sizeInBytes(createCollectionOptions.getSizeInBytes()).autoIndex(createCollectionOptions.isAutoIndex()).maxDocuments(createCollectionOptions.getMaxDocuments()).usePowerOf2Sizes(createCollectionOptions.isUsePowerOf2Sizes()).storageEngineOptions(this.toBsonDocument(createCollectionOptions.getStorageEngineOptions())).collation(createCollectionOptions.getCollation());
        IndexOptionDefaults indexOptionDefaults = createCollectionOptions.getIndexOptionDefaults();
        if (indexOptionDefaults.getStorageEngine() != null) {
            operation.indexOptionDefaults(new BsonDocument("storageEngine", (BsonValue)this.toBsonDocument(indexOptionDefaults.getStorageEngine())));
        }
        if ((validationOptions = createCollectionOptions.getValidationOptions()).getValidator() != null) {
            operation.validator(this.toBsonDocument(validationOptions.getValidator()));
        }
        if (validationOptions.getValidationLevel() != null) {
            operation.validationLevel(validationOptions.getValidationLevel());
        }
        if (validationOptions.getValidationAction() != null) {
            operation.validationAction(validationOptions.getValidationAction());
        }
        this.executor.execute((AsyncWriteOperation)operation, callback);
    }

    @Override
    public void createView(String viewName, String viewOn, List<? extends Bson> pipeline, SingleResultCallback<Void> callback) {
        this.createView(viewName, viewOn, pipeline, new CreateViewOptions(), callback);
    }

    @Override
    public void createView(String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"createViewOptions", (Object)createViewOptions);
        this.executor.execute((AsyncWriteOperation)new CreateViewOperation(this.name, viewName, viewOn, this.createBsonDocumentList(pipeline), this.writeConcern).collation(createViewOptions.getCollation()), callback);
    }

    private List<BsonDocument> createBsonDocumentList(List<? extends Bson> pipeline) {
        Assertions.notNull((String)"pipeline", pipeline);
        ArrayList<BsonDocument> bsonDocumentPipeline = new ArrayList<BsonDocument>(pipeline.size());
        for (Bson bson : pipeline) {
            if (bson == null) {
                throw new IllegalArgumentException("pipeline can not contain a null value");
            }
            bsonDocumentPipeline.add(bson.toBsonDocument(BsonDocument.class, this.codecRegistry));
        }
        return bsonDocumentPipeline;
    }

    private BsonDocument toBsonDocument(Bson document) {
        return document == null ? null : document.toBsonDocument(BsonDocument.class, this.codecRegistry);
    }
}

