/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.ConnectionString;
import com.mongodb.DBRefCodecProvider;
import com.mongodb.DocumentToDBRefTransformer;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClientImpl;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.async.client.NettyMongoClients;
import com.mongodb.client.MongoDriverInformation;
import com.mongodb.client.gridfs.codecs.GridFSFileCodecProvider;
import com.mongodb.client.model.geojson.codecs.GeoJsonCodecProvider;
import com.mongodb.connection.AsynchronousSocketChannelStreamFactory;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.DefaultClusterFactory;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.StreamFactory;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.internal.event.EventListenerHelper;
import java.io.Closeable;
import java.util.Arrays;
import org.bson.Transformer;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.IterableCodecProvider;
import org.bson.codecs.MapCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

public final class MongoClients {
    private static final CodecRegistry DEFAULT_CODEC_REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new BsonValueCodecProvider(), new DBRefCodecProvider(), new DocumentCodecProvider((Transformer)new DocumentToDBRefTransformer()), new IterableCodecProvider((Transformer)new DocumentToDBRefTransformer()), new MapCodecProvider((Transformer)new DocumentToDBRefTransformer()), new GeoJsonCodecProvider(), new GridFSFileCodecProvider()));

    public static MongoClient create() {
        return MongoClients.create(new ConnectionString("mongodb://localhost"));
    }

    public static MongoClient create(MongoClientSettings settings) {
        return MongoClients.create(settings, null);
    }

    public static MongoClient create(String connectionString) {
        return MongoClients.create(new ConnectionString(connectionString));
    }

    public static MongoClient create(ConnectionString connectionString) {
        return MongoClients.create(connectionString, null);
    }

    public static MongoClient create(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(settings, mongoDriverInformation, null);
    }

    public static MongoClient create(ConnectionString connectionString, MongoDriverInformation mongoDriverInformation) {
        MongoClientSettings.Builder builder = MongoClientSettings.builder().clusterSettings(ClusterSettings.builder().applyConnectionString(connectionString).build()).connectionPoolSettings(ConnectionPoolSettings.builder().applyConnectionString(connectionString).build()).serverSettings(ServerSettings.builder().applyConnectionString(connectionString).build()).sslSettings(SslSettings.builder().applyConnectionString(connectionString).build()).socketSettings(SocketSettings.builder().applyConnectionString(connectionString).build());
        if (connectionString.getCredential() != null) {
            builder.credential(connectionString.getCredential());
        }
        if (connectionString.getReadPreference() != null) {
            builder.readPreference(connectionString.getReadPreference());
        }
        if (connectionString.getReadConcern() != null) {
            builder.readConcern(connectionString.getReadConcern());
        }
        if (connectionString.getWriteConcern() != null) {
            builder.writeConcern(connectionString.getWriteConcern());
        }
        if (connectionString.getApplicationName() != null) {
            builder.applicationName(connectionString.getApplicationName());
        }
        builder.compressorList(connectionString.getCompressorList());
        return MongoClients.create(builder.build(), mongoDriverInformation, connectionString.getStreamType());
    }

    private static MongoClient create(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation, String requestedStreamType) {
        String streamType = MongoClients.getStreamType(requestedStreamType);
        if (MongoClients.isNetty(streamType) && settings.getStreamFactoryFactory() == null) {
            return NettyMongoClients.create(settings, mongoDriverInformation);
        }
        StreamFactory streamFactory = MongoClients.getStreamFactory(settings.getStreamFactoryFactory(), settings.getSocketSettings(), settings.getSslSettings(), streamType);
        StreamFactory heartbeatStreamFactory = MongoClients.getStreamFactory(settings.getStreamFactoryFactory(), settings.getHeartbeatSocketSettings(), settings.getSslSettings(), streamType);
        return MongoClients.createMongoClient(settings, mongoDriverInformation, streamFactory, heartbeatStreamFactory, null);
    }

    static MongoClient createMongoClient(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, Closeable externalResourceCloser) {
        return new MongoClientImpl(settings, new DefaultClusterFactory().createCluster(settings.getClusterSettings(), settings.getServerSettings(), settings.getConnectionPoolSettings(), streamFactory, heartbeatStreamFactory, settings.getCredentialList(), EventListenerHelper.getCommandListener(settings.getCommandListeners()), settings.getApplicationName(), mongoDriverInformation, settings.getCompressorList()), externalResourceCloser);
    }

    public static CodecRegistry getDefaultCodecRegistry() {
        return DEFAULT_CODEC_REGISTRY;
    }

    private static StreamFactory getStreamFactory(StreamFactoryFactory streamFactoryFactory, SocketSettings socketSettings, SslSettings sslSettings, String streamType) {
        if (streamFactoryFactory != null) {
            return streamFactoryFactory.create(socketSettings, sslSettings);
        }
        if (MongoClients.isNio2(streamType)) {
            return new AsynchronousSocketChannelStreamFactory(socketSettings, sslSettings);
        }
        throw new IllegalArgumentException("Unsupported stream type: " + streamType);
    }

    private static boolean isNetty(String streamType) {
        return streamType.toLowerCase().equals("netty");
    }

    private static boolean isNio2(String streamType) {
        return streamType.toLowerCase().equals("nio2");
    }

    private static String getStreamType(String requestedStreamType) {
        if (requestedStreamType != null) {
            return requestedStreamType;
        }
        return System.getProperty("org.mongodb.async.type", "nio2");
    }

    private MongoClients() {
    }
}

