/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client.internal;

import com.mongodb.Block;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoTimeoutException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClients;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.internal.capi.MongoCryptOptionsHelper;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.RawBsonDocument;
import org.bson.conversions.Bson;

class CommandMarker
implements Closeable {
    private MongoClient client;
    private final ProcessBuilder processBuilder;
    private boolean active;

    CommandMarker(Map<String, Object> options) {
        String connectionString = options.containsKey("mongocryptdURI") ? (String)options.get("mongocryptdURI") : "mongodb://localhost:27020";
        this.client = MongoClients.create(MongoClientSettings.builder().applyConnectionString(new ConnectionString(connectionString)).applyToClusterSettings((Block)new Block<ClusterSettings.Builder>(){

            public void apply(ClusterSettings.Builder builder) {
                builder.serverSelectionTimeout(1L, TimeUnit.SECONDS);
            }
        }).build());
        this.active = false;
        this.processBuilder = !options.containsKey("mongocryptdBypassSpawn") || (Boolean)options.get("mongocryptdBypassSpawn") == false ? new ProcessBuilder(MongoCryptOptionsHelper.createMongocryptdSpawnArgs(options)) : null;
    }

    void mark(String databaseName, RawBsonDocument command, final SingleResultCallback<RawBsonDocument> callback) {
        SingleResultCallback<RawBsonDocument> wrappedCallback = new SingleResultCallback<RawBsonDocument>(){

            public void onResult(RawBsonDocument result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, (Throwable)new MongoClientException("Exception in encryption library: " + t.getMessage(), t));
                } else {
                    callback.onResult((Object)result, null);
                }
            }
        };
        this.executeCommand(databaseName, command, new SingleResultCallback<RawBsonDocument>((SingleResultCallback)wrappedCallback, databaseName, command){
            final /* synthetic */ SingleResultCallback val$wrappedCallback;
            final /* synthetic */ String val$databaseName;
            final /* synthetic */ RawBsonDocument val$command;
            {
                this.val$wrappedCallback = singleResultCallback;
                this.val$databaseName = string;
                this.val$command = rawBsonDocument;
            }

            public void onResult(RawBsonDocument result, Throwable t) {
                if (t == null) {
                    this.val$wrappedCallback.onResult((Object)result, null);
                } else if (t instanceof MongoTimeoutException && CommandMarker.this.processBuilder != null) {
                    CommandMarker.this.executeCommand(this.val$databaseName, this.val$command, (SingleResultCallback<RawBsonDocument>)this.val$wrappedCallback);
                } else {
                    this.val$wrappedCallback.onResult(null, t);
                }
            }
        });
    }

    @Override
    public void close() {
        this.client.close();
    }

    private void executeCommand(final String databaseName, final RawBsonDocument markableCommand, final SingleResultCallback<RawBsonDocument> callback) {
        this.spawnIfNecessary(new SingleResultCallback<Void>(){

            public void onResult(Void result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    CommandMarker.this.client.getDatabase(databaseName).withReadConcern(ReadConcern.DEFAULT).withReadPreference(ReadPreference.primary()).runCommand((Bson)markableCommand, RawBsonDocument.class, callback);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void spawnIfNecessary(SingleResultCallback<Void> callback) {
        try {
            if (this.processBuilder != null) {
                CommandMarker commandMarker = this;
                synchronized (commandMarker) {
                    if (!this.active) {
                        this.processBuilder.start();
                        this.active = true;
                    }
                }
            }
            callback.onResult(null, null);
        }
        catch (Throwable t) {
            callback.onResult(null, (Throwable)new MongoClientException("Exception starting mongocryptd process. Is `mongocryptd` on the system path?", t));
        }
    }
}

