/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.MongoException;
import com.mongodb.async.client.Observer;
import com.mongodb.async.client.Subscription;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

abstract class AbstractSubscription<TResult>
implements Subscription {
    private static final Logger LOGGER = Loggers.getLogger((String)"client");
    private final Observer<? super TResult> observer;
    private boolean requestedData;
    private boolean isProcessing;
    private long requested = 0L;
    private boolean isUnsubscribed = false;
    private boolean isTerminated = false;
    private final ConcurrentLinkedQueue<TResult> resultsQueue = new ConcurrentLinkedQueue();

    AbstractSubscription(Observer<? super TResult> observer) {
        this.observer = observer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe() {
        boolean unsubscribe = false;
        AbstractSubscription abstractSubscription = this;
        synchronized (abstractSubscription) {
            if (!this.isUnsubscribed) {
                unsubscribe = true;
                this.isUnsubscribed = true;
                this.isTerminated = true;
            }
        }
        if (unsubscribe) {
            this.postTerminate();
        }
    }

    @Override
    public synchronized boolean isUnsubscribed() {
        return this.isUnsubscribed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(long n) {
        if (n < 1L) {
            throw new IllegalArgumentException("Number requested must be > 0: " + n);
        }
        boolean requestData = false;
        AbstractSubscription abstractSubscription = this;
        synchronized (abstractSubscription) {
            this.requested = this.requested + n < 1L ? Long.MAX_VALUE : (this.requested += n);
            if (!this.requestedData) {
                this.requestedData = true;
                requestData = true;
            }
        }
        if (requestData) {
            this.tryRequestInitialData();
        } else {
            this.tryProcessResultsQueue();
        }
    }

    abstract void requestInitialData();

    void requestMoreData() {
    }

    void postTerminate() {
    }

    abstract boolean checkCompleted();

    synchronized boolean isTerminated() {
        return this.isTerminated;
    }

    synchronized long getRequested() {
        return this.requested;
    }

    void addToQueue(@Nullable TResult result) {
        if (result != null) {
            this.resultsQueue.add(result);
        }
    }

    void addToQueue(@Nullable List<TResult> results) {
        if (results != null) {
            this.resultsQueue.addAll(results);
        }
    }

    void onError(Throwable t) {
        if (this.terminalAction()) {
            this.postTerminate();
            try {
                this.observer.onError(t);
            }
            catch (Throwable t1) {
                LOGGER.error("Calling onError threw an exception", t1);
                throw MongoException.fromThrowableNonNull((Throwable)t1);
            }
        } else {
            throw MongoException.fromThrowableNonNull((Throwable)t);
        }
    }

    void onNext(TResult next) {
        if (!this.isTerminated()) {
            try {
                this.observer.onNext(next);
            }
            catch (Throwable t) {
                LOGGER.error("Calling onNext threw an exception", t);
                this.onError(t);
            }
        }
    }

    void onComplete() {
        if (this.terminalAction()) {
            this.postTerminate();
            try {
                this.observer.onComplete();
            }
            catch (Throwable t) {
                LOGGER.error("Calling onComplete threw an exception", t);
                throw MongoException.fromThrowableNonNull((Throwable)t);
            }
        }
    }

    private void tryRequestInitialData() {
        try {
            this.requestInitialData();
        }
        catch (Throwable t) {
            this.onError(t);
        }
    }

    void tryProcessResultsQueue() {
        try {
            this.processResultsQueue();
        }
        catch (Throwable t) {
            this.onError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResultsQueue() {
        boolean mustProcess = false;
        AbstractSubscription abstractSubscription = this;
        synchronized (abstractSubscription) {
            if (!this.isProcessing && !this.isTerminated) {
                this.isProcessing = true;
                mustProcess = true;
            }
        }
        if (mustProcess) {
            boolean requestMore = false;
            long processedCount = 0L;
            boolean completed = false;
            block6: while (true) {
                long localWanted;
                AbstractSubscription abstractSubscription2 = this;
                synchronized (abstractSubscription2) {
                    this.requested -= processedCount;
                    if (this.resultsQueue.isEmpty()) {
                        completed = this.checkCompleted();
                        requestMore = this.requested > 0L;
                        this.isProcessing = false;
                        break;
                    }
                    if (this.requested == 0L) {
                        this.isProcessing = false;
                        break;
                    }
                    localWanted = this.requested;
                }
                processedCount = 0L;
                while (true) {
                    TResult item;
                    if (localWanted <= 0L || (item = this.resultsQueue.poll()) == null) continue block6;
                    this.onNext(item);
                    --localWanted;
                    ++processedCount;
                }
                break;
            }
            if (completed) {
                this.onComplete();
            } else if (requestMore) {
                this.requestMoreData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean terminalAction() {
        boolean isTerminal = false;
        AbstractSubscription abstractSubscription = this;
        synchronized (abstractSubscription) {
            if (!this.isTerminated) {
                this.isTerminated = true;
                isTerminal = true;
            }
        }
        return isTerminal;
    }
}

