/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ClientSession;
import com.mongodb.binding.AsyncClusterBinding;
import com.mongodb.binding.AsyncConnectionSource;
import com.mongodb.binding.AsyncReadWriteBinding;
import com.mongodb.binding.AsyncSingleServerBinding;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.Server;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.session.ClientSessionContext;
import com.mongodb.selector.ReadPreferenceServerSelector;
import com.mongodb.selector.ServerSelector;
import com.mongodb.session.SessionContext;

class ClientSessionBinding
implements AsyncReadWriteBinding {
    private final AsyncClusterBinding wrapped;
    private final ClientSession session;
    private final boolean ownsSession;
    private final ClientSessionContext sessionContext;

    ClientSessionBinding(ClientSession session, boolean ownsSession, AsyncReadWriteBinding wrapped) {
        this.wrapped = (AsyncClusterBinding)Assertions.notNull((String)"wrapped", (Object)((AsyncClusterBinding)wrapped));
        this.ownsSession = ownsSession;
        this.session = (ClientSession)Assertions.notNull((String)"session", (Object)session);
        this.sessionContext = new AsyncClientSessionContext(session);
    }

    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    public void getReadConnectionSource(final SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getReadConnectionSource((SingleResultCallback)new SingleResultCallback<AsyncConnectionSource>(){

            public void onResult(AsyncConnectionSource result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    ClientSessionBinding.this.wrapConnectionSource(result, (SingleResultCallback<AsyncConnectionSource>)callback);
                }
            }
        });
    }

    public void getWriteConnectionSource(final SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getWriteConnectionSource((SingleResultCallback)new SingleResultCallback<AsyncConnectionSource>(){

            public void onResult(AsyncConnectionSource result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    ClientSessionBinding.this.wrapConnectionSource(result, (SingleResultCallback<AsyncConnectionSource>)callback);
                }
            }
        });
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    private void wrapConnectionSource(AsyncConnectionSource connectionSource, final SingleResultCallback<AsyncConnectionSource> callback) {
        if (this.isActiveShardedTxn()) {
            if (this.session.getPinnedServerAddress() == null) {
                this.wrapped.getCluster().selectServerAsync((ServerSelector)new ReadPreferenceServerSelector(this.wrapped.getReadPreference()), (SingleResultCallback)new SingleResultCallback<Server>(){

                    public void onResult(Server server, Throwable t) {
                        if (t != null) {
                            callback.onResult(null, t);
                        } else {
                            ClientSessionBinding.this.session.setPinnedServerAddress(server.getDescription().getAddress());
                            ClientSessionBinding.this.setSingleServerBindingConnectionSource((SingleResultCallback<AsyncConnectionSource>)callback);
                        }
                    }
                });
            } else {
                this.setSingleServerBindingConnectionSource(callback);
            }
        } else {
            callback.onResult((Object)new SessionBindingAsyncConnectionSource(connectionSource), null);
        }
    }

    private void setSingleServerBindingConnectionSource(final SingleResultCallback<AsyncConnectionSource> callback) {
        final AsyncSingleServerBinding binding = new AsyncSingleServerBinding(this.wrapped.getCluster(), this.session.getPinnedServerAddress(), this.wrapped.getReadPreference());
        binding.getWriteConnectionSource((SingleResultCallback)new SingleResultCallback<AsyncConnectionSource>(){

            public void onResult(AsyncConnectionSource result, Throwable t) {
                binding.release();
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)new SessionBindingAsyncConnectionSource(result), null);
                }
            }
        });
    }

    public int getCount() {
        return this.wrapped.getCount();
    }

    public AsyncReadWriteBinding retain() {
        this.wrapped.retain();
        return this;
    }

    public void release() {
        this.wrapped.release();
        this.closeSessionIfCountIsZero();
    }

    private void closeSessionIfCountIsZero() {
        if (this.getCount() == 0 && this.ownsSession) {
            this.session.close();
        }
    }

    private boolean isActiveShardedTxn() {
        return this.session.hasActiveTransaction() && this.wrapped.getCluster().getDescription().getType() == ClusterType.SHARDED;
    }

    private final class AsyncClientSessionContext
    extends ClientSessionContext
    implements SessionContext {
        private final ClientSession clientSession;

        AsyncClientSessionContext(ClientSession clientSession) {
            super((com.mongodb.session.ClientSession)clientSession);
            this.clientSession = clientSession;
        }

        public boolean isImplicitSession() {
            return ClientSessionBinding.this.ownsSession;
        }

        public boolean notifyMessageSent() {
            return this.clientSession.notifyMessageSent();
        }

        public boolean hasActiveTransaction() {
            return this.clientSession.hasActiveTransaction();
        }

        public ReadConcern getReadConcern() {
            if (this.clientSession.hasActiveTransaction()) {
                return this.clientSession.getTransactionOptions().getReadConcern();
            }
            return ClientSessionBinding.this.wrapped.getSessionContext().getReadConcern();
        }
    }

    private class SessionBindingAsyncConnectionSource
    implements AsyncConnectionSource {
        private AsyncConnectionSource wrapped;

        SessionBindingAsyncConnectionSource(AsyncConnectionSource wrapped) {
            this.wrapped = wrapped;
        }

        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        public SessionContext getSessionContext() {
            return ClientSessionBinding.this.sessionContext;
        }

        public void getConnection(SingleResultCallback<AsyncConnection> callback) {
            this.wrapped.getConnection(callback);
        }

        public AsyncConnectionSource retain() {
            this.wrapped = this.wrapped.retain();
            return this;
        }

        public int getCount() {
            return this.wrapped.getCount();
        }

        public void release() {
            this.wrapped.release();
            ClientSessionBinding.this.closeSessionIfCountIsZero();
        }
    }
}

