/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AggregateIterable;
import com.mongodb.async.client.DistinctIterable;
import com.mongodb.async.client.FindIterable;
import com.mongodb.async.client.ListIndexesIterable;
import com.mongodb.async.client.MapReduceIterable;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;

@ThreadSafe
public interface MongoCollection<T> {
    public MongoNamespace getNamespace();

    public Class<T> getDefaultClass();

    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public <C> MongoCollection<C> withDefaultClass(Class<C> var1);

    public MongoCollection<T> withCodecRegistry(CodecRegistry var1);

    public MongoCollection<T> withReadPreference(ReadPreference var1);

    public MongoCollection<T> withWriteConcern(WriteConcern var1);

    public void count(SingleResultCallback<Long> var1);

    public void count(Object var1, SingleResultCallback<Long> var2);

    public void count(Object var1, CountOptions var2, SingleResultCallback<Long> var3);

    public <C> DistinctIterable<C> distinct(String var1, Class<C> var2);

    public FindIterable<T> find();

    public <C> FindIterable<C> find(Class<C> var1);

    public FindIterable<T> find(Object var1);

    public <C> FindIterable<C> find(Object var1, Class<C> var2);

    public AggregateIterable<Document> aggregate(List<?> var1);

    public <C> AggregateIterable<C> aggregate(List<?> var1, Class<C> var2);

    public MapReduceIterable<Document> mapReduce(String var1, String var2);

    public <C> MapReduceIterable<C> mapReduce(String var1, String var2, Class<C> var3);

    public void bulkWrite(List<? extends WriteModel<? extends T>> var1, SingleResultCallback<BulkWriteResult> var2);

    public void bulkWrite(List<? extends WriteModel<? extends T>> var1, BulkWriteOptions var2, SingleResultCallback<BulkWriteResult> var3);

    public void insertOne(T var1, SingleResultCallback<Void> var2);

    public void insertMany(List<? extends T> var1, SingleResultCallback<Void> var2);

    public void insertMany(List<? extends T> var1, InsertManyOptions var2, SingleResultCallback<Void> var3);

    public void deleteOne(Object var1, SingleResultCallback<DeleteResult> var2);

    public void deleteMany(Object var1, SingleResultCallback<DeleteResult> var2);

    public void replaceOne(Object var1, T var2, SingleResultCallback<UpdateResult> var3);

    public void replaceOne(Object var1, T var2, UpdateOptions var3, SingleResultCallback<UpdateResult> var4);

    public void updateOne(Object var1, Object var2, SingleResultCallback<UpdateResult> var3);

    public void updateOne(Object var1, Object var2, UpdateOptions var3, SingleResultCallback<UpdateResult> var4);

    public void updateMany(Object var1, Object var2, SingleResultCallback<UpdateResult> var3);

    public void updateMany(Object var1, Object var2, UpdateOptions var3, SingleResultCallback<UpdateResult> var4);

    public void findOneAndDelete(Object var1, SingleResultCallback<T> var2);

    public void findOneAndDelete(Object var1, FindOneAndDeleteOptions var2, SingleResultCallback<T> var3);

    public void findOneAndReplace(Object var1, T var2, SingleResultCallback<T> var3);

    public void findOneAndReplace(Object var1, T var2, FindOneAndReplaceOptions var3, SingleResultCallback<T> var4);

    public void findOneAndUpdate(Object var1, Object var2, SingleResultCallback<T> var3);

    public void findOneAndUpdate(Object var1, Object var2, FindOneAndUpdateOptions var3, SingleResultCallback<T> var4);

    public void dropCollection(SingleResultCallback<Void> var1);

    public void createIndex(Object var1, SingleResultCallback<Void> var2);

    public void createIndex(Object var1, CreateIndexOptions var2, SingleResultCallback<Void> var3);

    public ListIndexesIterable<Document> listIndexes();

    public <C> ListIndexesIterable<C> listIndexes(Class<C> var1);

    public void dropIndex(String var1, SingleResultCallback<Void> var2);

    public void dropIndexes(SingleResultCallback<Void> var1);

    public void renameCollection(MongoNamespace var1, SingleResultCallback<Void> var2);

    public void renameCollection(MongoNamespace var1, RenameCollectionOptions var2, SingleResultCallback<Void> var3);
}

