/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.crypt.capi;

import com.mongodb.crypt.capi.MongoCryptException;
import com.mongodb.internal.crypt.capi.MongoKeyDecryptor;
import java.io.Closeable;
import org.bson.BsonDocument;
import org.bson.RawBsonDocument;

public interface MongoCryptContext
extends Closeable {
    public State getState();

    public RawBsonDocument getMongoOperation();

    public void addMongoOperationResult(BsonDocument var1);

    public void completeMongoOperation();

    public void provideKmsProviderCredentials(BsonDocument var1);

    public MongoKeyDecryptor nextKeyDecryptor();

    public void completeKeyDecryptors();

    public RawBsonDocument finish();

    @Override
    public void close();

    public static enum State {
        NEED_MONGO_COLLINFO(1),
        NEED_MONGO_MARKINGS(2),
        NEED_MONGO_KEYS(3),
        NEED_KMS(4),
        NEED_KMS_CREDENTIALS(7),
        READY(5),
        DONE(6);

        private final int index;

        private State(int index) {
            this.index = index;
        }

        static State fromIndex(int index) {
            for (State state : State.values()) {
                if (state.index != index) continue;
                return state;
            }
            throw new MongoCryptException("Unknown context state " + index);
        }
    }
}

