/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.crypt.capi;

import com.mongodb.crypt.capi.CAPI;
import org.bson.assertions.Assertions;

public class MongoCryptException
extends RuntimeException {
    private static final long serialVersionUID = -5524416583514807953L;
    private final int code;

    public MongoCryptException(String msg) {
        super(msg);
        this.code = -1;
    }

    public MongoCryptException(String msg, Throwable cause) {
        super(msg, cause);
        this.code = -1;
    }

    MongoCryptException(CAPI.mongocrypt_status_t status) {
        super(CAPI.mongocrypt_status_message(status, null).toString());
        Assertions.isTrue((String)"status not ok", (!CAPI.mongocrypt_status_ok(status) ? 1 : 0) != 0);
        this.code = CAPI.mongocrypt_status_code(status);
    }

    public int getCode() {
        return this.code;
    }
}

