/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.crypt.capi;

import com.mongodb.crypt.capi.BinaryHolder;
import com.mongodb.crypt.capi.CAPI;
import com.mongodb.crypt.capi.CAPIHelper;
import com.mongodb.crypt.capi.CipherCallback;
import com.mongodb.crypt.capi.Logger;
import com.mongodb.crypt.capi.Loggers;
import com.mongodb.crypt.capi.MacCallback;
import com.mongodb.crypt.capi.MessageDigestCallback;
import com.mongodb.crypt.capi.MongoCrypt;
import com.mongodb.crypt.capi.MongoCryptContext;
import com.mongodb.crypt.capi.MongoCryptContextImpl;
import com.mongodb.crypt.capi.MongoCryptException;
import com.mongodb.crypt.capi.MongoCryptOptions;
import com.mongodb.crypt.capi.MongoDataKeyOptions;
import com.mongodb.crypt.capi.MongoExplicitEncryptOptions;
import com.mongodb.crypt.capi.SecureRandomCallback;
import com.mongodb.crypt.capi.SigningRSAESPKCSCallback;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.assertions.Assertions;

class MongoCryptImpl
implements MongoCrypt {
    private static final Logger LOGGER = Loggers.getLogger();
    private static final String INDEXED = "Indexed";
    private static final String UNINDEXED = "Unindexed";
    private final CAPI.mongocrypt_t wrapped;
    private final LogCallback logCallback;
    private final CipherCallback aesCBC256EncryptCallback;
    private final CipherCallback aesCBC256DecryptCallback;
    private final CipherCallback aesCTR256EncryptCallback;
    private final CipherCallback aesCTR256DecryptCallback;
    private final MacCallback hmacSha512Callback;
    private final MacCallback hmacSha256Callback;
    private final MessageDigestCallback sha256Callback;
    private final SecureRandomCallback secureRandomCallback;
    private final SigningRSAESPKCSCallback signingRSAESPKCSCallback;
    private final AtomicBoolean closed = new AtomicBoolean();

    MongoCryptImpl(MongoCryptOptions options) {
        Throwable throwable;
        Throwable throwable2;
        this.wrapped = CAPI.mongocrypt_new();
        if (this.wrapped == null) {
            throw new MongoCryptException("Unable to create new mongocrypt object");
        }
        this.logCallback = new LogCallback();
        this.configure(() -> CAPI.mongocrypt_setopt_log_handler(this.wrapped, this.logCallback, null));
        this.aesCBC256EncryptCallback = new CipherCallback("AES", "AES/CBC/NoPadding", 1);
        this.aesCBC256DecryptCallback = new CipherCallback("AES", "AES/CBC/NoPadding", 2);
        this.aesCTR256EncryptCallback = new CipherCallback("AES", "AES/CTR/NoPadding", 1);
        this.aesCTR256DecryptCallback = new CipherCallback("AES", "AES/CTR/NoPadding", 2);
        this.hmacSha512Callback = new MacCallback("HmacSHA512");
        this.hmacSha256Callback = new MacCallback("HmacSHA256");
        this.sha256Callback = new MessageDigestCallback("SHA-256");
        this.secureRandomCallback = new SecureRandomCallback(new SecureRandom());
        this.configure(() -> CAPI.mongocrypt_setopt_crypto_hooks(this.wrapped, this.aesCBC256EncryptCallback, this.aesCBC256DecryptCallback, this.secureRandomCallback, this.hmacSha512Callback, this.hmacSha256Callback, this.sha256Callback, null));
        this.signingRSAESPKCSCallback = new SigningRSAESPKCSCallback();
        this.configure(() -> CAPI.mongocrypt_setopt_crypto_hook_sign_rsaes_pkcs1_v1_5(this.wrapped, this.signingRSAESPKCSCallback, null));
        this.configure(() -> CAPI.mongocrypt_setopt_aes_256_ctr(this.wrapped, this.aesCTR256EncryptCallback, this.aesCTR256DecryptCallback, null));
        if (options.getLocalKmsProviderOptions() != null) {
            throwable2 = null;
            try (BinaryHolder localMasterKeyBinaryHolder = CAPIHelper.toBinary(options.getLocalKmsProviderOptions().getLocalMasterKey());){
                this.configure(() -> CAPI.mongocrypt_setopt_kms_provider_local(this.wrapped, localMasterKeyBinaryHolder.getBinary()));
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
        }
        if (options.getAwsKmsProviderOptions() != null) {
            this.configure(() -> CAPI.mongocrypt_setopt_kms_provider_aws(this.wrapped, new CAPI.cstring(options.getAwsKmsProviderOptions().getAccessKeyId()), -1, new CAPI.cstring(options.getAwsKmsProviderOptions().getSecretAccessKey()), -1));
        }
        if (options.isNeedsKmsCredentialsStateEnabled()) {
            CAPI.mongocrypt_setopt_use_need_kms_credentials_state(this.wrapped);
        }
        if (options.getKmsProviderOptions() != null) {
            throwable2 = null;
            try (BinaryHolder binaryHolder = CAPIHelper.toBinary(options.getKmsProviderOptions());){
                this.configure(() -> CAPI.mongocrypt_setopt_kms_providers(this.wrapped, binaryHolder.getBinary()));
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                throw throwable4;
            }
        }
        if (options.getLocalSchemaMap() != null) {
            BsonDocument localSchemaMapDocument = new BsonDocument();
            localSchemaMapDocument.putAll(options.getLocalSchemaMap());
            throwable = null;
            try (BinaryHolder localSchemaMapBinaryHolder = CAPIHelper.toBinary(localSchemaMapDocument);){
                this.configure(() -> CAPI.mongocrypt_setopt_schema_map(this.wrapped, localSchemaMapBinaryHolder.getBinary()));
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
        }
        if (options.isBypassQueryAnalysis()) {
            CAPI.mongocrypt_setopt_bypass_query_analysis(this.wrapped);
        }
        if (options.getEncryptedFieldsMap() != null) {
            BsonDocument localEncryptedFieldsMap = new BsonDocument();
            localEncryptedFieldsMap.putAll(options.getEncryptedFieldsMap());
            throwable = null;
            try (BinaryHolder localEncryptedFieldsMapHolder = CAPIHelper.toBinary(localEncryptedFieldsMap);){
                this.configure(() -> CAPI.mongocrypt_setopt_encrypted_field_config_map(this.wrapped, localEncryptedFieldsMapHolder.getBinary()));
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
        }
        options.getSearchPaths().forEach(p -> CAPI.mongocrypt_setopt_append_crypt_shared_lib_search_path(this.wrapped, new CAPI.cstring((String)p)));
        if (options.getExtraOptions().containsKey((Object)"cryptSharedLibPath")) {
            CAPI.mongocrypt_setopt_set_crypt_shared_lib_path_override(this.wrapped, new CAPI.cstring(options.getExtraOptions().getString((Object)"cryptSharedLibPath").getValue()));
        }
        this.configure(() -> CAPI.mongocrypt_init(this.wrapped));
    }

    @Override
    public MongoCryptContext createEncryptionContext(String database, BsonDocument commandDocument) {
        Assertions.isTrue((String)"open", (!this.closed.get() ? 1 : 0) != 0);
        Assertions.notNull((String)"database", (Object)database);
        Assertions.notNull((String)"commandDocument", (Object)commandDocument);
        CAPI.mongocrypt_ctx_t context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        try (BinaryHolder commandDocumentBinaryHolder = CAPIHelper.toBinary(commandDocument);){
            this.configure(() -> CAPI.mongocrypt_ctx_encrypt_init(context, new CAPI.cstring(database), -1, commandDocumentBinaryHolder.getBinary()), context);
            MongoCryptContextImpl mongoCryptContextImpl = new MongoCryptContextImpl(context);
            return mongoCryptContextImpl;
        }
    }

    @Override
    public MongoCryptContext createDecryptionContext(BsonDocument document) {
        Assertions.isTrue((String)"open", (!this.closed.get() ? 1 : 0) != 0);
        CAPI.mongocrypt_ctx_t context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        try (BinaryHolder documentBinaryHolder = CAPIHelper.toBinary(document);){
            this.configure(() -> CAPI.mongocrypt_ctx_decrypt_init(context, documentBinaryHolder.getBinary()), context);
        }
        return new MongoCryptContextImpl(context);
    }

    @Override
    public MongoCryptContext createDataKeyContext(String kmsProvider, MongoDataKeyOptions options) {
        Assertions.isTrue((String)"open", (!this.closed.get() ? 1 : 0) != 0);
        CAPI.mongocrypt_ctx_t context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        if (kmsProvider.equals("aws")) {
            this.configure(() -> CAPI.mongocrypt_ctx_setopt_masterkey_aws(context, new CAPI.cstring(options.getMasterKey().getString((Object)"region").getValue()), -1, new CAPI.cstring(options.getMasterKey().getString((Object)"key").getValue()), -1), context);
            if (options.getMasterKey().containsKey((Object)"endpoint")) {
                this.configure(() -> CAPI.mongocrypt_ctx_setopt_masterkey_aws_endpoint(context, new CAPI.cstring(options.getMasterKey().getString((Object)"endpoint").getValue()), -1), context);
            }
        } else if (kmsProvider.equals("local")) {
            this.configure(() -> CAPI.mongocrypt_ctx_setopt_masterkey_local(context), context);
        } else {
            BsonDocument masterKey = options.getMasterKey().clone();
            masterKey.put("provider", (BsonValue)new BsonString(kmsProvider));
            try (BinaryHolder masterKeyHolder = CAPIHelper.toBinary(masterKey);){
                this.configure(() -> CAPI.mongocrypt_ctx_setopt_key_encryption_key(context, masterKeyHolder.getBinary()), context);
            }
        }
        if (options.getKeyAltNames() != null) {
            for (String cur : options.getKeyAltNames()) {
                BinaryHolder keyAltNameBinaryHolder = CAPIHelper.toBinary(new BsonDocument("keyAltName", (BsonValue)new BsonString(cur)));
                Throwable throwable = null;
                try {
                    this.configure(() -> CAPI.mongocrypt_ctx_setopt_key_alt_name(context, keyAltNameBinaryHolder.getBinary()), context);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (keyAltNameBinaryHolder == null) continue;
                    if (throwable != null) {
                        try {
                            keyAltNameBinaryHolder.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    keyAltNameBinaryHolder.close();
                }
            }
        }
        if (!CAPI.mongocrypt_ctx_datakey_init(context)) {
            MongoCryptContextImpl.throwExceptionFromStatus(context);
        }
        return new MongoCryptContextImpl(context);
    }

    @Override
    public MongoCryptContext createExplicitEncryptionContext(BsonDocument document, MongoExplicitEncryptOptions options) {
        Throwable throwable;
        Assertions.isTrue((String)"open", (!this.closed.get() ? 1 : 0) != 0);
        CAPI.mongocrypt_ctx_t context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        if (options.getKeyId() != null) {
            throwable = null;
            try (BinaryHolder keyIdBinaryHolder = CAPIHelper.toBinary(ByteBuffer.wrap(options.getKeyId().getData()));){
                this.configure(() -> CAPI.mongocrypt_ctx_setopt_key_id(context, keyIdBinaryHolder.getBinary()), context);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        if (options.getKeyAltName() != null) {
            throwable = null;
            try (BinaryHolder keyAltNameBinaryHolder = CAPIHelper.toBinary(new BsonDocument("keyAltName", (BsonValue)new BsonString(options.getKeyAltName())));){
                this.configure(() -> CAPI.mongocrypt_ctx_setopt_key_alt_name(context, keyAltNameBinaryHolder.getBinary()), context);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        if (INDEXED.equalsIgnoreCase(options.getAlgorithm())) {
            this.configure(() -> CAPI.mongocrypt_ctx_setopt_index_type(context, 2), context);
            if (options.getQueryType() != null) {
                this.configure(() -> CAPI.mongocrypt_ctx_setopt_query_type(context, options.getQueryType().getQueryType()), context);
            }
            if (options.getContentionFactor() != null) {
                this.configure(() -> CAPI.mongocrypt_ctx_setopt_contention_factor(context, options.getContentionFactor()), context);
            }
        } else if (options.getAlgorithm().equalsIgnoreCase(UNINDEXED)) {
            this.configure(() -> CAPI.mongocrypt_ctx_setopt_index_type(context, 1), context);
        } else {
            this.configure(() -> CAPI.mongocrypt_ctx_setopt_algorithm(context, new CAPI.cstring(options.getAlgorithm()), -1), context);
        }
        throwable = null;
        try (BinaryHolder documentBinaryHolder = CAPIHelper.toBinary(document);){
            this.configure(() -> CAPI.mongocrypt_ctx_explicit_encrypt_init(context, documentBinaryHolder.getBinary()), context);
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        return new MongoCryptContextImpl(context);
    }

    @Override
    public MongoCryptContext createExplicitDecryptionContext(BsonDocument document) {
        Assertions.isTrue((String)"open", (!this.closed.get() ? 1 : 0) != 0);
        CAPI.mongocrypt_ctx_t context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        try (BinaryHolder binaryHolder = CAPIHelper.toBinary(document);){
            this.configure(() -> CAPI.mongocrypt_ctx_explicit_decrypt_init(context, binaryHolder.getBinary()), context);
        }
        return new MongoCryptContextImpl(context);
    }

    @Override
    public String getCryptSharedLibVersionString() {
        CAPI.cstring versionString = CAPI.mongocrypt_crypt_shared_lib_version_string(this.wrapped, null);
        return versionString == null ? null : versionString.toString();
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            CAPI.mongocrypt_destroy(this.wrapped);
        }
    }

    private void configure(Supplier<Boolean> successSupplier) {
        if (!successSupplier.get().booleanValue()) {
            this.throwExceptionFromStatus();
        }
    }

    private void configure(Supplier<Boolean> successSupplier, CAPI.mongocrypt_ctx_t context) {
        if (!successSupplier.get().booleanValue()) {
            MongoCryptContextImpl.throwExceptionFromStatus(context);
        }
    }

    private void throwExceptionFromStatus() {
        CAPI.mongocrypt_status_t status = CAPI.mongocrypt_status_new();
        CAPI.mongocrypt_status(this.wrapped, status);
        MongoCryptException e = new MongoCryptException(status);
        CAPI.mongocrypt_status_destroy(status);
        throw e;
    }

    static class LogCallback
    implements CAPI.mongocrypt_log_fn_t {
        LogCallback() {
        }

        @Override
        public void log(int level, CAPI.cstring message, int messageLength, Pointer ctx) {
            if (level == 0) {
                LOGGER.error(message.toString());
            }
            if (level == 1) {
                LOGGER.error(message.toString());
            }
            if (level == 2) {
                LOGGER.warn(message.toString());
            }
            if (level == 3) {
                LOGGER.info(message.toString());
            }
            if (level == 4) {
                LOGGER.trace(message.toString());
            }
        }
    }
}

