/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.crypt.capi;

import org.bson.BsonBinary;

public class MongoExplicitEncryptOptions {
    private final BsonBinary keyId;
    private final String keyAltName;
    private final String algorithm;

    public static Builder builder() {
        return new Builder();
    }

    public BsonBinary getKeyId() {
        return this.keyId;
    }

    public String getKeyAltName() {
        return this.keyAltName;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    private MongoExplicitEncryptOptions(Builder builder) {
        this.keyId = builder.keyId;
        this.keyAltName = builder.keyAltName;
        this.algorithm = builder.algorithm;
    }

    public String toString() {
        return "MongoExplicitEncryptOptions{keyId=" + this.keyId + ", keyAltName=" + this.keyAltName + ", algorithm='" + this.algorithm + "'}";
    }

    public static class Builder {
        private BsonBinary keyId;
        private String keyAltName;
        private String algorithm;

        private Builder() {
        }

        public Builder keyId(BsonBinary keyId) {
            this.keyId = keyId;
            return this;
        }

        public Builder keyAltName(String keyAltName) {
            this.keyAltName = keyAltName;
            return this;
        }

        public Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public MongoExplicitEncryptOptions build() {
            return new MongoExplicitEncryptOptions(this);
        }
    }
}

