/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoNamespace;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.ByteBufferBsonOutput;
import com.mongodb.connection.CommandMessage;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.ReplyMessage;
import com.mongodb.connection.ResponseBuffers;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;

final class CommandHelper {
    static BsonDocument executeCommand(String database, BsonDocument command, InternalConnection internalConnection) {
        return CommandHelper.receiveCommandResult(internalConnection, CommandHelper.sendMessage(database, command, internalConnection));
    }

    static void executeCommandAsync(String database, BsonDocument command, final InternalConnection internalConnection, final SingleResultCallback<BsonDocument> callback) {
        CommandHelper.sendMessageAsync(database, command, internalConnection, new SingleResultCallback<CommandMessage>(){

            @Override
            public void onResult(CommandMessage result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    CommandHelper.receiveReplyAsync(internalConnection, result, new SingleResultCallback<ReplyMessage<BsonDocument>>(){

                        @Override
                        public void onResult(ReplyMessage<BsonDocument> result, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                BsonDocument reply = result.getDocuments().get(0);
                                if (!CommandHelper.isCommandOk(reply)) {
                                    callback.onResult(null, CommandHelper.createCommandFailureException(reply, internalConnection));
                                } else {
                                    callback.onResult(reply, null);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    static BsonDocument executeCommandWithoutCheckingForFailure(String database, BsonDocument command, InternalConnection internalConnection) {
        return CommandHelper.receiveCommandDocument(internalConnection, CommandHelper.sendMessage(database, command, internalConnection));
    }

    static boolean isCommandOk(BsonDocument response) {
        if (!response.containsKey("ok")) {
            return false;
        }
        BsonValue okValue = response.get("ok");
        if (okValue.isBoolean()) {
            return okValue.asBoolean().getValue();
        }
        if (okValue.isNumber()) {
            return okValue.asNumber().intValue() == 1;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CommandMessage sendMessage(String database, BsonDocument command, InternalConnection internalConnection) {
        ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(internalConnection);
        try {
            CommandMessage message = new CommandMessage(new MongoNamespace(database, "$cmd").getFullName(), command, false, MessageSettings.builder().build());
            message.encode(bsonOutput);
            internalConnection.sendMessage(bsonOutput.getByteBuffers(), message.getId());
            CommandMessage commandMessage = message;
            return commandMessage;
        }
        finally {
            bsonOutput.close();
        }
    }

    private static void sendMessageAsync(String database, BsonDocument command, InternalConnection internalConnection, final SingleResultCallback<CommandMessage> callback) {
        final ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(internalConnection);
        try {
            final CommandMessage message = new CommandMessage(new MongoNamespace(database, "$cmd").getFullName(), command, false, MessageSettings.builder().build());
            message.encode(bsonOutput);
            internalConnection.sendMessageAsync(bsonOutput.getByteBuffers(), message.getId(), new SingleResultCallback<Void>(){

                @Override
                public void onResult(Void result, Throwable t) {
                    bsonOutput.close();
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        callback.onResult(message, null);
                    }
                }
            });
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    private static BsonDocument receiveCommandResult(InternalConnection internalConnection, CommandMessage message) {
        BsonDocument result = CommandHelper.receiveReply(internalConnection, message).getDocuments().get(0);
        if (!CommandHelper.isCommandOk(result)) {
            throw CommandHelper.createCommandFailureException(result, internalConnection);
        }
        return result;
    }

    private static BsonDocument receiveCommandDocument(InternalConnection internalConnection, CommandMessage message) {
        return CommandHelper.receiveReply(internalConnection, message).getDocuments().get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReplyMessage<BsonDocument> receiveReply(InternalConnection internalConnection, CommandMessage message) {
        ResponseBuffers responseBuffers = internalConnection.receiveMessage(message.getId());
        if (responseBuffers == null) {
            throw new MongoInternalException(String.format("Response buffers received from %s should not be null", internalConnection));
        }
        try {
            ReplyMessage<BsonDocument> replyMessage = new ReplyMessage<BsonDocument>(responseBuffers, new BsonDocumentCodec(), message.getId());
            return replyMessage;
        }
        finally {
            responseBuffers.close();
        }
    }

    private static void receiveReplyAsync(InternalConnection internalConnection, final CommandMessage message, final SingleResultCallback<ReplyMessage<BsonDocument>> callback) {
        internalConnection.receiveMessageAsync(message.getId(), new SingleResultCallback<ResponseBuffers>(){

            @Override
            public void onResult(ResponseBuffers result, Throwable t) {
                try {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        callback.onResult(new ReplyMessage<BsonDocument>(result, new BsonDocumentCodec(), message.getId()), null);
                    }
                }
                finally {
                    result.close();
                }
            }
        });
    }

    private static MongoCommandException createCommandFailureException(BsonDocument reply, InternalConnection internalConnection) {
        return new MongoCommandException(reply, internalConnection.getDescription().getServerAddress());
    }

    private CommandHelper() {
    }
}

