/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Function;
import com.mongodb.ListCollectionsIterableImpl;
import com.mongodb.MongoCollectionImpl;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ListCollectionsIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.operation.CommandReadOperation;
import com.mongodb.operation.CommandWriteOperation;
import com.mongodb.operation.CreateCollectionOperation;
import com.mongodb.operation.DropDatabaseOperation;
import com.mongodb.operation.OperationExecutor;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;

class MongoDatabaseImpl
implements MongoDatabase {
    private final String name;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final OperationExecutor executor;

    MongoDatabaseImpl(String name, CodecRegistry codecRegistry, ReadPreference readPreference, WriteConcern writeConcern, OperationExecutor executor) {
        this.name = Assertions.notNull("name", name);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.executor = Assertions.notNull("executor", executor);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public MongoDatabase withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoDatabaseImpl(this.name, codecRegistry, this.readPreference, this.writeConcern, this.executor);
    }

    @Override
    public MongoDatabase withReadPreference(ReadPreference readPreference) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, readPreference, this.writeConcern, this.executor);
    }

    @Override
    public MongoDatabase withWriteConcern(WriteConcern writeConcern) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, this.readPreference, writeConcern, this.executor);
    }

    @Override
    public MongoCollection<Document> getCollection(String collectionName) {
        return this.getCollection(collectionName, Document.class);
    }

    @Override
    public <T> MongoCollection<T> getCollection(String collectionName, Class<T> clazz) {
        return new MongoCollectionImpl<T>(new MongoNamespace(this.name, collectionName), clazz, this.codecRegistry, this.readPreference, this.writeConcern, this.executor);
    }

    @Override
    public Document executeCommand(Object command) {
        return this.executeCommand(command, Document.class);
    }

    @Override
    public Document executeCommand(Object command, ReadPreference readPreference) {
        return this.executeCommand(command, readPreference, Document.class);
    }

    @Override
    public <T> T executeCommand(Object command, Class<T> clazz) {
        return this.executor.execute(new CommandWriteOperation<T>(this.getName(), this.asBson(command), this.codecRegistry.get(clazz)));
    }

    @Override
    public <T> T executeCommand(Object command, ReadPreference readPreference, Class<T> clazz) {
        Assertions.notNull("readPreference", readPreference);
        return this.executor.execute(new CommandReadOperation<T>(this.getName(), this.asBson(command), this.codecRegistry.get(clazz)), readPreference);
    }

    @Override
    public void dropDatabase() {
        this.executor.execute(new DropDatabaseOperation(this.name));
    }

    @Override
    public MongoIterable<String> listCollectionNames() {
        return this.listCollections().map(new Function<Document, String>(){

            @Override
            public String apply(Document result) {
                return (String)result.get("name");
            }
        });
    }

    @Override
    public ListCollectionsIterable<Document> listCollections() {
        return this.listCollections(Document.class);
    }

    @Override
    public <C> ListCollectionsIterable<C> listCollections(Class<C> clazz) {
        return new ListCollectionsIterableImpl<C>(this.name, clazz, this.codecRegistry, ReadPreference.primary(), this.executor);
    }

    @Override
    public void createCollection(String collectionName) {
        this.createCollection(collectionName, new CreateCollectionOptions());
    }

    @Override
    public void createCollection(String collectionName, CreateCollectionOptions createCollectionOptions) {
        this.executor.execute(new CreateCollectionOperation(this.name, collectionName).capped(createCollectionOptions.isCapped()).sizeInBytes(createCollectionOptions.getSizeInBytes()).autoIndex(createCollectionOptions.isAutoIndex()).maxDocuments(createCollectionOptions.getMaxDocuments()).usePowerOf2Sizes(createCollectionOptions.isUsePowerOf2Sizes()).storageEngineOptions(this.asBson(createCollectionOptions.getStorageEngineOptions())));
    }

    private BsonDocument asBson(Object document) {
        return BsonDocumentWrapper.asBsonDocument(document, this.codecRegistry);
    }
}

